/*
 * Decompiled with CFR 0.152.
 */
package play.api.test;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import org.apache.pekko.annotation.ApiMayChange;
import play.api.Application;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.Mode;
import play.api.test.Helpers$;
import play.api.test.PlayRunners$;
import play.api.test.RunningServer;
import play.api.test.RunningServer$;
import play.api.test.TestServer;
import play.api.test.TestServerFactory;
import play.core.server.SelfSignedSSLEngineProvider;
import play.core.server.ServerConfig;
import play.core.server.ServerConfig$;
import play.core.server.ServerEndpoints;
import play.core.server.ServerEndpoints$;
import play.core.server.ServerProvider;
import play.core.server.ServerProvider$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

@ApiMayChange
public class DefaultTestServerFactory
implements TestServerFactory {
    @Override
    public RunningServer start(Application app) {
        RunningServer runningServer;
        TestServer testServer = new TestServer(this.serverConfig(app), app, (Option<ServerProvider>)Some$.MODULE$.apply((Object)this.serverProvider(app)));
        Option<Lock> appLock = this.optionalGlobalLock(app);
        appLock.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.lock());
        AutoCloseable stopServer = new AutoCloseable(testServer, appLock){
            private final TestServer testServer$1;
            private final Option appLock$1;
            {
                this.testServer$1 = testServer$2;
                this.appLock$1 = appLock$2;
            }

            public void close() {
                this.testServer$1.stop();
                this.appLock$1.foreach((Function1)((JProcedure1 & Serializable)DefaultTestServerFactory::play$api$test$DefaultTestServerFactory$$anon$1$$_$close$$anonfun$1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$api$test$DefaultTestServerFactory$$anon$1$$_$close$$anonfun$1(java.util.concurrent.locks.Lock )}, serializedLambda);
            }
        };
        try {
            testServer.start();
            runningServer = RunningServer$.MODULE$.apply(app, this.serverEndpoints(testServer), stopServer);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                stopServer.close();
                throw e;
            }
            throw throwable;
        }
        return runningServer;
    }

    public Option<Lock> optionalGlobalLock(Application app) {
        if (app.globalApplicationEnabled()) {
            return Some$.MODULE$.apply((Object)PlayRunners$.MODULE$.mutex());
        }
        return None$.MODULE$;
    }

    public ServerConfig serverConfig(Application app) {
        String string = Helpers$.MODULE$.testServerAddress();
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Helpers$.MODULE$.testServerPort()));
        Option option = Helpers$.MODULE$.testServerHttpsPort();
        File file = app.path();
        ClassLoader classLoader = ServerConfig$.MODULE$.apply$default$1();
        Properties properties = ServerConfig$.MODULE$.apply$default$7();
        ServerConfig sc = ServerConfig$.MODULE$.apply(classLoader, file, (Option)some, option, string, (Mode)Mode.Test$.MODULE$, properties);
        Configuration configuration = this.overrideServerConfiguration(app).withFallback(sc.configuration());
        File file2 = sc.copy$default$1();
        Option option2 = sc.copy$default$2();
        Option option3 = sc.copy$default$3();
        String string2 = sc.copy$default$4();
        Mode mode = sc.copy$default$5();
        Properties properties2 = sc.copy$default$6();
        return sc.copy(file2, option2, option3, string2, mode, properties2, configuration);
    }

    public Configuration overrideServerConfiguration(Application app) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"play.server.https.engineProvider");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)SelfSignedSSLEngineProvider.class.getName());
        return Configuration$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public ServerProvider serverProvider(Application app) {
        return ServerProvider$.MODULE$.fromConfiguration(this.getClass().getClassLoader(), this.serverConfig(app).configuration());
    }

    public ServerEndpoints serverEndpoints(TestServer testServer) {
        if (testServer.isRunning()) {
            return testServer.server().serverEndpoints();
        }
        return ServerEndpoints$.MODULE$.empty();
    }

    public static final /* synthetic */ void play$api$test$DefaultTestServerFactory$$anon$1$$_$close$$anonfun$1(Lock _$2) {
        _$2.unlock();
    }
}

