/*
 * Decompiled with CFR 0.152.
 */
package play.test;

import org.apache.pekko.stream.Materializer;
import org.junit.After;
import org.junit.Before;
import play.Application;
import play.test.Helpers;

public class WithApplication {
    protected Application app;
    protected Materializer mat;

    protected Application provideApplication() {
        return Helpers.fakeApplication();
    }

    protected <T> T instanceOf(Class<T> clazz) {
        return (T)this.app.injector().instanceOf(clazz);
    }

    @Before
    public void startPlay() {
        this.app = this.provideApplication();
        Helpers.start(this.app);
        this.mat = this.app.asScala().materializer();
    }

    @After
    public void stopPlay() {
        if (this.app != null) {
            Helpers.stop(this.app);
            this.app = null;
        }
    }
}

