/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCountUtil;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Instant;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteStringBuilder;
import org.playframework.netty.http.DefaultStreamedHttpResponse;
import org.playframework.netty.http.StreamedHttpRequest;
import org.reactivestreams.Publisher;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.http.HeaderNames$;
import play.api.http.HttpChunk;
import play.api.http.HttpEntity;
import play.api.http.HttpErrorHandler;
import play.api.libs.typedmap.TypedMap$;
import play.api.mvc.Headers;
import play.api.mvc.RequestHeader;
import play.api.mvc.RequestHeaderImpl;
import play.api.mvc.ResponseHeader$;
import play.api.mvc.Result;
import play.api.mvc.request.RemoteConnection;
import play.api.mvc.request.RequestAttrKey$;
import play.api.mvc.request.RequestTarget;
import play.core.server.common.ForwardedHeaderHandler;
import play.core.server.common.PathAndQueryParser$;
import play.core.server.common.ServerResultUtils;
import play.core.server.netty.NettyHeadersWrapper;
import play.core.server.netty.NettyModelConversion$;
import play.core.server.netty.SynchronousMappedStreams$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.java8.JFunction1;
import scala.util.Failure$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public class NettyModelConversion {
    private final ServerResultUtils resultUtils;
    private final ForwardedHeaderHandler forwardedHeaderHandler;
    private final Option<String> serverHeader;
    private final Logger logger;
    private Tuple2<Object, String> cachedDateHeader;

    public NettyModelConversion(ServerResultUtils resultUtils, ForwardedHeaderHandler forwardedHeaderHandler, Option<String> serverHeader) {
        this.resultUtils = resultUtils;
        this.forwardedHeaderHandler = forwardedHeaderHandler;
        this.serverHeader = serverHeader;
        this.logger = Logger$.MODULE$.apply(NettyModelConversion.class);
        this.cachedDateHeader = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)Long.MIN_VALUE), null);
    }

    public Try<RequestHeader> convertRequest(Channel channel, HttpRequest request) {
        if (request.decoderResult().isFailure()) {
            return Failure$.MODULE$.apply(request.decoderResult().cause());
        }
        return this.tryToCreateRequest(channel, request);
    }

    private Try<RequestHeader> tryToCreateRequest(Channel channel, HttpRequest request) {
        return Try$.MODULE$.apply(() -> this.tryToCreateRequest$$anonfun$1(request, channel));
    }

    private RemoteConnection createRemoteConnection(Channel channel, Headers headers) {
        RemoteConnection rawConnection = new RemoteConnection(channel){
            private final Channel channel$3;
            public static final long OFFSET$1;
            public static final long OFFSET$0;
            private volatile Object remoteAddress$lzy1;
            private final Option sslHandler;
            private volatile Object clientCertificateChain$lzy1;
            {
                this.channel$3 = channel$2;
                this.sslHandler = Option$.MODULE$.apply((Object)channel$2.pipeline().get(SslHandler.class));
            }

            static {
                OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic($anon$1.class.getDeclaredField("clientCertificateChain$lzy1"));
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$1.class.getDeclaredField("remoteAddress$lzy1"));
            }

            public InetAddress remoteAddress() {
                Object object = this.remoteAddress$lzy1;
                if (object instanceof InetAddress) {
                    return (InetAddress)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (InetAddress)this.remoteAddress$lzyINIT1();
            }

            private Object remoteAddress$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.remoteAddress$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            InetAddress inetAddress = null;
                            try {
                                inetAddress = ((InetSocketAddress)this.channel$3.remoteAddress()).getAddress();
                                object2 = inetAddress == null ? LazyVals.NullValue$.MODULE$ : inetAddress;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.remoteAddress$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return inetAddress;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            public boolean secure() {
                return this.sslHandler.isDefined();
            }

            public Option clientCertificateChain() {
                Object object = this.clientCertificateChain$lzy1;
                if (object instanceof Option) {
                    return (Option)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (Option)this.clientCertificateChain$lzyINIT1();
            }

            private Object clientCertificateChain$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.clientCertificateChain$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            Option option = null;
                            try {
                                option = this.liftedTree1$1();
                                object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.clientCertificateChain$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return option;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            private final Option liftedTree1$1() {
                None$ none$;
                try {
                    none$ = this.sslHandler.map(NettyModelConversion::play$core$server$netty$NettyModelConversion$$anon$1$$_$liftedTree1$1$$anonfun$1);
                }
                catch (SSLPeerUnverifiedException e) {
                    none$ = None$.MODULE$;
                }
                return none$;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$core$server$netty$NettyModelConversion$$anon$1$$_$liftedTree1$1$$anonfun$1(io.netty.handler.ssl.SslHandler )}, serializedLambda);
            }
        };
        return this.forwardedHeaderHandler.forwardedConnection(rawConnection, headers);
    }

    private RequestTarget createRequestTarget(HttpRequest request) {
        Tuple2 tuple2 = PathAndQueryParser$.MODULE$.parse(request.uri());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String parsedPath = (String)tuple2._1();
        String parsedQueryString = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)parsedPath, (Object)parsedQueryString);
        String parsedPath2 = (String)tuple22._1();
        String parsedQueryString2 = (String)tuple22._2();
        return new RequestTarget(parsedPath2, parsedQueryString2, request, this){
            private final HttpRequest request$3;
            public static final long OFFSET$0;
            private volatile Object uri$lzy1;
            private final String path;
            private final String queryString;
            private final Map queryMap;
            {
                this.request$3 = request$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.path = parsedPath$1;
                this.queryString = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(parsedQueryString$1), "?");
                QueryStringDecoder decoder = new QueryStringDecoder(parsedQueryString$1);
                this.queryMap = NettyModelConversion.play$core$server$netty$NettyModelConversion$$anon$3$$_$liftedTree2$1(decoder, $outer);
            }

            static {
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$3.class.getDeclaredField("uri$lzy1"));
            }

            public URI uri() {
                Object object = this.uri$lzy1;
                if (object instanceof URI) {
                    return (URI)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (URI)this.uri$lzyINIT1();
            }

            private Object uri$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.uri$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            URI uRI = null;
                            try {
                                uRI = new URI(this.uriString());
                                object2 = uRI == null ? LazyVals.NullValue$.MODULE$ : uRI;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.uri$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return uRI;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            public String uriString() {
                return this.request$3.uri();
            }

            public String path() {
                return this.path;
            }

            public String queryString() {
                return this.queryString;
            }

            public Map queryMap() {
                return this.queryMap;
            }
        };
    }

    public RequestHeader createRequestHeader(Channel channel, HttpRequest request, RequestTarget target) {
        NettyHeadersWrapper headers = new NettyHeadersWrapper(request.headers());
        return new RequestHeaderImpl(this.createRemoteConnection(channel, headers), request.method().name(), target, request.protocolVersion().text(), (Headers)headers, TypedMap$.MODULE$.apply(RequestAttrKey$.MODULE$.Server().$minus$greater((Object)"netty")));
    }

    public Option<Source<ByteString, Object>> convertRequestBody(HttpRequest request) {
        HttpRequest httpRequest = request;
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest full = (FullHttpRequest)httpRequest;
            ByteString content2 = this.httpContentToByteString((HttpContent)full);
            if (content2.isEmpty()) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply((Object)Source$.MODULE$.single((Object)content2));
        }
        if (httpRequest instanceof StreamedHttpRequest) {
            StreamedHttpRequest streamed = (StreamedHttpRequest)httpRequest;
            return Some$.MODULE$.apply((Object)Source$.MODULE$.fromPublisher(SynchronousMappedStreams$.MODULE$.map(streamed, (Function1 & Serializable)content -> this.httpContentToByteString((HttpContent)content))));
        }
        throw new MatchError((Object)httpRequest);
    }

    private ByteString httpContentToByteString(HttpContent content) {
        ByteStringBuilder builder = ByteString$.MODULE$.newBuilder();
        content.content().readBytes(builder.asOutputStream(), content.content().readableBytes());
        ByteString bytes = builder.result();
        ReferenceCountUtil.release((Object)content);
        return bytes;
    }

    public Future<HttpResponse> convertResult(Result result2, RequestHeader requestHeader, HttpVersion httpVersion, HttpErrorHandler errorHandler, Materializer mat) {
        return this.resultUtils.resultConversionWithErrorHandling(requestHeader, result2, errorHandler, (Function1 & Serializable)result -> {
            DefaultFullHttpResponse defaultFullHttpResponse;
            HttpEntity httpEntity;
            HttpResponseStatus httpResponseStatus;
            Option option = result.header().reasonPhrase();
            if (option instanceof Some) {
                String phrase = (String)((Some)option).value();
                httpResponseStatus = new HttpResponseStatus(result.header().status(), phrase);
            } else if (None$.MODULE$.equals(option)) {
                httpResponseStatus = HttpResponseStatus.valueOf((int)result.header().status());
            } else {
                throw new MatchError((Object)option);
            }
            HttpResponseStatus responseStatus = httpResponseStatus;
            ServerResultUtils.ConnectionHeader connectionHeader = this.resultUtils.determineConnectionHeader(requestHeader, result);
            String string = requestHeader.method();
            String string2 = HttpMethod.HEAD.name();
            boolean skipEntity = !(string != null ? !string.equals(string2) : string2 != null);
            HttpEntity any = httpEntity = result.body();
            if (skipEntity) {
                this.resultUtils.cancelEntity(any, mat);
                defaultFullHttpResponse = new DefaultFullHttpResponse(httpVersion, responseStatus, Unpooled.EMPTY_BUFFER);
            } else if (httpEntity instanceof HttpEntity.Strict) {
                HttpEntity.Strict strict = HttpEntity.Strict$.MODULE$.unapply((HttpEntity.Strict)httpEntity);
                ByteString byteString = strict._1();
                Option option2 = strict._2();
                ByteString data = byteString;
                defaultFullHttpResponse = new DefaultFullHttpResponse(httpVersion, responseStatus, this.byteStringToByteBuf(data));
            } else if (httpEntity instanceof HttpEntity.Streamed) {
                HttpEntity.Streamed streamed = HttpEntity.Streamed$.MODULE$.unapply((HttpEntity.Streamed)httpEntity);
                Source source = streamed._1();
                Option option3 = streamed._2();
                Option option4 = streamed._3();
                Source stream = source;
                defaultFullHttpResponse = this.createStreamedResponse(stream, httpVersion, responseStatus, mat);
            } else if (httpEntity instanceof HttpEntity.Chunked) {
                HttpEntity.Chunked chunked = HttpEntity.Chunked$.MODULE$.unapply((HttpEntity.Chunked)httpEntity);
                Source source = chunked._1();
                Option option5 = chunked._2();
                Source chunks = source;
                defaultFullHttpResponse = this.createChunkedResponse(chunks, httpVersion, responseStatus, mat);
            } else {
                throw new MatchError((Object)httpEntity);
            }
            DefaultFullHttpResponse response = defaultFullHttpResponse;
            Iterable headers = this.resultUtils.splitSetCookieHeaders(result.header().headers());
            headers.foreach(arg_0 -> NettyModelConversion.convertResult$$anonfun$1$$anonfun$1((HttpResponse)response, arg_0));
            if (this.resultUtils.mayHaveEntity(result.header().status())) {
                result.body().contentLength().foreach((Function1)((JFunction1.mcVJ.sp & Serializable)arg_0 -> this.convertResult$$anonfun$1$$anonfun$2((HttpResponse)response, arg_0)));
            } else if (HttpUtil.isContentLengthSet((HttpMessage)response)) {
                String manualContentLength = response.headers().get(HeaderNames$.MODULE$.CONTENT_LENGTH());
                this.logger.warn(() -> NettyModelConversion.convertResult$$anonfun$1$$anonfun$3(manualContentLength, result), MarkerContext$.MODULE$.NoMarker());
                response.headers().remove(HeaderNames$.MODULE$.CONTENT_LENGTH());
            }
            result.body().contentType().foreach(arg_0 -> this.convertResult$$anonfun$1$$anonfun$4((HttpResponse)response, arg_0));
            connectionHeader.header().foreach(arg_0 -> NettyModelConversion.convertResult$$anonfun$1$$anonfun$5((HttpResponse)response, arg_0));
            if (!response.headers().contains(HeaderNames$.MODULE$.DATE())) {
                response.headers().add(HeaderNames$.MODULE$.DATE(), (Object)this.dateHeader());
            }
            if (!response.headers().contains(HeaderNames$.MODULE$.SERVER())) {
                this.serverHeader.foreach(arg_0 -> NettyModelConversion.convertResult$$anonfun$1$$anonfun$6((HttpResponse)response, arg_0));
            }
            return Future$.MODULE$.successful((Object)response);
        }, () -> this.convertResult$$anonfun$2(httpVersion));
    }

    private DefaultStreamedHttpResponse createStreamedResponse(Source<ByteString, ?> stream, HttpVersion httpVersion, HttpResponseStatus responseStatus, Materializer mat) {
        Publisher publisher = SynchronousMappedStreams$.MODULE$.map((Publisher)stream.runWith((Graph)Sink$.MODULE$.asPublisher(false), mat), (Function1 & Serializable)bytes -> this.byteStringToHttpContent((ByteString)bytes));
        return new DefaultStreamedHttpResponse(httpVersion, responseStatus, publisher);
    }

    private DefaultStreamedHttpResponse createChunkedResponse(Source<HttpChunk, ?> chunks, HttpVersion httpVersion, HttpResponseStatus responseStatus, Materializer mat) {
        Publisher publisher = (Publisher)chunks.runWith((Graph)Sink$.MODULE$.asPublisher(false), mat);
        Publisher httpContentPublisher = SynchronousMappedStreams$.MODULE$.map(publisher, (Function1 & Serializable)x$12 -> {
            HttpChunk httpChunk = x$12;
            if (httpChunk instanceof HttpChunk.Chunk) {
                ByteString byteString;
                HttpChunk.Chunk chunk = HttpChunk.Chunk$.MODULE$.unapply((HttpChunk.Chunk)httpChunk);
                ByteString bytes = byteString = chunk._1();
                return new DefaultHttpContent(this.byteStringToByteBuf(bytes));
            }
            if (httpChunk instanceof HttpChunk.LastChunk) {
                Headers headers;
                HttpChunk.LastChunk lastChunk = HttpChunk.LastChunk$.MODULE$.unapply((HttpChunk.LastChunk)httpChunk);
                Headers trailers = headers = lastChunk._1();
                DefaultLastHttpContent lastChunk2 = new DefaultLastHttpContent();
                trailers.headers().foreach((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        return lastChunk2.trailingHeaders().add(name, (Object)value);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return lastChunk2;
            }
            throw new MatchError((Object)httpChunk);
        });
        DefaultStreamedHttpResponse response = new DefaultStreamedHttpResponse(httpVersion, responseStatus, httpContentPublisher);
        HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)true);
        return response;
    }

    private ByteBuf byteStringToByteBuf(ByteString bytes) {
        if (bytes.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        return Unpooled.wrappedBuffer((ByteBuffer)bytes.asByteBuffer());
    }

    private HttpContent byteStringToHttpContent(ByteString bytes) {
        return new DefaultHttpContent(this.byteStringToByteBuf(bytes));
    }

    private String dateHeader() {
        long currentTimeMillis = System.currentTimeMillis();
        long currentTimeSeconds = currentTimeMillis / 1000L;
        Tuple2<Object, String> tuple2 = this.cachedDateHeader;
        if (tuple2 != null) {
            long cachedSeconds = BoxesRunTime.unboxToLong((Object)tuple2._1());
            String dateHeaderString = (String)tuple2._2();
            if (cachedSeconds == currentTimeSeconds) {
                return dateHeaderString;
            }
        }
        String dateHeaderString = ResponseHeader$.MODULE$.httpDateFormat().format(Instant.ofEpochMilli(currentTimeMillis));
        Long l = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)currentTimeSeconds));
        this.cachedDateHeader = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l, (Object)dateHeaderString);
        return dateHeaderString;
    }

    private final RequestHeader tryToCreateRequest$$anonfun$1(HttpRequest request$1, Channel channel$1) {
        RequestTarget target = this.createRequestTarget(request$1);
        return this.createRequestHeader(channel$1, request$1, target);
    }

    public static final /* synthetic */ Seq play$core$server$netty$NettyModelConversion$$anon$1$$_$liftedTree1$1$$anonfun$1(SslHandler handler) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])handler.engine().getSession().getPeerCertificates());
        return (Seq)ArrayOps$.MODULE$.toSeq$extension(object).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Certificate x) {
                Certificate certificate = x;
                if (certificate instanceof X509Certificate) {
                    X509Certificate x509 = (X509Certificate)certificate;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Certificate x, Function1 function1) {
                Certificate certificate = x;
                if (certificate instanceof X509Certificate) {
                    X509Certificate x509 = (X509Certificate)certificate;
                    return x509;
                }
                return function1.apply((Object)x);
            }
        });
    }

    private static final String liftedTree2$1$$anonfun$2() {
        return "Failed to parse query string; returning empty map.";
    }

    private static final Throwable liftedTree2$1$$anonfun$3(Throwable e$1) {
        return e$1;
    }

    public static final Map play$core$server$netty$NettyModelConversion$$anon$3$$_$liftedTree2$1(QueryStringDecoder decoder$1, NettyModelConversion $outer$1) {
        Map map;
        try {
            map = CollectionConverters$.MODULE$.MapHasAsScala(decoder$1.parameters()).asScala().view().mapValues((Function1 & Serializable)_$1 -> CollectionConverters$.MODULE$.ListHasAsScala(_$1).asScala().toList()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (Throwable throwable) {
            Option option;
            IllegalArgumentException iae;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IllegalArgumentException && (iae = (IllegalArgumentException)throwable2).getMessage().startsWith("invalid hex byte")) {
                throw iae;
            }
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                $outer$1.logger.warn(NettyModelConversion::liftedTree2$1$$anonfun$2, () -> NettyModelConversion.liftedTree2$1$$anonfun$3(e), MarkerContext$.MODULE$.NoMarker());
                map = Predef$.MODULE$.Map().empty();
            }
            throw throwable;
        }
        return map;
    }

    private static final /* synthetic */ HttpHeaders convertResult$$anonfun$1$$anonfun$1(HttpResponse response$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            String value = (String)tuple2._2();
            return response$1.headers().add(name, (Object)value);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String convertResult$$anonfun$1$$anonfun$2$$anonfun$1() {
        return "Manual Content-Length header, ignoring manual header.";
    }

    private static final String convertResult$$anonfun$1$$anonfun$2$$anonfun$2(String manualContentLength$1, long contentLength$1) {
        return "Content-Length header was set manually in the header (" + manualContentLength$1 + ") but is not the same as actual content length (" + contentLength$1 + ").";
    }

    private final /* synthetic */ void convertResult$$anonfun$1$$anonfun$2(HttpResponse response$2, long contentLength) {
        if (HttpUtil.isContentLengthSet((HttpMessage)response$2)) {
            String manualContentLength;
            String string = manualContentLength = response$2.headers().get(HeaderNames$.MODULE$.CONTENT_LENGTH());
            String string2 = BoxesRunTime.boxToLong((long)contentLength).toString();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.logger.info(NettyModelConversion::convertResult$$anonfun$1$$anonfun$2$$anonfun$1, MarkerContext$.MODULE$.NoMarker());
            } else {
                this.logger.warn(() -> NettyModelConversion.convertResult$$anonfun$1$$anonfun$2$$anonfun$2(manualContentLength, contentLength), MarkerContext$.MODULE$.NoMarker());
            }
        }
        HttpUtil.setContentLength((HttpMessage)response$2, (long)contentLength);
    }

    private static final String convertResult$$anonfun$1$$anonfun$3(String manualContentLength$2, Result result$1) {
        return "Ignoring manual Content-Length (" + manualContentLength$2 + ") since it is not allowed for " + result$1.header().status() + " responses.";
    }

    private static final String convertResult$$anonfun$1$$anonfun$4$$anonfun$1(HttpResponse response$4, String contentType$1) {
        return "Content-Type set both in header (" + response$4.headers().get(HeaderNames$.MODULE$.CONTENT_TYPE()) + ") and attached to entity (" + contentType$1 + "), ignoring content type from entity. To remove this warning, use Result.as(...) to set the content type, rather than setting the header manually.";
    }

    private final /* synthetic */ Object convertResult$$anonfun$1$$anonfun$4(HttpResponse response$3, String contentType) {
        if (response$3.headers().contains(HeaderNames$.MODULE$.CONTENT_TYPE())) {
            this.logger.warn(() -> NettyModelConversion.convertResult$$anonfun$1$$anonfun$4$$anonfun$1(response$3, contentType), MarkerContext$.MODULE$.NoMarker());
            return BoxedUnit.UNIT;
        }
        return response$3.headers().add(HeaderNames$.MODULE$.CONTENT_TYPE(), (Object)contentType);
    }

    private static final /* synthetic */ HttpHeaders convertResult$$anonfun$1$$anonfun$5(HttpResponse response$5, String headerValue) {
        return response$5.headers().set(HeaderNames$.MODULE$.CONNECTION(), (Object)headerValue);
    }

    private static final /* synthetic */ HttpHeaders convertResult$$anonfun$1$$anonfun$6(HttpResponse response$6, String _$2) {
        return response$6.headers().add(HeaderNames$.MODULE$.SERVER(), (Object)_$2);
    }

    private final HttpResponse convertResult$$anonfun$2(HttpVersion httpVersion$2) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(httpVersion$2, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.EMPTY_BUFFER);
        HttpUtil.setContentLength((HttpMessage)response, (long)0L);
        response.headers().add(HeaderNames$.MODULE$.DATE(), (Object)this.dateHeader());
        this.serverHeader.foreach((Function1 & Serializable)_$3 -> response.headers().add(HeaderNames$.MODULE$.SERVER(), _$3));
        response.headers().add(HeaderNames$.MODULE$.CONNECTION(), (Object)"close");
        return response;
    }
}

