/*
 * Decompiled with CFR 0.152.
 */
package play.core.server;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMemorySize;
import com.typesafe.config.ConfigValue;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.ChannelMatchers;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.UnixChannelOption;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutor;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Sink;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.playframework.netty.HandlerPublisher;
import org.playframework.netty.http.HttpStreamsServerHandler;
import org.reactivestreams.Publisher;
import play.api.Application;
import play.api.BuiltInComponents;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.http.HttpProtocol$;
import play.api.internal.libs.concurrent.CoordinatedShutdownSupport$;
import play.api.mvc.Handler;
import play.api.mvc.RequestHeader;
import play.core.ApplicationProvider;
import play.core.NamedThreadFactory;
import play.core.server.Jdk$;
import play.core.server.Native$;
import play.core.server.NettyServer$;
import play.core.server.NettyServerProvider;
import play.core.server.NettyTransport;
import play.core.server.Server;
import play.core.server.Server$;
import play.core.server.ServerConfig;
import play.core.server.ServerEndpoint;
import play.core.server.ServerEndpoints;
import play.core.server.ServerListenException;
import play.core.server.ServerStartException;
import play.core.server.ServerStartException$;
import play.core.server.netty.NettyIdleHandler;
import play.core.server.netty.PlayRequestHandler;
import play.core.server.ssl.ServerSSLEngine$;
import play.server.SSLEngineProvider;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r]h\u0001B.]\u0001\rD\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\ti\u0002\u0011)\u0019!C\u0001k\"A!\u0010\u0001B\u0001B\u0003%a\u000f\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003}\u0011)\tI\u0003\u0001BC\u0002\u0013\u0005\u00111\u0006\u0005\u000b\u0003\u000b\u0002!\u0011!Q\u0001\n\u00055\u0002BCA$\u0001\t\u0015\r\u0011b\u0001\u0002J!Q\u0011q\u000b\u0001\u0003\u0002\u0003\u0006I!a\u0013\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!I\u0011Q\u000f\u0001C\u0002\u0013%\u0011q\u000f\u0005\t\u0003\u000b\u0003\u0001\u0015!\u0003\u0002z!I\u0011q\u0011\u0001C\u0002\u0013%\u0011q\u000f\u0005\t\u0003\u0013\u0003\u0001\u0015!\u0003\u0002z!I\u00111\u0012\u0001C\u0002\u0013%\u0011Q\u0012\u0005\t\u0003W\u0003\u0001\u0015!\u0003\u0002\u0010\"I\u0011Q\u0016\u0001C\u0002\u0013%\u0011q\u0016\u0005\t\u0003o\u0003\u0001\u0015!\u0003\u00022\"I\u0011\u0011\u0018\u0001C\u0002\u0013%\u0011q\u0016\u0005\t\u0003w\u0003\u0001\u0015!\u0003\u00022\"I\u0011Q\u0018\u0001C\u0002\u0013%\u0011q\u0018\u0005\t\u0003\u000f\u0004\u0001\u0015!\u0003\u0002B\"I\u0011\u0011\u001a\u0001C\u0002\u0013%\u0011q\u0016\u0005\t\u0003\u0017\u0004\u0001\u0015!\u0003\u00022\"I\u0011Q\u001a\u0001C\u0002\u0013%\u0011q\u0016\u0005\t\u0003\u001f\u0004\u0001\u0015!\u0003\u00022\"I\u0011\u0011\u001b\u0001C\u0002\u0013%\u00111\u001b\u0005\t\u00037\u0004\u0001\u0015!\u0003\u0002V\"I\u0011Q\u001c\u0001C\u0002\u0013%\u0011q\u001c\u0005\t\u0003g\u0004\u0001\u0015!\u0003\u0002b\"I\u0011Q\u001f\u0001C\u0002\u0013%\u0011q\u001c\u0005\t\u0003o\u0004\u0001\u0015!\u0003\u0002b\"I\u0011\u0011 \u0001C\u0002\u0013%\u00111\u001b\u0005\t\u0003w\u0004\u0001\u0015!\u0003\u0002V\"I\u0011Q \u0001C\u0002\u0013%\u00111\u001b\u0005\t\u0003\u007f\u0004\u0001\u0015!\u0003\u0002V\"I!\u0011\u0001\u0001C\u0002\u0013%!1\u0001\u0005\t\u0005#\u0001\u0001\u0015!\u0003\u0003\u0006!I!1\u0003\u0001C\u0002\u0013%!1\u0001\u0005\t\u0005+\u0001\u0001\u0015!\u0003\u0003\u0006!I!q\u0003\u0001C\u0002\u0013%!\u0011\u0004\u0005\t\u0005C\u0001\u0001\u0015!\u0003\u0003\u001c!I!1\u0005\u0001C\u0002\u0013%!\u0011\u0004\u0005\t\u0005K\u0001\u0001\u0015!\u0003\u0003\u001c!I!q\u0005\u0001C\u0002\u0013%!\u0011\u0006\u0005\t\u0005[\u0001\u0001\u0015!\u0003\u0003,!I!q\u0006\u0001C\u0002\u0013%\u0011q\u0016\u0005\t\u0005c\u0001\u0001\u0015!\u0003\u00022\"I!1\u0007\u0001C\u0002\u0013%!Q\u0007\u0005\t\u0005o\u0001\u0001\u0015!\u0003\u0002\u0016\"I!\u0011\b\u0001C\u0002\u0013%!1\u0001\u0005\t\u0005w\u0001\u0001\u0015!\u0003\u0003\u0006!I!Q\b\u0001C\u0002\u0013%\u00111\u001b\u0005\t\u0005\u007f\u0001\u0001\u0015!\u0003\u0002V\"Q!\u0011\t\u0001\t\u0006\u0004%IAa\u0011\t\u000f\t\r\u0004\u0001\"\u0011\u0003f!I!Q\u000e\u0001C\u0002\u0013%!q\u000e\u0005\t\u0005\u0007\u0003\u0001\u0015!\u0003\u0003r!I!Q\u0011\u0001C\u0002\u0013%!q\u0011\u0005\t\u0005+\u0003\u0001\u0015!\u0003\u0003\n\"Q!q\u0013\u0001\t\u0006\u0004%IA!'\t\u000f\t\u001d\u0006\u0001\"\u0003\u0003*\"I!Q\u001a\u0001\u0012\u0002\u0013%!q\u001a\u0005\b\u0005K\u0004A\u0011\u0002Bt\u0011!\u0019I\u0002\u0001Q\u0005\u0012\rm\u0001bBB\u0012\u0001\u0011%1Q\u0005\u0005\n\u0007\u007f\u0001!\u0019!C\u0005\u0007\u0003B\u0001b!\u0012\u0001A\u0003%11\t\u0005\n\u0007\u000f\u0002!\u0019!C\u0005\u0007\u0003B\u0001b!\u0013\u0001A\u0003%11\t\u0005\b\u0007\u0017\u0002A\u0011BB'\u0011\u001d\u0019\u0019\u0006\u0001C!\u0007+Bqaa\u0016\u0001\t\u0013\u0019)\u0006C\u0004\u0004Z\u0001!Ia!\u0016\t\u0015\rm\u0003\u0001#b\u0001\n\u0003\u001ai\u0006\u0003\u0006\u0004`\u0001A)\u0019!C\u0005\u0007CB!ba\u001b\u0001\u0011\u000b\u0007I\u0011BB1\u0011%\u0019i\u0007\u0001b\u0001\n\u0003\u001ay\u0007\u0003\u0005\u0004x\u0001\u0001\u000b\u0011BB9\u00119\u0019I\b\u0001I\u0001\u0004\u0003\u0005I\u0011BB+\u0007w:qa! ]\u0011\u0003\u0019yH\u0002\u0004\\9\"\u00051\u0011\u0011\u0005\b\u00033\nF\u0011ABE\u0011%\u0019Y)\u0015b\u0001\n\u0013\u0019i\t\u0003\u0005\u0004\u0016F\u0003\u000b\u0011BBH\u0011%\u00199*\u0015b\u0001\n\u0007\u0019I\n\u0003\u0005\u0004\"F\u0003\u000b\u0011BBN\u0011\u001d\u0019\u0019+\u0015C\u0001\u0007KCqa!-R\t\u0003\u0019\u0019\fC\u0005\u0004BF\u000b\n\u0011\"\u0001\u0004D\"91qY)\u0005R\r%'a\u0003(fiRL8+\u001a:wKJT!!\u00180\u0002\rM,'O^3s\u0015\ty\u0006-\u0001\u0003d_J,'\"A1\u0002\tAd\u0017-_\u0002\u0001'\r\u0001A\r\u001c\t\u0003K*l\u0011A\u001a\u0006\u0003O\"\fA\u0001\\1oO*\t\u0011.\u0001\u0003kCZ\f\u0017BA6g\u0005\u0019y%M[3diB\u0011QN\\\u0007\u00029&\u0011q\u000e\u0018\u0002\u0007'\u0016\u0014h/\u001a:\u0002\r\r|gNZ5h!\ti'/\u0003\u0002t9\na1+\u001a:wKJ\u001cuN\u001c4jO\u0006\u0019\u0012\r\u001d9mS\u000e\fG/[8o!J|g/\u001b3feV\ta\u000f\u0005\u0002xq6\ta,\u0003\u0002z=\n\u0019\u0012\t\u001d9mS\u000e\fG/[8o!J|g/\u001b3fe\u0006!\u0012\r\u001d9mS\u000e\fG/[8o!J|g/\u001b3fe\u0002\n\u0001b\u001d;pa\"{wn\u001b\t\u0006{\u0006\u0005\u0011QA\u0007\u0002}*\tq0A\u0003tG\u0006d\u0017-C\u0002\u0002\u0004y\u0014\u0011BR;oGRLwN\u001c\u00191\t\u0005\u001d\u0011q\u0003\t\u0007\u0003\u0013\ty!a\u0005\u000e\u0005\u0005-!bAA\u0007}\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005E\u00111\u0002\u0002\u0007\rV$XO]3\u0011\t\u0005U\u0011q\u0003\u0007\u0001\t-\tI\u0002BA\u0001\u0002\u0003\u0015\t!a\u0007\u0003\u0007}#\u0013'\u0005\u0003\u0002\u001e\u0005\r\u0002cA?\u0002 %\u0019\u0011\u0011\u0005@\u0003\u000f9{G\u000f[5oOB\u0019Q0!\n\n\u0007\u0005\u001dbPA\u0002B]f\f1\"Y2u_J\u001c\u0016p\u001d;f[V\u0011\u0011Q\u0006\t\u0005\u0003_\t\t%\u0004\u0002\u00022)!\u00111GA\u001b\u0003\u0015\t7\r^8s\u0015\u0011\t9$!\u000f\u0002\u000bA,7n[8\u000b\t\u0005m\u0012QH\u0001\u0007CB\f7\r[3\u000b\u0005\u0005}\u0012aA8sO&!\u00111IA\u0019\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u0019\u0005\u001cGo\u001c:TsN$X-\u001c\u0011\u0002\u00195\fG/\u001a:jC2L'0\u001a:\u0016\u0005\u0005-\u0003\u0003BA'\u0003'j!!a\u0014\u000b\t\u0005E\u0013QG\u0001\u0007gR\u0014X-Y7\n\t\u0005U\u0013q\n\u0002\r\u001b\u0006$XM]5bY&TXM]\u0001\u000e[\u0006$XM]5bY&TXM\u001d\u0011\u0002\rqJg.\u001b;?))\ti&a\u0019\u0002f\u0005\u001d\u00141\u000f\u000b\u0005\u0003?\n\t\u0007\u0005\u0002n\u0001!9\u0011qI\u0005A\u0004\u0005-\u0003\"\u00029\n\u0001\u0004\t\b\"\u0002;\n\u0001\u00041\bBB>\n\u0001\u0004\tI\u0007E\u0003~\u0003\u0003\tY\u0007\r\u0003\u0002n\u0005E\u0004CBA\u0005\u0003\u001f\ty\u0007\u0005\u0003\u0002\u0016\u0005ED\u0001DA\r\u0003O\n\t\u0011!A\u0003\u0002\u0005m\u0001bBA\u0015\u0013\u0001\u0007\u0011QF\u0001\rg\u0016\u0014h/\u001a:D_:4\u0017nZ\u000b\u0003\u0003s\u0002B!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0004\u0003\u007f\u0002\u0017aA1qS&!\u00111QA?\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006i1/\u001a:wKJ\u001cuN\u001c4jO\u0002\n1B\\3uif\u001cuN\u001c4jO\u0006aa.\u001a;us\u000e{gNZ5hA\u0005a1/\u001a:wKJDU-\u00193feV\u0011\u0011q\u0012\t\u0006{\u0006E\u0015QS\u0005\u0004\u0003's(AB(qi&|g\u000e\u0005\u0003\u0002\u0018\u0006\u0015f\u0002BAM\u0003C\u00032!a'\u007f\u001b\t\tiJC\u0002\u0002 \n\fa\u0001\u0010:p_Rt\u0014bAAR}\u00061\u0001K]3eK\u001aLA!a*\u0002*\n11\u000b\u001e:j]\u001eT1!a)\u007f\u00035\u0019XM\u001d<fe\"+\u0017\rZ3sA\u0005!R.\u0019=J]&$\u0018.\u00197MS:,G*\u001a8hi\",\"!!-\u0011\u0007u\f\u0019,C\u0002\u00026z\u00141!\u00138u\u0003Ui\u0017\r_%oSRL\u0017\r\u001c'j]\u0016dUM\\4uQ\u0002\nQ\"\\1y\u0011\u0016\fG-\u001a:TSj,\u0017AD7bq\"+\u0017\rZ3s'&TX\rI\u0001\u0011[\u0006D8i\u001c8uK:$H*\u001a8hi\",\"!!1\u0011\u0007u\f\u0019-C\u0002\u0002Fz\u0014A\u0001T8oO\u0006\tR.\u0019=D_:$XM\u001c;MK:<G\u000f\u001b\u0011\u0002\u00195\f\u0007p\u00115v].\u001c\u0016N_3\u0002\u001b5\f\u0007p\u00115v].\u001c\u0016N_3!\u0003-!\bN]3bI\u000e{WO\u001c;\u0002\u0019QD'/Z1e\u0007>,h\u000e\u001e\u0011\u0002\u000f1|wmV5sKV\u0011\u0011Q\u001b\t\u0004{\u0006]\u0017bAAm}\n9!i\\8mK\u0006t\u0017\u0001\u00037pO^K'/\u001a\u0011\u0002\u001f\t|w\u000e^:ue\u0006\u0004x\n\u001d;j_:,\"!!9\u0011\t\u0005\r\u0018q^\u0007\u0003\u0003KT1\u0001]At\u0015\u0011\tI/a;\u0002\u0011QL\b/Z:bM\u0016T!!!<\u0002\u0007\r|W.\u0003\u0003\u0002r\u0006\u0015(AB\"p]\u001aLw-\u0001\tc_>$8\u000f\u001e:ba>\u0003H/[8oA\u0005i1\r[1o]\u0016dw\n\u001d;j_:\fab\u00195b]:,Gn\u00149uS>t\u0007%A\niiR\u00048oV1oi\u000ec\u0017.\u001a8u\u0003V$\b.\u0001\u000biiR\u00048oV1oi\u000ec\u0017.\u001a8u\u0003V$\b\u000eI\u0001\u0014QR$\bo\u001d(fK\u0012\u001cE.[3oi\u0006+H\u000f[\u0001\u0015QR$\bo\u001d(fK\u0012\u001cE.[3oi\u0006+H\u000f\u001b\u0011\u0002\u001f!$H\u000f]%eY\u0016$\u0016.\\3pkR,\"A!\u0002\u0011\t\t\u001d!QB\u0007\u0003\u0005\u0013QAAa\u0003\u0002\f\u0005AA-\u001e:bi&|g.\u0003\u0003\u0003\u0010\t%!\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002!!$H\u000f]%eY\u0016$\u0016.\\3pkR\u0004\u0013\u0001\u00055uiB\u001c\u0018\n\u001a7f)&lWm\\;u\u0003EAG\u000f\u001e9t\u0013\u0012dW\rV5nK>,H\u000fI\u0001\u0014g\",H\u000fZ8x]F+\u0018.\u001a;QKJLw\u000eZ\u000b\u0003\u00057\u0001BAa\u0002\u0003\u001e%!!q\u0004B\u0005\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fAc\u001d5vi\u0012|wO\\)vS\u0016$\b+\u001a:j_\u0012\u0004\u0013\u0001\u0005;fe6Lg.\u0019;j_:$U\r\\1z\u0003E!XM]7j]\u0006$\u0018n\u001c8EK2\f\u0017\u0010I\u0001\u0013i\u0016\u0014X.\u001b8bi&|g\u000eV5nK>,H/\u0006\u0002\u0003,A)Q0!%\u0003\u001c\u0005\u0019B/\u001a:nS:\fG/[8o)&lWm\\;uA\u0005iqo\u001d\"vM\u001a,'\u000fT5nSR\fab^:Ck\u001a4WM\u001d'j[&$\b%A\bxg.+W\r]!mSZ,Wj\u001c3f+\t\t)*\u0001\txg.+W\r]!mSZ,Wj\u001c3fA\u0005\u0011ro]&fKB\fE.\u001b<f\u001b\u0006D\u0018\n\u001a7f\u0003M98oS3fa\u0006c\u0017N^3NCbLE\r\\3!\u0003A!WMZ3s\u0005>$\u0017\u0010U1sg&tw-A\teK\u001a,'OQ8esB\u000b'o]5oO\u0002\n\u0011\u0002\u001e:b]N\u0004xN\u001d;\u0016\u0005\t\u0015#\u0003\u0003B$\u0005\u0017\u0012\tFa\u0016\u0007\r\t%\u0003\u0001\u0001B#\u00051a$/\u001a4j]\u0016lWM\u001c;?!\ri(QJ\u0005\u0004\u0005\u001fr(a\u0002)s_\u0012,8\r\u001e\t\u0004[\nM\u0013b\u0001B+9\nqa*\u001a;usR\u0013\u0018M\\:q_J$\b\u0003\u0002B-\u0005?j!Aa\u0017\u000b\u0007\tu\u0003.\u0001\u0002j_&!!\u0011\rB.\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011iw\u000eZ3\u0016\u0005\t\u001d\u0004\u0003BA>\u0005SJAAa\u001b\u0002~\t!Qj\u001c3f\u0003%)g/\u001a8u\u0019>|\u0007/\u0006\u0002\u0003rA!!1\u000fB@\u001b\t\u0011)H\u0003\u0003\u0003x\te\u0014aB2iC:tW\r\u001c\u0006\u0005\u0005w\u0012i(A\u0003oKR$\u0018P\u0003\u0002\u0003^%!!\u0011\u0011B;\u0005eiU\u000f\u001c;ji\"\u0014X-\u00193Fm\u0016tG\u000fT8pa\u001e\u0013x.\u001e9\u0002\u0015\u00154XM\u001c;M_>\u0004\b%A\u0006bY2\u001c\u0005.\u00198oK2\u001cXC\u0001BE!\u0011\u0011YI!%\u000e\u0005\t5%\u0002\u0002BH\u0005k\nQa\u001a:pkBLAAa%\u0003\u000e\n\u0019B)\u001a4bk2$8\t[1o]\u0016dwI]8va\u0006a\u0011\r\u001c7DQ\u0006tg.\u001a7tA\u0005\t2o\u001d7F]\u001eLg.\u001a)s_ZLG-\u001a:\u0016\u0005\tm\u0005#B?\u0002\u0012\nu\u0005\u0003\u0002BP\u0005Gk!A!)\u000b\u0005u\u0003\u0017\u0002\u0002BS\u0005C\u0013\u0011cU*M\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3s\u0003)\u0019X\r^(qi&|gn\u001d\u000b\t\u0005W\u0013\tLa2\u0003JB\u0019QP!,\n\u0007\t=fP\u0001\u0003V]&$\bb\u0002BZ{\u0001\u0007!QW\u0001\ng\u0016$x\n\u001d;j_:\u0004\u0012\" B\\\u0005w\u0013\t-a\t\n\u0007\tefPA\u0005Gk:\u001cG/[8oeA1!1\u000fB_\u0005\u0003LAAa0\u0003v\ti1\t[1o]\u0016dw\n\u001d;j_:\u00042! Bb\u0013\r\u0011)M \u0002\u0007\u0003:L(+\u001a4\t\rAl\u0004\u0019AAq\u0011%\u0011Y-\u0010I\u0001\u0002\u0004\t).A\u0007c_>$8\u000f\u001e:baBLgnZ\u0001\u0015g\u0016$x\n\u001d;j_:\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tE'\u0006BAk\u0005'\\#A!6\u0011\t\t]'\u0011]\u0007\u0003\u00053TAAa7\u0003^\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005?t\u0018AC1o]>$\u0018\r^5p]&!!1\u001dBm\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0005E&tG\r\u0006\u0003\u0003j\u000e%\u0001cB?\u0003l\n=(Q_\u0005\u0004\u0005[t(A\u0002+va2,'\u0007\u0005\u0003\u0003t\tE\u0018\u0002\u0002Bz\u0005k\u0012qa\u00115b]:,G\u000e\r\u0003\u0003x\u000e\u0015\u0001\u0003\u0003B}\u0005\u007f\u0014yoa\u0001\u000e\u0005\tm(\u0002\u0002B\u007f\u0003\u001f\n\u0001b]2bY\u0006$7\u000f\\\u0005\u0005\u0007\u0003\u0011YP\u0001\u0004T_V\u00148-\u001a\t\u0005\u0003+\u0019)\u0001B\u0006\u0004\b}\n\t\u0011!A\u0003\u0002\u0005m!aA0%e!911B A\u0002\r5\u0011aB1eIJ,7o\u001d\t\u0005\u0007\u001f\u0019)\"\u0004\u0002\u0004\u0012)\u001911\u00035\u0002\u00079,G/\u0003\u0003\u0004\u0018\rE!!E%oKR\u001cvnY6fi\u0006#GM]3tg\u0006\tb.Z<SKF,Xm\u001d;IC:$G.\u001a:\u0015\u0005\ru\u0001\u0003\u0002B:\u0007?IAa!\t\u0003v\t)2\t[1o]\u0016d\u0017J\u001c2pk:$\u0007*\u00198eY\u0016\u0014\u0018aC2iC:tW\r\\*j].$baa\n\u00048\rm\u0002\u0003\u0003B}\u0007S\u0011yo!\f\n\t\r-\"1 \u0002\u0005'&t7\u000e\u0005\u0004\u0002\n\u0005=1q\u0006\t\u0005\u0007c\u0019\u0019$\u0004\u0002\u00026%!1QGA\u001b\u0005\u0011!uN\\3\t\u000f\re\u0012\t1\u0001\u00022\u0006!\u0001o\u001c:u\u0011\u001d\u0019i$\u0011a\u0001\u0003+\faa]3dkJ,\u0017a\u00035uiB\u001c\u0005.\u00198oK2,\"aa\u0011\u0011\u000bu\f\tJa<\u0002\u0019!$H\u000f]\"iC:tW\r\u001c\u0011\u0002\u0019!$H\u000f]:DQ\u0006tg.\u001a7\u0002\u001b!$H\u000f]:DQ\u0006tg.\u001a7!\u0003-\u0011\u0017N\u001c3DQ\u0006tg.\u001a7\u0015\r\t=8qJB)\u0011\u001d\u0019ID\u0012a\u0001\u0003cCqa!\u0010G\u0001\u0004\t).\u0001\u0003ti>\u0004HC\u0001BV\u0003U\u0011XmZ5ti\u0016\u00148\u000b[;uI><h\u000eV1tWN\fQ%\u001b8ji&\fG.\u001b>f\u0007\"\fgN\\3m\u001fB$\u0018n\u001c8t'R\fG/[2NK6\u0014WM]:\u0002\u00175\f\u0017N\\!eIJ,7o]\u000b\u0003\u0007\u001b\t!\u0002\u0013;uaF\u0002F.Y5o+\t\u0019\u0019\u0007E\u0003~\u0003#\u001b)\u0007E\u0002n\u0007OJ1a!\u001b]\u00059\u0019VM\u001d<fe\u0016sG\r]8j]R\fa\u0002\u0013;uaF*en\u0019:zaR,G-A\btKJ4XM]#oIB|\u0017N\u001c;t+\t\u0019\t\bE\u0002n\u0007gJ1a!\u001e]\u0005=\u0019VM\u001d<fe\u0016sG\r]8j]R\u001c\u0018\u0001E:feZ,'/\u00128ea>Lg\u000e^:!\u0003)\u0019X\u000f]3sIM$x\u000e]\u0005\u0004\u0007'r\u0017a\u0003(fiRL8+\u001a:wKJ\u0004\"!\\)\u0014\u000bE\u0013\tma!\u0011\u00075\u001c))C\u0002\u0004\br\u0013\u0001cU3sm\u0016\u0014hI]8n%>,H/\u001a:\u0015\u0005\r}\u0014A\u00027pO\u001e,'/\u0006\u0002\u0004\u0010B!\u00111PBI\u0013\u0011\u0019\u0019*! \u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\n\u0001\u0002\u001d:pm&$WM]\u000b\u0003\u00077\u00032!\\BO\u0013\r\u0019y\n\u0018\u0002\u0014\u001d\u0016$H/_*feZ,'\u000f\u0015:pm&$WM]\u0001\naJ|g/\u001b3fe\u0002\nA!\\1j]R!!1VBT\u0011\u001d\u0019Ik\u0016a\u0001\u0007W\u000bA!\u0019:hgB)Qp!,\u0002\u0016&\u00191q\u0016@\u0003\u000b\u0005\u0013(/Y=\u0002\u001f\u0019\u0014x.\\!qa2L7-\u0019;j_:$b!a\u0018\u00046\u000e}\u0006bBB\\1\u0002\u00071\u0011X\u0001\fCB\u0004H.[2bi&|g\u000e\u0005\u0003\u0002|\rm\u0016\u0002BB_\u0003{\u00121\"\u00119qY&\u001c\u0017\r^5p]\"9\u0001\u000f\u0017I\u0001\u0002\u0004\t\u0018!\u00074s_6\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8%I\u00164\u0017-\u001e7uII*\"a!2+\u0007E\u0014\u0019.\u0001\fde\u0016\fG/Z*feZ,'O\u0012:p[J{W\u000f^3s)\u0011\u0019Yma=\u0015\u00071\u001ci\rC\u0004\u0004Pj\u0003\ra!5\u0002\rI|W\u000f^3t!\u001di81[Bl\u0007OL1a!6\u007f\u0005%1UO\\2uS>t\u0017G\u0005\u0004\u0004Z\u000em7\u0011\u001d\u0004\u0007\u0005\u0013\n\u0006aa6\u0011\u00075\u001ci.C\u0002\u0004`r\u0013\u0001cU3sm\u0016\u00148i\\7q_:,g\u000e^:\u0011\t\u0005m41]\u0005\u0005\u0007K\fiHA\tCk&dG/\u00138D_6\u0004xN\\3oiN\u0004Ba!;\u0004p6\u001111\u001e\u0006\u0005\u0007[\fi(A\u0004s_V$\u0018N\\4\n\t\rE81\u001e\u0002\u0007%>,H/\u001a:\t\u0011\rU(\f%AA\u0002E\f!b]3sm\u0016\u00148i\u001c8g\u0001")
public class NettyServer
implements Server {
    private Product transport;
    private Option<SSLEngineProvider> sslEngineProvider;
    private InetSocketAddress mainAddress;
    private Option<ServerEndpoint> Http1Plain;
    private Option<ServerEndpoint> Http1Encrypted;
    private final ServerConfig config;
    private final ApplicationProvider applicationProvider;
    private final Function0<Future<?>> stopHook;
    private final ActorSystem actorSystem;
    private final Materializer materializer;
    private final Configuration serverConfig;
    private final Configuration nettyConfig;
    private final Option<String> serverHeader;
    private final int maxInitialLineLength;
    private final int maxHeaderSize;
    private final long maxContentLength;
    private final int maxChunkSize;
    private final int threadCount;
    private final boolean logWire;
    private final Config bootstrapOption;
    private final Config channelOption;
    private final boolean httpsWantClientAuth;
    private final boolean httpsNeedClientAuth;
    private final Duration httpIdleTimeout;
    private final Duration httpsIdleTimeout;
    private final FiniteDuration shutdownQuietPeriod;
    private final FiniteDuration terminationDelay;
    private final Option<FiniteDuration> terminationTimeout;
    private final int wsBufferLimit;
    private final String wsKeepAliveMode;
    private final Duration wsKeepAliveMaxIdle;
    private final boolean deferBodyParsing;
    private final MultithreadEventLoopGroup eventLoop;
    private final DefaultChannelGroup allChannels;
    private final Option<Channel> httpChannel;
    private final Option<Channel> httpsChannel;
    private final ServerEndpoints serverEndpoints;
    private volatile byte bitmap$0;

    public static ServerConfig fromApplication$default$2() {
        return NettyServer$.MODULE$.fromApplication$default$2();
    }

    public static NettyServer fromApplication(Application application, ServerConfig config) {
        return NettyServer$.MODULE$.fromApplication(application, config);
    }

    public static void main(String[] args) {
        NettyServer$.MODULE$.main(args);
    }

    public static NettyServerProvider provider() {
        return NettyServer$.MODULE$.provider();
    }

    public static ServerConfig fromRouterWithComponents$default$1() {
        return NettyServer$.MODULE$.fromRouterWithComponents$default$1();
    }

    public static Server fromRouterWithComponents(ServerConfig config, Function1<BuiltInComponents, PartialFunction<RequestHeader, Handler>> routes) {
        return NettyServer$.MODULE$.fromRouterWithComponents(config, routes);
    }

    public static ServerConfig fromRouter$default$1() {
        return NettyServer$.MODULE$.fromRouter$default$1();
    }

    public static Server fromRouter(ServerConfig config, PartialFunction<RequestHeader, Handler> routes) {
        return NettyServer$.MODULE$.fromRouter(config, routes);
    }

    public void reload() {
        Server.reload$((Server)this);
    }

    public Option<Object> httpPort() {
        return Server.httpPort$((Server)this);
    }

    public Option<Object> httpsPort() {
        return Server.httpsPort$((Server)this);
    }

    private /* synthetic */ void super$stop() {
        Server.stop$((Server)this);
    }

    public ApplicationProvider applicationProvider() {
        return this.applicationProvider;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public Materializer materializer() {
        return this.materializer;
    }

    private Configuration serverConfig() {
        return this.serverConfig;
    }

    private Configuration nettyConfig() {
        return this.nettyConfig;
    }

    private Option<String> serverHeader() {
        return this.serverHeader;
    }

    private int maxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    private int maxHeaderSize() {
        return this.maxHeaderSize;
    }

    private long maxContentLength() {
        return this.maxContentLength;
    }

    private int maxChunkSize() {
        return this.maxChunkSize;
    }

    private int threadCount() {
        return this.threadCount;
    }

    private boolean logWire() {
        return this.logWire;
    }

    private Config bootstrapOption() {
        return this.bootstrapOption;
    }

    private Config channelOption() {
        return this.channelOption;
    }

    private boolean httpsWantClientAuth() {
        return this.httpsWantClientAuth;
    }

    private boolean httpsNeedClientAuth() {
        return this.httpsNeedClientAuth;
    }

    private Duration httpIdleTimeout() {
        return this.httpIdleTimeout;
    }

    private Duration httpsIdleTimeout() {
        return this.httpsIdleTimeout;
    }

    private FiniteDuration shutdownQuietPeriod() {
        return this.shutdownQuietPeriod;
    }

    private FiniteDuration terminationDelay() {
        return this.terminationDelay;
    }

    private Option<FiniteDuration> terminationTimeout() {
        return this.terminationTimeout;
    }

    private int wsBufferLimit() {
        return this.wsBufferLimit;
    }

    private String wsKeepAliveMode() {
        return this.wsKeepAliveMode;
    }

    private Duration wsKeepAliveMaxIdle() {
        return this.wsKeepAliveMaxIdle;
    }

    private boolean deferBodyParsing() {
        return this.deferBodyParsing;
    }

    private Product transport$lzycompute() {
        block7: {
            NettyServer nettyServer = this;
            synchronized (nettyServer) {
                NettyTransport nettyTransport;
                block8: {
                    if ((byte)(this.bitmap$0 & 1) != 0) break block7;
                    String string = (String)this.nettyConfig().get("transport", ConfigLoader$.MODULE$.stringLoader());
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1052618729: {
                            if (!"native".equals(string)) break;
                            nettyTransport = Native$.MODULE$;
                            break block8;
                        }
                        case 105073: {
                            if (!"jdk".equals(string)) break;
                            nettyTransport = Jdk$.MODULE$;
                            break block8;
                        }
                    }
                    throw new ServerStartException("Netty transport configuration value should be either jdk or native", ServerStartException$.MODULE$.apply$default$2());
                }
                this.transport = nettyTransport;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.transport;
    }

    private Product transport() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.transport$lzycompute();
        }
        return this.transport;
    }

    public Mode mode() {
        return this.config.mode();
    }

    private MultithreadEventLoopGroup eventLoop() {
        return this.eventLoop;
    }

    private DefaultChannelGroup allChannels() {
        return this.allChannels;
    }

    private Option<SSLEngineProvider> sslEngineProvider$lzycompute() {
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sslEngineProvider = this.liftedTree1$1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sslEngineProvider;
    }

    private Option<SSLEngineProvider> sslEngineProvider() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sslEngineProvider$lzycompute();
        }
        return this.sslEngineProvider;
    }

    private void setOptions(Function2<ChannelOption<Object>, Object, Object> setOption, Config config, boolean bootstrapping) {
        ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(config.entrySet()).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NettyServer.$anonfun$setOptions$1(x$1)))).foreach((Function1 & Serializable)option -> {
            String cleanKey = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString((String)option.getKey()), "\"")), "\"");
            if (ChannelOption.exists((String)cleanKey)) {
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().debug((Function0 & Serializable)() -> "Setting Netty channel option " + cleanKey + " to " + NettyServer.unwrap$1((ConfigValue)option.getValue()) + (bootstrapping ? " at bootstrapping" : ""), MarkerContext$.MODULE$.NoMarker());
                return setOption.apply((Object)ChannelOption.valueOf((String)cleanKey), NettyServer.unwrap$1((ConfigValue)option.getValue()));
            }
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().warn((Function0 & Serializable)() -> "Ignoring unknown Netty channel option: " + cleanKey, MarkerContext$.MODULE$.NoMarker());
            Product product = this.transport();
            if (Native$.MODULE$.equals(product)) {
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().warn((Function0 & Serializable)() -> "Valid values can be found at http://netty.io/4.1/api/io/netty/channel/ChannelOption.html, https://netty.io/4.1/api/io/netty/channel/unix/UnixChannelOption.html and http://netty.io/4.1/api/io/netty/channel/epoll/EpollChannelOption.html", MarkerContext$.MODULE$.NoMarker());
            } else if (Jdk$.MODULE$.equals(product)) {
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().warn((Function0 & Serializable)() -> "Valid values can be found at http://netty.io/4.1/api/io/netty/channel/ChannelOption.html", MarkerContext$.MODULE$.NoMarker());
            } else {
                throw new MatchError((Object)product);
            }
            return BoxedUnit.UNIT;
        });
    }

    private boolean setOptions$default$3() {
        return false;
    }

    private Tuple2<Channel, Source<Channel, ?>> bind(InetSocketAddress address) {
        Class<EpollServerSocketChannel> clazz;
        EventLoop serverChannelEventLoop = this.eventLoop().next();
        HandlerPublisher channelPublisher = new HandlerPublisher((EventExecutor)serverChannelEventLoop, Channel.class);
        Product product = this.transport();
        if (Native$.MODULE$.equals(product)) {
            clazz = EpollServerSocketChannel.class;
        } else if (Jdk$.MODULE$.equals(product)) {
            clazz = NioServerSocketChannel.class;
        } else {
            throw new MatchError((Object)product);
        }
        Class<EpollServerSocketChannel> channelClass = clazz;
        Bootstrap bootstrap = (Bootstrap)new Bootstrap().channel(channelClass).group((EventLoopGroup)serverChannelEventLoop).option(ChannelOption.AUTO_READ, (Object)Boolean.FALSE).handler((ChannelHandler)channelPublisher).localAddress((SocketAddress)address);
        this.setOptions((Function2<ChannelOption<Object>, Object, Object>)(Function2 & Serializable)(x$1, x$2) -> (Bootstrap)bootstrap.option(x$1, x$2), this.bootstrapOption(), true);
        Channel channel = bootstrap.bind().await().channel();
        this.allChannels().add(channel);
        return new Tuple2((Object)channel, (Object)Source$.MODULE$.fromPublisher((Publisher)channelPublisher));
    }

    public ChannelInboundHandler newRequestHandler() {
        return new PlayRequestHandler(this, this.serverHeader(), this.maxContentLength(), this.wsBufferLimit(), this.wsKeepAliveMode(), this.wsKeepAliveMaxIdle(), this.deferBodyParsing());
    }

    private Sink<Channel, Future<Done>> channelSink(int port, boolean secure) {
        return Sink$.MODULE$.foreach((Function1 & Serializable)connChannel -> {
            NettyServer.$anonfun$channelSink$1(this, secure, port, connChannel);
            return BoxedUnit.UNIT;
        });
    }

    private Option<Channel> httpChannel() {
        return this.httpChannel;
    }

    private Option<Channel> httpsChannel() {
        return this.httpsChannel;
    }

    private Channel bindChannel(int port, boolean secure) {
        Channel serverChannel;
        block2: {
            String protocolName = secure ? "HTTPS" : "HTTP";
            InetSocketAddress address = new InetSocketAddress(this.config.address(), port);
            Tuple2<Channel, Source<Channel, ?>> tuple2 = this.bind(address);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Channel serverChannel2 = (Channel)tuple2._1();
            Source channelSource = (Source)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)serverChannel2, (Object)channelSource);
            serverChannel = (Channel)tuple22._1();
            Source channelSource2 = (Source)tuple22._2();
            channelSource2.runWith(this.channelSink(port, secure), this.materializer());
            SocketAddress boundAddress = serverChannel.localAddress();
            if (boundAddress == null) {
                ServerListenException e = new ServerListenException(protocolName, (SocketAddress)address);
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().error((Function0 & Serializable)() -> e.getMessage(), MarkerContext$.MODULE$.NoMarker());
                throw e;
            }
            Mode mode = this.mode();
            Mode.Test$ test$ = Mode.Test$.MODULE$;
            if (!(mode == null ? test$ != null : !mode.equals(test$))) break block2;
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().info((Function0 & Serializable)() -> "Listening for " + protocolName + " on " + boundAddress, MarkerContext$.MODULE$.NoMarker());
        }
        return serverChannel;
    }

    public void stop() {
        CoordinatedShutdownSupport$.MODULE$.syncShutdown(this.actorSystem(), (CoordinatedShutdown.Reason)Server.ServerStoppedReason$.MODULE$);
    }

    private void registerShutdownTasks() {
        ExecutionContextExecutor ctx = this.actorSystem().dispatcher();
        CoordinatedShutdown cs = (CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.actorSystem());
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeServiceUnbind(), "trace-server-stop-request", (Function0 & Serializable)() -> {
            Mode mode = this.mode();
            if (Mode.Test$.MODULE$.equals(mode)) {
            } else {
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().info((Function0 & Serializable)() -> "Stopping server...", MarkerContext$.MODULE$.NoMarker());
            }
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        });
        FiniteDuration serverTerminateTimeout = Server$.MODULE$.determineServerTerminateTimeout(this.terminationTimeout(), this.terminationDelay(), this.actorSystem());
        FiniteDuration unbindTimeout = cs.timeout(CoordinatedShutdown$.MODULE$.PhaseServiceUnbind());
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseServiceUnbind(), "netty-server-unbind", (Function0 & Serializable)() -> {
            ChannelGroupFuture serverChannelGroupFuture = this.allChannels().close(ChannelMatchers.isServerChannel());
            Iterator serverChannelIterator = serverChannelGroupFuture.iterator();
            while (serverChannelIterator.hasNext()) {
                SocketAddress localAddress = ((ChannelFuture)serverChannelIterator.next()).channel().localAddress();
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().info((Function0 & Serializable)() -> "Closing server channel " + localAddress, MarkerContext$.MODULE$.NoMarker());
            }
            serverChannelGroupFuture.awaitUninterruptibly(unbindTimeout.toMillis() - 100L);
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        });
        FiniteDuration serviceRequestsDoneTimeout = cs.timeout(CoordinatedShutdown$.MODULE$.PhaseServiceRequestsDone());
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseServiceRequestsDone(), "netty-server-terminate", () -> NettyServer.$anonfun$registerShutdownTasks$5(this, serviceRequestsDoneTimeout, serverTerminateTimeout, (ExecutionContext)ctx));
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate(), "user-provided-server-stop-hook", () -> NettyServer.$anonfun$registerShutdownTasks$11(this, (ExecutionContext)ctx));
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate(), "shutdown-logger", () -> NettyServer.$anonfun$registerShutdownTasks$14(this, (ExecutionContext)ctx));
    }

    private void initializeChannelOptionsStaticMembers() {
        new .colon.colon(ChannelOption.class, (List)new .colon.colon(UnixChannelOption.class, (List)new .colon.colon(EpollChannelOption.class, (List)Nil$.MODULE$))).foreach((Function1 & Serializable)clazz -> {
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().debug((Function0 & Serializable)() -> "Class " + clazz.getName() + " will be initialized (if it hasn't been initialized already)", MarkerContext$.MODULE$.NoMarker());
            return Class.forName(clazz.getName());
        });
    }

    private InetSocketAddress mainAddress$lzycompute() {
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.mainAddress = (InetSocketAddress)((Channel)this.httpChannel().orElse((Function0 & Serializable)() -> this.httpsChannel()).get()).localAddress();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.mainAddress;
    }

    public InetSocketAddress mainAddress() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.mainAddress$lzycompute();
        }
        return this.mainAddress;
    }

    private Option<ServerEndpoint> Http1Plain$lzycompute() {
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.Http1Plain = this.httpChannel().map((Function1 & Serializable)x$7 -> (InetSocketAddress)x$7.localAddress()).map((Function1 & Serializable)address -> new ServerEndpoint("Netty HTTP/1.1 (plaintext)", "http", $this.config.address(), address.getPort(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HttpProtocol$.MODULE$.HTTP_1_0(), HttpProtocol$.MODULE$.HTTP_1_1()})), this.serverHeader(), (Option)None$.MODULE$));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.Http1Plain;
    }

    private Option<ServerEndpoint> Http1Plain() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.Http1Plain$lzycompute();
        }
        return this.Http1Plain;
    }

    private Option<ServerEndpoint> Http1Encrypted$lzycompute() {
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.Http1Encrypted = this.httpsChannel().map((Function1 & Serializable)x$8 -> (InetSocketAddress)x$8.localAddress()).map((Function1 & Serializable)address -> new ServerEndpoint("Netty HTTP/1.1 (encrypted)", "https", $this.config.address(), address.getPort(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HttpProtocol$.MODULE$.HTTP_1_0(), HttpProtocol$.MODULE$.HTTP_1_1()})), this.serverHeader(), this.sslEngineProvider().map((Function1 & Serializable)x$9 -> x$9.sslContext())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.Http1Encrypted;
    }

    private Option<ServerEndpoint> Http1Encrypted() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.Http1Encrypted$lzycompute();
        }
        return this.Http1Encrypted;
    }

    public ServerEndpoints serverEndpoints() {
        return this.serverEndpoints;
    }

    private final /* synthetic */ Option liftedTree1$1() {
        Some some;
        try {
            some = new Some((Object)ServerSSLEngine$.MODULE$.createSSLEngineProvider(this.config, this.applicationProvider()));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().error((Function0 & Serializable)() -> "cannot load SSL context", (Function0 & Serializable)() -> throwable2, MarkerContext$.MODULE$.NoMarker());
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    private static final Object unwrap$1(ConfigValue value) {
        Object object = value.unwrapped();
        if (object instanceof Number) {
            Number number = (Number)object;
            return BoxesRunTime.boxToInteger((int)number.intValue());
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$setOptions$1(Map.Entry x$1) {
        return ((String)x$1.getKey()).startsWith("child.");
    }

    public static final /* synthetic */ void $anonfun$channelSink$1(NettyServer $this, boolean secure$1, int port$1, Channel connChannel) {
        Option option;
        Duration idleTimeout;
        connChannel.config().setOption(ChannelOption.AUTO_READ, (Object)Boolean.FALSE);
        ChannelConfig channelConfig = connChannel.config();
        $this.setOptions((Function2<ChannelOption<Object>, Object, Object>)(Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)channelConfig.setOption(x$1, x$2)), $this.channelOption(), $this.setOptions$default$3());
        ChannelPipeline pipeline = connChannel.pipeline();
        Object object = secure$1 ? $this.sslEngineProvider().map((Function1 & Serializable)sslEngineProvider -> {
            SSLEngine sslEngine = sslEngineProvider.createSSLEngine();
            sslEngine.setUseClientMode(false);
            if ($this.httpsWantClientAuth()) {
                sslEngine.setWantClientAuth(true);
            }
            if ($this.httpsNeedClientAuth()) {
                sslEngine.setNeedClientAuth(true);
            }
            return pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
        }) : BoxedUnit.UNIT;
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder($this.maxInitialLineLength(), $this.maxHeaderSize(), $this.maxChunkSize()));
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("decompressor", (ChannelHandler)new HttpContentDecompressor());
        Object object2 = $this.logWire() ? pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(LogLevel.DEBUG)) : BoxedUnit.UNIT;
        Duration duration = idleTimeout = secure$1 ? $this.httpsIdleTimeout() : $this.httpIdleTimeout();
        Duration.Infinite infinite = Duration$.MODULE$.Inf();
        Duration duration2 = duration;
        if (!(infinite != null ? !infinite.equals(duration2) : duration2 != null)) {
        } else if (duration != null && !(option = Duration$.MODULE$.unapply(duration)).isEmpty()) {
            long timeout = ((Tuple2)option.get())._1$mcJ$sp();
            TimeUnit timeUnit = (TimeUnit)((Object)((Tuple2)option.get())._2());
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().trace((Function0 & Serializable)() -> "using idle timeout of " + timeout + " " + timeUnit + " on port " + port$1, MarkerContext$.MODULE$.NoMarker());
            pipeline.addLast("idle-handler", (ChannelHandler)new IdleStateHandler(0L, 0L, timeout, timeUnit));
            pipeline.addLast("idle-handler-play", (ChannelHandler)new NettyIdleHandler());
        } else {
            throw new MatchError((Object)duration);
        }
        ChannelInboundHandler requestHandler = $this.newRequestHandler();
        pipeline.addLast("http-handler", (ChannelHandler)new HttpStreamsServerHandler(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)requestHandler, (List)Nil$.MODULE$)).asJava()));
        pipeline.addLast("request-handler", (ChannelHandler)requestHandler);
        EventLoop childChannelEventLoop = $this.eventLoop().next();
        childChannelEventLoop.register(connChannel);
        $this.allChannels().add(connChannel);
    }

    public static final /* synthetic */ Done$ $anonfun$registerShutdownTasks$10(boolean x$5) {
        return Done$.MODULE$;
    }

    public static final /* synthetic */ Future $anonfun$registerShutdownTasks$5(NettyServer $this, FiniteDuration serviceRequestsDoneTimeout$1, FiniteDuration serverTerminateTimeout$1, ExecutionContext ctx$1) {
        ChannelGroupFuture nonServerChannelGroupFuture = $this.allChannels().close(ChannelMatchers.isNonServerChannel());
        Iterator nonServerChannelIterator = nonServerChannelGroupFuture.iterator();
        while (nonServerChannelIterator.hasNext()) {
            SocketAddress localAddress = ((ChannelFuture)nonServerChannelIterator.next()).channel().localAddress();
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().info((Function0 & Serializable)() -> "Closing (non server) channel " + localAddress, MarkerContext$.MODULE$.NoMarker());
        }
        long startTime = System.currentTimeMillis();
        nonServerChannelGroupFuture.awaitUninterruptibly(serviceRequestsDoneTimeout$1.toMillis() - 100L);
        long elapsedTime = System.currentTimeMillis() - startTime;
        long remainingServiceRequestsDoneTimeout = serviceRequestsDoneTimeout$1.toMillis() - elapsedTime;
        long remainingServerTerminateTimeout = serverTerminateTimeout$1.toMillis() - elapsedTime;
        return package$.MODULE$.after($this.terminationDelay(), (Function0 & Serializable)() -> Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().info((Function0 & Serializable)() -> "Shutting down event loop", MarkerContext$.MODULE$.NoMarker());
            return $this.eventLoop().shutdownGracefully($this.shutdownQuietPeriod().toMillis(), remainingServerTerminateTimeout - 100L, TimeUnit.MILLISECONDS).awaitUninterruptibly(remainingServiceRequestsDoneTimeout - 100L);
        }, ctx$1), (ClassicActorSystemProvider)$this.actorSystem()).map((Function1 & Serializable)x$5 -> NettyServer.$anonfun$registerShutdownTasks$10(BoxesRunTime.unboxToBoolean((Object)x$5)), ctx$1);
    }

    public static final /* synthetic */ Future $anonfun$registerShutdownTasks$11(NettyServer $this, ExecutionContext ctx$1) {
        NettyServer$.MODULE$.play$core$server$NettyServer$$logger().info((Function0 & Serializable)() -> "Running provided shutdown stop hooks", MarkerContext$.MODULE$.NoMarker());
        return ((Future)$this.stopHook.apply()).map((Function1 & Serializable)x$6 -> Done$.MODULE$, ctx$1);
    }

    public static final /* synthetic */ Future $anonfun$registerShutdownTasks$14(NettyServer $this, ExecutionContext ctx$1) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            $this.super$stop();
            return Done$.MODULE$;
        }, ctx$1);
    }

    public NettyServer(ServerConfig config, ApplicationProvider applicationProvider, Function0<Future<?>> stopHook, ActorSystem actorSystem, Materializer materializer) {
        EpollEventLoopGroup epollEventLoopGroup;
        this.config = config;
        this.applicationProvider = applicationProvider;
        this.stopHook = stopHook;
        this.actorSystem = actorSystem;
        this.materializer = materializer;
        Server.$init$((Server)this);
        this.initializeChannelOptionsStaticMembers();
        this.serverConfig = (Configuration)config.configuration().get("play.server", ConfigLoader$.MODULE$.configurationLoader());
        this.nettyConfig = (Configuration)this.serverConfig().get("netty", ConfigLoader$.MODULE$.configurationLoader());
        this.serverHeader = ((Option)this.nettyConfig().get("server-header", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(A1))) {
                    return (B1)A1;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(string));
            }
        });
        this.maxInitialLineLength = BoxesRunTime.unboxToInt((Object)this.nettyConfig().get("maxInitialLineLength", ConfigLoader$.MODULE$.intLoader()));
        this.maxHeaderSize = (int)((ConfigMemorySize)this.serverConfig().getDeprecated("max-header-size", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"netty.maxHeaderSize"}), ConfigLoader$.MODULE$.bytesLoader())).toBytes();
        this.maxContentLength = Server$.MODULE$.getPossiblyInfiniteBytes(this.serverConfig().underlying(), "max-content-length", Server$.MODULE$.getPossiblyInfiniteBytes$default$3());
        this.maxChunkSize = BoxesRunTime.unboxToInt((Object)this.nettyConfig().get("maxChunkSize", ConfigLoader$.MODULE$.intLoader()));
        this.threadCount = BoxesRunTime.unboxToInt((Object)this.nettyConfig().get("eventLoopThreads", ConfigLoader$.MODULE$.intLoader()));
        this.logWire = BoxesRunTime.unboxToBoolean((Object)this.nettyConfig().get("log.wire", ConfigLoader$.MODULE$.booleanLoader()));
        this.bootstrapOption = (Config)this.nettyConfig().get("option", ConfigLoader$.MODULE$.configLoader());
        this.channelOption = (Config)this.nettyConfig().get("option.child", ConfigLoader$.MODULE$.configLoader());
        this.httpsWantClientAuth = BoxesRunTime.unboxToBoolean((Object)this.serverConfig().get("https.wantClientAuth", ConfigLoader$.MODULE$.booleanLoader()));
        this.httpsNeedClientAuth = BoxesRunTime.unboxToBoolean((Object)this.serverConfig().get("https.needClientAuth", ConfigLoader$.MODULE$.booleanLoader()));
        this.httpIdleTimeout = (Duration)this.serverConfig().get("http.idleTimeout", ConfigLoader$.MODULE$.durationLoader());
        this.httpsIdleTimeout = (Duration)this.serverConfig().get("https.idleTimeout", ConfigLoader$.MODULE$.durationLoader());
        this.shutdownQuietPeriod = (FiniteDuration)this.nettyConfig().get("shutdownQuietPeriod", ConfigLoader$.MODULE$.finiteDurationLoader());
        this.terminationDelay = (FiniteDuration)this.serverConfig().get("waitBeforeTermination", ConfigLoader$.MODULE$.finiteDurationLoader());
        this.terminationTimeout = this.serverConfig().getOptional("terminationTimeout", ConfigLoader$.MODULE$.finiteDurationLoader());
        this.wsBufferLimit = (int)((ConfigMemorySize)this.serverConfig().get("websocket.frame.maxLength", ConfigLoader$.MODULE$.bytesLoader())).toBytes();
        this.wsKeepAliveMode = (String)this.serverConfig().get("websocket.periodic-keep-alive-mode", ConfigLoader$.MODULE$.stringLoader());
        this.wsKeepAliveMaxIdle = (Duration)this.serverConfig().get("websocket.periodic-keep-alive-max-idle", ConfigLoader$.MODULE$.durationLoader());
        this.deferBodyParsing = this.serverConfig().underlying().getBoolean("deferBodyParsing");
        this.registerShutdownTasks();
        NamedThreadFactory threadFactory = new NamedThreadFactory("netty-event-loop");
        Product product = this.transport();
        if (Native$.MODULE$.equals(product)) {
            epollEventLoopGroup = new EpollEventLoopGroup(this.threadCount(), (ThreadFactory)threadFactory);
        } else if (Jdk$.MODULE$.equals(product)) {
            epollEventLoopGroup = new NioEventLoopGroup(this.threadCount(), (ThreadFactory)threadFactory);
        } else {
            throw new MatchError((Object)product);
        }
        this.eventLoop = epollEventLoopGroup;
        this.allChannels = new DefaultChannelGroup((EventExecutor)this.eventLoop().next());
        this.httpChannel = config.port().map((Function1 & Serializable)x$2 -> this.bindChannel(BoxesRunTime.unboxToInt((Object)x$2), false));
        this.httpsChannel = config.sslPort().map((Function1 & Serializable)x$3 -> this.bindChannel(BoxesRunTime.unboxToInt((Object)x$3), true));
        this.serverEndpoints = new ServerEndpoints((scala.collection.immutable.Seq)Option$.MODULE$.option2Iterable(this.Http1Plain()).toSeq().$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(this.Http1Encrypted()).toSeq()));
    }
}

