/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Locale;
import play.api.libs.json.EnvWrites$JsonNodeWrites$;
import play.api.libs.json.EnvWrites$TemporalFormatter$;
import play.api.libs.json.JsNumber$;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsString$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.KeyWrites$;
import play.api.libs.json.OWrites;
import play.api.libs.json.OWrites$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.libs.json.jackson.JacksonJson;
import play.api.libs.json.jackson.JacksonJson$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Set;
import scala.math.BigDecimal$;
import scala.package$;
import scala.runtime.function.JProcedure1;

public interface EnvWrites {
    public static void $init$(EnvWrites $this) {
        $this.play$api$libs$json$EnvWrites$_setter_$DefaultLocalDateTimeWrites_$eq($this.temporalWrites(DateTimeFormatter.ISO_LOCAL_DATE_TIME, (Function1 & Serializable)formatter -> this.TemporalFormatter().DefaultLocalDateTimeFormatter((DateTimeFormatter)formatter)));
        $this.play$api$libs$json$EnvWrites$_setter_$DefaultOffsetDateTimeWrites_$eq($this.temporalWrites(DateTimeFormatter.ISO_OFFSET_DATE_TIME, (Function1 & Serializable)formatter -> this.TemporalFormatter().DefaultOffsetDateTimeFormatter((DateTimeFormatter)formatter)));
        $this.play$api$libs$json$EnvWrites$_setter_$DefaultZonedDateTimeWrites_$eq($this.temporalWrites(DateTimeFormatter.ISO_ZONED_DATE_TIME, (Function1 & Serializable)formatter -> this.TemporalFormatter().DefaultZonedDateTimeFormatter((DateTimeFormatter)formatter)));
        $this.play$api$libs$json$EnvWrites$_setter_$DefaultLocalDateWrites_$eq($this.temporalWrites(DateTimeFormatter.ISO_LOCAL_DATE, (Function1 & Serializable)formatter -> this.TemporalFormatter().DefaultDateFormatter((DateTimeFormatter)formatter)));
        $this.play$api$libs$json$EnvWrites$_setter_$DefaultInstantWrites_$eq(Writes$.MODULE$.apply((Function1 & Serializable)i -> JsString$.MODULE$.apply(i.toString())));
        $this.play$api$libs$json$EnvWrites$_setter_$DefaultLocalTimeWrites_$eq($this.temporalWrites(DateTimeFormatter.ISO_TIME, (Function1 & Serializable)formatter -> this.TemporalFormatter().DefaultLocalTimeFormatter((DateTimeFormatter)formatter)));
        $this.play$api$libs$json$EnvWrites$_setter_$LocalTimeNanoOfDayWrites_$eq(Writes$.MODULE$.apply((Function1 & Serializable)t -> JsNumber$.MODULE$.apply(package$.MODULE$.BigDecimal().valueOf(t.toNanoOfDay()))));
        $this.play$api$libs$json$EnvWrites$_setter_$ZoneIdWrites_$eq(Writes$.MODULE$.apply((Function1 & Serializable)zone -> JsString$.MODULE$.apply(zone.getId())));
        $this.play$api$libs$json$EnvWrites$_setter_$LocalDateTimeEpochMilliWrites_$eq(Writes$.MODULE$.apply((Function1 & Serializable)t -> JsNumber$.MODULE$.apply(package$.MODULE$.BigDecimal().valueOf(t.toInstant(ZoneOffset.UTC).toEpochMilli()))));
        $this.play$api$libs$json$EnvWrites$_setter_$ZonedDateTimeEpochMilliWrites_$eq(new Writes<ZonedDateTime>(){

            public JsValue writes(ZonedDateTime t) {
                return JsNumber$.MODULE$.apply(package$.MODULE$.BigDecimal().valueOf(t.toInstant().toEpochMilli()));
            }
        });
        $this.play$api$libs$json$EnvWrites$_setter_$LocalDateEpochMilliWrites_$eq(Writes$.MODULE$.apply((Function1 & Serializable)t -> JsNumber$.MODULE$.apply(package$.MODULE$.BigDecimal().valueOf(t.atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli()))));
        $this.play$api$libs$json$EnvWrites$_setter_$InstantEpochMilliWrites_$eq(new Writes<Instant>(){

            public JsValue writes(Instant t) {
                return JsNumber$.MODULE$.apply(package$.MODULE$.BigDecimal().valueOf(t.toEpochMilli()));
            }
        });
        $this.play$api$libs$json$EnvWrites$_setter_$localeWrites_$eq(Writes$.MODULE$.apply((Function1 & Serializable)l -> JsString$.MODULE$.apply(KeyWrites$.MODULE$.LanguageTagWrites().writeKey((Locale)l))));
        $this.play$api$libs$json$EnvWrites$_setter_$localeObjectWrites_$eq(OWrites$.MODULE$.apply((Function1 & Serializable)l -> {
            Set extension;
            Set keywords;
            Builder fields = Predef$.MODULE$.Map().newBuilder();
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"language");
            fields.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.toJson(l.getLanguage(), Writes$.MODULE$.StringWrites())));
            Option$.MODULE$.apply((Object)l.getCountry()).filter((Function1 & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1))).foreach((Function1 & Serializable)country -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"country");
                return (Builder)fields.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.toJson(country, Writes$.MODULE$.StringWrites())));
            });
            Option$.MODULE$.apply((Object)l.getVariant()).filter((Function1 & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$2))).foreach((Function1 & Serializable)variant -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"variant");
                return (Builder)fields.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.toJson(variant, Writes$.MODULE$.StringWrites())));
            });
            Option$.MODULE$.apply((Object)l.getScript()).filter((Function1 & Serializable)_$3 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$3))).foreach((Function1 & Serializable)script -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"script");
                return (Builder)fields.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.toJson(script, Writes$.MODULE$.StringWrites())));
            });
            Set attrs = (Set)JavaConverters$.MODULE$.asScalaSetConverter(l.getUnicodeLocaleAttributes()).asScala();
            if (attrs.nonEmpty()) {
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"attributes");
                fields.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.toJson(attrs.toSet(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.StringWrites()))));
            }
            if ((keywords = (Set)JavaConverters$.MODULE$.asScalaSetConverter(l.getUnicodeLocaleKeys()).asScala()).nonEmpty()) {
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"keywords");
                Builder ks = Predef$.MODULE$.Map().newBuilder();
                keywords.foreach((Function1)(JProcedure1 & Serializable)key -> Option$.MODULE$.apply((Object)l.getUnicodeLocaleType((String)key)).foreach((Function1 & Serializable)typ -> {
                    String string = (String)Predef$.MODULE$.ArrowAssoc(key);
                    return (Builder)ks.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, typ));
                }));
                fields.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.toJson(ks.result(), Writes$.MODULE$.genericMapWrites((Writes)Writes$.MODULE$.StringWrites()))));
            }
            if ((extension = (Set)JavaConverters$.MODULE$.asScalaSetConverter(l.getExtensionKeys()).asScala()).nonEmpty()) {
                String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"extension");
                Builder ext = Predef$.MODULE$.Map().newBuilder();
                extension.foreach((Function1)(JProcedure1 & Serializable)key -> Option$.MODULE$.apply((Object)l.getExtension(Predef$.MODULE$.Character2char(key))).foreach((Function1 & Serializable)v -> {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key.toString());
                    return (Builder)ext.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, v));
                }));
                fields.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)Json$.MODULE$.toJson(ext.result(), Writes$.MODULE$.genericMapWrites((Writes)Writes$.MODULE$.StringWrites()))));
            }
            return JsObject$.MODULE$.apply((Map<String, JsValue>)((Map)fields.result()));
        }));
        $this.play$api$libs$json$EnvWrites$_setter_$javaDurationMillisWrites_$eq(Writes$.MODULE$.apply((Function1 & Serializable)d -> JsNumber$.MODULE$.apply(BigDecimal$.MODULE$.long2bigDecimal(d.toMillis()))));
        $this.play$api$libs$json$EnvWrites$_setter_$javaDurationWrites_$eq(Writes$.MODULE$.apply((Function1 & Serializable)d -> JsString$.MODULE$.apply(d.toString())));
        $this.play$api$libs$json$EnvWrites$_setter_$javaPeriodWrites_$eq(Writes$.MODULE$.apply((Function1 & Serializable)d -> JsString$.MODULE$.apply(d.toString())));
    }

    public static EnvWrites$JsonNodeWrites$ JsonNodeWrites$(EnvWrites $this) {
        return $this.JsonNodeWrites();
    }

    default public EnvWrites$JsonNodeWrites$ JsonNodeWrites() {
        return new EnvWrites$JsonNodeWrites$(this);
    }

    public static Writes jsonNodeWrites$(EnvWrites $this) {
        return $this.jsonNodeWrites();
    }

    default public <T extends JsonNode> Writes<T> jsonNodeWrites() {
        JacksonJson jacksonJson = JacksonJson$.MODULE$.get();
        return Writes$.MODULE$.apply((Function1 & Serializable)jsonNode -> jacksonJson.jsonNodeToJsValue((JsonNode)jsonNode));
    }

    public static EnvWrites$TemporalFormatter$ TemporalFormatter$(EnvWrites $this) {
        return $this.TemporalFormatter();
    }

    default public EnvWrites$TemporalFormatter$ TemporalFormatter() {
        return new EnvWrites$TemporalFormatter$(this);
    }

    public static Writes temporalWrites$(EnvWrites $this, Object formatting, Function1 f) {
        return $this.temporalWrites(formatting, f);
    }

    default public <A extends Temporal, B> Writes<A> temporalWrites(B formatting, Function1<B, TemporalFormatter<A>> f) {
        return new Writes<A>(formatting, f){
            private final Object formatting$1;
            private final Function1 f$1;
            {
                this.formatting$1 = formatting$2;
                this.f$1 = f$2;
            }

            public JsValue writes(Temporal temporal) {
                return JsString$.MODULE$.apply(((TemporalFormatter)this.f$1.apply(this.formatting$1)).format(temporal));
            }
        };
    }

    public Writes<LocalDateTime> DefaultLocalDateTimeWrites();

    public void play$api$libs$json$EnvWrites$_setter_$DefaultLocalDateTimeWrites_$eq(Writes var1);

    public Writes<OffsetDateTime> DefaultOffsetDateTimeWrites();

    public void play$api$libs$json$EnvWrites$_setter_$DefaultOffsetDateTimeWrites_$eq(Writes var1);

    public Writes<ZonedDateTime> DefaultZonedDateTimeWrites();

    public void play$api$libs$json$EnvWrites$_setter_$DefaultZonedDateTimeWrites_$eq(Writes var1);

    public Writes<LocalDate> DefaultLocalDateWrites();

    public void play$api$libs$json$EnvWrites$_setter_$DefaultLocalDateWrites_$eq(Writes var1);

    public Writes<Instant> DefaultInstantWrites();

    public void play$api$libs$json$EnvWrites$_setter_$DefaultInstantWrites_$eq(Writes var1);

    public Writes<LocalTime> DefaultLocalTimeWrites();

    public void play$api$libs$json$EnvWrites$_setter_$DefaultLocalTimeWrites_$eq(Writes var1);

    public Writes<LocalTime> LocalTimeNanoOfDayWrites();

    public void play$api$libs$json$EnvWrites$_setter_$LocalTimeNanoOfDayWrites_$eq(Writes var1);

    public Writes<ZoneId> ZoneIdWrites();

    public void play$api$libs$json$EnvWrites$_setter_$ZoneIdWrites_$eq(Writes var1);

    public Writes<LocalDateTime> LocalDateTimeEpochMilliWrites();

    public void play$api$libs$json$EnvWrites$_setter_$LocalDateTimeEpochMilliWrites_$eq(Writes var1);

    public Writes<ZonedDateTime> ZonedDateTimeEpochMilliWrites();

    public void play$api$libs$json$EnvWrites$_setter_$ZonedDateTimeEpochMilliWrites_$eq(Writes var1);

    public Writes<LocalDate> LocalDateEpochMilliWrites();

    public void play$api$libs$json$EnvWrites$_setter_$LocalDateEpochMilliWrites_$eq(Writes var1);

    public Writes<Instant> InstantEpochMilliWrites();

    public void play$api$libs$json$EnvWrites$_setter_$InstantEpochMilliWrites_$eq(Writes var1);

    public Writes<Locale> localeWrites();

    public void play$api$libs$json$EnvWrites$_setter_$localeWrites_$eq(Writes var1);

    public OWrites<Locale> localeObjectWrites();

    public void play$api$libs$json$EnvWrites$_setter_$localeObjectWrites_$eq(OWrites var1);

    public Writes<Duration> javaDurationMillisWrites();

    public void play$api$libs$json$EnvWrites$_setter_$javaDurationMillisWrites_$eq(Writes var1);

    public Writes<Duration> javaDurationWrites();

    public void play$api$libs$json$EnvWrites$_setter_$javaDurationWrites_$eq(Writes var1);

    public Writes<Period> javaPeriodWrites();

    public void play$api$libs$json$EnvWrites$_setter_$javaPeriodWrites_$eq(Writes var1);

    public interface TemporalFormatter<T extends Temporal> {
        public String format(T var1);
    }
}

