/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.evolutions;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.Environment;
import play.api.MarkerContext$;
import play.api.db.evolutions.DefaultEvolutionsApi$;
import play.api.db.evolutions.DefaultEvolutionsDatasourceConfig$;
import play.api.db.evolutions.Evolutions$;
import play.api.db.evolutions.EvolutionsConfig;
import play.api.db.evolutions.EvolutionsDatasourceConfig;
import play.api.db.evolutions.ResourceEvolutionsReader;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

@Singleton
public class EnvironmentEvolutionsReader
extends ResourceEvolutionsReader {
    private final Environment environment;
    private final EvolutionsConfig evolutionsConfig;

    @Inject
    public EnvironmentEvolutionsReader(Environment environment, EvolutionsConfig evolutionsConfig) {
        this.environment = environment;
        this.evolutionsConfig = evolutionsConfig;
    }

    public EnvironmentEvolutionsReader(Environment environment, String path) {
        this(environment, EnvironmentEvolutionsReader.EnvironmentEvolutionsReader$superArg$1(environment, path));
    }

    public EnvironmentEvolutionsReader(Environment environment) {
        this(environment, "evolutions");
    }

    @Override
    public Option<InputStream> loadResource(String db, int revision) {
        return this.findPaddedRevisionResource$1(db, BoxesRunTime.boxToInteger((int)revision).toString(), (Option)None$.MODULE$);
    }

    private static EvolutionsConfig EnvironmentEvolutionsReader$superArg$1(Environment environment, String path) {
        return new EvolutionsConfig(path){
            private final String path$1;
            {
                this.path$1 = path$2;
            }

            public EvolutionsDatasourceConfig forDatasource(String db) {
                return DefaultEvolutionsDatasourceConfig$.MODULE$.apply(true, "", "play_evolutions", true, false, false, false, false, "$evolutions{{{", "}}}", (Map<String, String>)Predef$.MODULE$.Map().empty(), true, this.path$1);
            }
        };
    }

    private final Option $anonfun$13(String db$3, String paddedRevision$tailLocal1$1) {
        String resourceName = Evolutions$.MODULE$.resourceName(db$3, paddedRevision$tailLocal1$1, this.evolutionsConfig.forDatasource(db$3).path());
        return this.environment.resource(resourceName).map((Function1 & Serializable)url -> url.toURI());
    }

    private static final String findPaddedRevisionResource$1$$anonfun$2$$anonfun$1$$anonfun$1(String original$1, String substitute$1) {
        return "Ignoring evolution script " + original$1 + ", using " + substitute$1 + " instead already";
    }

    private static final Option findPaddedRevisionResource$1$$anonfun$3(Option evolution$2) {
        return evolution$2;
    }

    private final Option findPaddedRevisionResource$1(String db$2, String paddedRevision, Option uri) {
        while (((String)paddedRevision).length() <= 15) {
            String filename = Evolutions$.MODULE$.fileName(db$2, (String)paddedRevision, this.evolutionsConfig.forDatasource(db$2).path());
            Path path = Path.of(filename, new String[0]);
            Option evolution = (path.isAbsolute() ? Some$.MODULE$.apply((Object)path.toFile()).filter((Function1 & Serializable)_$7 -> _$7.exists()).map((Function1 & Serializable)_$8 -> _$8.toURI()) : this.environment.getExistingFile(filename).map((Function1 & Serializable)_$9 -> _$9.toURI())).orElse(() -> this.$anonfun$13(db$2, (String)paddedRevision));
            uri.foreach((Function1)(JProcedure1 & Serializable)u -> evolution.foreach((Function1)(JProcedure1 & Serializable)e -> {
                String original = e.toString().substring(e.toString().lastIndexOf(47) + 1);
                String substitute = u.toString().substring(u.toString().lastIndexOf(47) + 1);
                DefaultEvolutionsApi$.MODULE$.logger().warn(() -> EnvironmentEvolutionsReader.findPaddedRevisionResource$1$$anonfun$2$$anonfun$1$$anonfun$1(original, substitute), MarkerContext$.MODULE$.NoMarker());
            }));
            String string = "0" + (String)paddedRevision;
            Option option = uri.orElse(() -> EnvironmentEvolutionsReader.findPaddedRevisionResource$1$$anonfun$3(evolution));
            paddedRevision = string;
            uri = option;
        }
        return uri.map((Function1 & Serializable)u -> u.toURL().openStream());
    }
}

