/*
 * Decompiled with CFR 0.152.
 */
package play.db.jpa;

import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.db.jpa.JPAConfig;

public class DefaultJPAConfig
implements JPAConfig {
    private Set<JPAConfig.PersistenceUnit> persistenceUnits;

    public DefaultJPAConfig(Set<JPAConfig.PersistenceUnit> set) {
        this.persistenceUnits = set;
    }

    public DefaultJPAConfig(JPAConfig.PersistenceUnit ... persistenceUnitArray) {
        this((Set<JPAConfig.PersistenceUnit>)ImmutableSet.copyOf((Object[])persistenceUnitArray));
    }

    @Override
    public Set<JPAConfig.PersistenceUnit> persistenceUnits() {
        return this.persistenceUnits;
    }

    public static JPAConfig of(String string, String string2) {
        return new DefaultJPAConfig(new JPAConfig.PersistenceUnit(string, string2));
    }

    public static JPAConfig of(String string, String string2, String string3, String string4) {
        return new DefaultJPAConfig(new JPAConfig.PersistenceUnit(string, string2), new JPAConfig.PersistenceUnit(string3, string4));
    }

    public static JPAConfig of(String string, String string2, String string3, String string4, String string5, String string6) {
        return new DefaultJPAConfig(new JPAConfig.PersistenceUnit(string, string2), new JPAConfig.PersistenceUnit(string3, string4), new JPAConfig.PersistenceUnit(string5, string6));
    }

    public static JPAConfig from(Map<String, String> map) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.add((Object)new JPAConfig.PersistenceUnit(entry.getKey(), entry.getValue()));
        }
        return new DefaultJPAConfig((Set<JPAConfig.PersistenceUnit>)builder.build());
    }

    @Singleton
    public static class JPAConfigProvider
    implements Provider<JPAConfig> {
        private final JPAConfig jpaConfig;

        @Inject
        public JPAConfigProvider(Config config) {
            String string = config.getString("play.jpa.config");
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            if (config.hasPath(string)) {
                Config config2 = config.getConfig(string);
                config2.entrySet().forEach(entry -> {
                    String string = (String)entry.getKey();
                    builder.add((Object)new JPAConfig.PersistenceUnit(string, config2.getString(string)));
                });
            }
            this.jpaConfig = new DefaultJPAConfig((Set<JPAConfig.PersistenceUnit>)builder.build());
        }

        public JPAConfig get() {
            return this.jpaConfig;
        }
    }
}

