/*
 * Decompiled with CFR 0.152.
 */
package play.api.cache.caffeine;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.pekko.actor.ActorSystem;
import play.api.cache.caffeine.DefaultCaffeineExpiry;
import play.cache.caffeine.CaffeineParser;
import play.cache.caffeine.NamedCaffeineCache;
import scala.jdk.CollectionConverters$;

public class CaffeineCacheManager {
    private final Config config;
    private final ActorSystem actorSystem;
    private final ConcurrentMap<String, NamedCaffeineCache<?, ?>> cacheMap;

    public CaffeineCacheManager(Config config, ActorSystem actorSystem) {
        this.config = config;
        this.actorSystem = actorSystem;
        this.cacheMap = new ConcurrentHashMap(16);
    }

    private Config config() {
        return this.config;
    }

    private ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public <K, V> NamedCaffeineCache<K, V> getCache(String cacheName2) {
        return this.cacheMap.computeIfAbsent(cacheName2, cacheName -> {
            Caffeine<?, ?> cacheBuilder = this.getCacheBuilder((String)cacheName);
            NamedCaffeineCache namedCache = new NamedCaffeineCache((String)cacheName, cacheBuilder.buildAsync());
            return namedCache;
        });
    }

    public Set<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheMap.keySet());
    }

    public scala.collection.immutable.Set<String> cacheNames() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this.cacheMap.keySet()).asScala().toSet();
    }

    public Caffeine<?, ?> getCacheBuilder(String cacheName) {
        DefaultCaffeineExpiry defaultExpiry = new DefaultCaffeineExpiry();
        Config caches = this.config().getConfig("caches");
        Config defaults = this.config().getConfig("defaults");
        Config cacheConfig = caches.hasPath(cacheName) ? caches.getConfig(cacheName).withFallback((ConfigMergeable)defaults) : defaults;
        return CaffeineParser.from(cacheConfig, this.actorSystem()).expireAfter((Expiry)defaultExpiry);
    }
}

