/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.cachecontrol;

import java.io.Serializable;
import java.time.ZonedDateTime;
import org.playframework.cachecontrol.Cache;
import org.playframework.cachecontrol.CacheDirectives$OnlyIfCached$;
import org.playframework.cachecontrol.CacheRequest;
import org.playframework.cachecontrol.HeaderNames$;
import org.playframework.cachecontrol.HttpDate$;
import org.playframework.cachecontrol.ResponseSelectionAction;
import org.playframework.cachecontrol.ResponseSelectionActions;
import org.playframework.cachecontrol.ResponseSelectionActions$ForwardToOrigin$;
import org.playframework.cachecontrol.ResponseSelectionActions$GatewayTimeout$;
import org.playframework.cachecontrol.ResponseSelectionActions$SelectedResponse$;
import org.playframework.cachecontrol.ResponseSelectionCalculator$;
import org.playframework.cachecontrol.StoredResponse;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.PartialOrdering;

public class ResponseSelectionCalculator {
    private final Cache cache;
    private final Ordering mostRecentOrdering;

    public ResponseSelectionCalculator(Cache cache) {
        this.cache = cache;
        this.mostRecentOrdering = new Ordering<StoredResponse>(this){
            private final /* synthetic */ ResponseSelectionCalculator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }

            public int compare(StoredResponse r1, StoredResponse r2) {
                return this.$outer.toDate(r2).compareTo(this.$outer.toDate(r1));
            }
        };
    }

    public ResponseSelectionAction selectResponse(CacheRequest request, Seq<StoredResponse> responses) {
        return (ResponseSelectionAction)this.findMatchingResponse(request, responses).getOrElse(() -> this.selectResponse$$anonfun$1(request));
    }

    public boolean uriAndMethodMatch(CacheRequest request, StoredResponse response) {
        return request.uri().equals(response.uri()) && request.method().equals(response.requestMethod());
    }

    public Ordering<StoredResponse> mostRecentOrdering() {
        return this.mostRecentOrdering;
    }

    public Option<ResponseSelectionActions.SelectedResponse> findMatchingResponse(CacheRequest request, Seq<StoredResponse> responses) {
        ResponseSelectionCalculator$.org$playframework$cachecontrol$ResponseSelectionCalculator$$$logger.trace("findMatchingResponse: request = " + request + ", responses = " + responses);
        Seq matchingResponses = (Seq)((IterableOps)responses.filter((Function1 & Serializable)_$1 -> this.uriAndMethodMatch(request, (StoredResponse)_$1))).filter((Function1 & Serializable)r -> this.cache.containsMatchingHeaders(request.headers(), r.nominatedHeaders()));
        if (matchingResponses.isEmpty()) {
            return None$.MODULE$;
        }
        StoredResponse mostRecentResponse = (StoredResponse)((IterableOps)matchingResponses.sorted(this.mostRecentOrdering())).head();
        int mostRecentIndex = responses.indexOf((Object)mostRecentResponse);
        return Some$.MODULE$.apply((Object)ResponseSelectionActions$SelectedResponse$.MODULE$.apply(mostRecentResponse, mostRecentIndex));
    }

    public ZonedDateTime toDate(StoredResponse r) {
        return HttpDate$.MODULE$.parse((String)((IterableOps)r.headers().apply((Object)HeaderNames$.MODULE$.Date())).head());
    }

    public ResponseSelectionAction noValidResponseFound(CacheRequest request) {
        ResponseSelectionCalculator$.org$playframework$cachecontrol$ResponseSelectionCalculator$$$logger.trace("noValidResponseFound: request = " + request);
        return request.directives().contains((Object)CacheDirectives$OnlyIfCached$.MODULE$) ? ResponseSelectionActions$GatewayTimeout$.MODULE$.apply("Response not found and request contains only-if-cached") : ResponseSelectionActions$ForwardToOrigin$.MODULE$.apply("Valid response not found for request");
    }

    private final ResponseSelectionAction selectResponse$$anonfun$1(CacheRequest request$1) {
        return this.noValidResponseFound(request$1);
    }
}

