/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.cachecontrol;

import java.io.Serializable;
import org.playframework.cachecontrol.Cache;
import org.playframework.cachecontrol.CacheDirectives;
import org.playframework.cachecontrol.HeaderName;
import org.playframework.cachecontrol.HeaderName$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.RichInt$;

public interface CacheDefaults
extends Cache {
    public static boolean isUnderstoodStatusCode$(CacheDefaults $this, int statusCode) {
        return $this.isUnderstoodStatusCode(statusCode);
    }

    @Override
    default public boolean isUnderstoodStatusCode(int statusCode) {
        int n = statusCode;
        if (100 == n || 101 == n) {
            return true;
        }
        int success = n;
        if (RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(200), 206).contains(success)) {
            return true;
        }
        int redirection = n;
        if (RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(300), 308).contains(redirection)) {
            return true;
        }
        int clientError = n;
        if (RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(400), 417).contains(clientError)) {
            return true;
        }
        int serverError = n;
        if (RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(500), 505).contains(serverError)) {
            return true;
        }
        int other = n;
        return false;
    }

    public static boolean isCacheableMethod$(CacheDefaults $this, String requestMethod) {
        return $this.isCacheableMethod(requestMethod);
    }

    @Override
    default public boolean isCacheableMethod(String requestMethod) {
        String string = requestMethod;
        return "GET".equals(string) || "HEAD".equals(string);
        {
        }
    }

    public static boolean isDefaultCacheable$(CacheDefaults $this, int statusCode) {
        return $this.isDefaultCacheable(statusCode);
    }

    @Override
    default public boolean isDefaultCacheable(int statusCode) {
        int n = statusCode;
        switch (n) {
            case 200: {
                return true;
            }
            case 203: {
                return true;
            }
            case 204: {
                return true;
            }
            case 206: {
                return true;
            }
            case 300: {
                return true;
            }
            case 301: {
                return true;
            }
            case 308: {
                return true;
            }
            case 404: {
                return true;
            }
            case 405: {
                return true;
            }
            case 410: {
                return true;
            }
            case 414: {
                return true;
            }
            case 501: {
                return true;
            }
        }
        int n2 = n;
        return false;
    }

    public static boolean containsMatchingHeaders$(CacheDefaults $this, Map presentedHeaders, Map nominatedHeaders) {
        return $this.containsMatchingHeaders((Map<HeaderName, Seq<String>>)presentedHeaders, (Map<HeaderName, Seq<String>>)nominatedHeaders);
    }

    @Override
    default public boolean containsMatchingHeaders(Map<HeaderName, Seq<String>> presentedHeaders, Map<HeaderName, Seq<String>> nominatedHeaders) {
        if (nominatedHeaders.isEmpty()) {
            return true;
        }
        if (nominatedHeaders.contains((Object)HeaderName$.MODULE$.apply("*"))) {
            return false;
        }
        for (HeaderName nominatedHeaderName : nominatedHeaders.keys()) {
            Option option = presentedHeaders.get((Object)nominatedHeaderName);
            if (None$.MODULE$.equals(option)) {
                return false;
            }
            if (option instanceof Some) {
                Seq presentedHeaderValues = (Seq)((Some)option).value();
                Seq nominatedHeaderValues = (Seq)nominatedHeaders.apply((Object)nominatedHeaderName);
                for (String nominatedHeaderValue : nominatedHeaderValues) {
                    if (presentedHeaderValues.exists((Function1 & Serializable)value -> value.equals(nominatedHeaderValue))) continue;
                    return false;
                }
                continue;
            }
            throw new MatchError((Object)option);
        }
        return true;
    }

    public static boolean isCacheableExtension$(CacheDefaults $this, CacheDirectives.CacheDirectiveExtension extension) {
        return $this.isCacheableExtension(extension);
    }

    @Override
    default public boolean isCacheableExtension(CacheDirectives.CacheDirectiveExtension extension) {
        return false;
    }
}

