/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web.remoting;

import com.thoughtworks.paranamer.AdaptiveParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.Paranamer;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.WriterWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picocontainer.web.remoting.AbstractPicoWebRemotingServlet;
import org.picocontainer.web.remoting.MethodVisitor;
import org.picocontainer.web.remoting.RubyWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyPicoWebRemotingServlet
extends AbstractPicoWebRemotingServlet {
    private CachingParanamer paranamer = new CachingParanamer((Paranamer)new AdaptiveParanamer());

    @Override
    protected XStream createXStream() {
        return new XStream(RubyPicoWebRemotingServlet.makeRubyDriver());
    }

    public static HierarchicalStreamDriver makeRubyDriver() {
        HierarchicalStreamDriver driver = new HierarchicalStreamDriver(){

            public HierarchicalStreamReader createReader(Reader reader) {
                throw new UnsupportedOperationException();
            }

            public HierarchicalStreamReader createReader(InputStream inputStream) {
                throw new UnsupportedOperationException();
            }

            public HierarchicalStreamWriter createWriter(Writer out) {
                RubyWriter rubyWriter = new RubyWriter(out);
                return new WriterWrapper((HierarchicalStreamWriter)rubyWriter){

                    public void startNode(String name) {
                        this.startNode(name, null);
                    }

                    public void startNode(String name, Class clazz) {
                        ((RubyWriter)this.wrapped).startNode(name.replace('-', '_'), clazz);
                    }
                };
            }

            public HierarchicalStreamWriter createWriter(OutputStream outputStream) {
                throw new UnsupportedOperationException();
            }
        };
        return driver;
    }

    @Override
    protected void respond(HttpServletRequest req, HttpServletResponse resp, String pathInfo) throws IOException {
        if ("/classdefs".equals(pathInfo)) {
            final String function = req.getParameter("fn") != null ? req.getParameter("fn") : "connection.submit";
            String init = req.getParameter("init") != null ? req.getParameter("init") : "connection";
            String classList = req.getQueryString();
            if (classList.contains("&")) {
                classList = classList.substring(0, classList.indexOf("&"));
            }
            final String[] classes = classList.split(",");
            resp.setContentType("text/plain");
            final ServletOutputStream outputStream = resp.getOutputStream();
            MethodVisitor mapv = new MethodVisitor(){

                public void method(String methodName, Method method) throws IOException {
                    outputStream.print("\n\n  def " + methodName);
                    String[] paramNames = new String[]{};
                    Class<?>[] pTypes = method.getParameterTypes();
                    if (pTypes.length > 0) {
                        paramNames = RubyPicoWebRemotingServlet.this.paranamer.lookupParameterNames((AccessibleObject)method);
                    }
                    for (int i = 0; i < paramNames.length; ++i) {
                        String name = paramNames[i];
                        if (RubyPicoWebRemotingServlet.this.isExcludedFromClassDefPublication(pTypes[i], name)) continue;
                        outputStream.print((i > 0 ? ", " : " ") + name);
                    }
                    outputStream.print("\n");
                    String rubyFunctionName = function;
                    if (method.getReturnType() == Void.TYPE) {
                        rubyFunctionName = rubyFunctionName + "?";
                    }
                    outputStream.print("    @" + rubyFunctionName + "(self.class, '" + methodName + "'");
                    for (int i = 0; i < paramNames.length; ++i) {
                        String name = paramNames[i];
                        if (RubyPicoWebRemotingServlet.this.isExcludedFromClassDefPublication(pTypes[i], name)) continue;
                        outputStream.print(", :" + name + " => " + name);
                    }
                    outputStream.println(")\n  end");
                }

                public void superClass(String superClass) throws IOException {
                    if (Arrays.binarySearch(classes, superClass) > -1) {
                        outputStream.print(" < " + superClass);
                    }
                }
            };
            for (String clazz : classes) {
                outputStream.print("class " + clazz);
                super.visitClass(clazz, mapv);
                outputStream.println("\n  def initialize " + init);
                outputStream.println("    @" + init + " = " + init);
                outputStream.println("  end\n");
                outputStream.println("\nend");
            }
        } else {
            super.respond(req, resp, pathInfo);
        }
    }

    protected boolean isExcludedFromClassDefPublication(Class<?> type, String name) {
        return type.getName().startsWith("javax.servlet");
    }
}

