/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.web.jsf;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.web.PicoServletContainerFilter;

public class PicoVariableResolver
extends VariableResolver {
    private VariableResolver nested;

    public PicoVariableResolver(VariableResolver decorated) {
        if (decorated == null) {
            throw new NullPointerException("decorated");
        }
        this.nested = decorated;
    }

    protected VariableResolver getNested() {
        return this.nested;
    }

    public Object resolveVariable(FacesContext facesContext, String name) {
        PicoContainer nano = this.getPicoContainer(facesContext);
        Object result = nano.getComponent((Object)name);
        if (result == null) {
            return this.nested.resolveVariable(facesContext, name);
        }
        return result;
    }

    protected PicoContainer getPicoContainer(FacesContext facesContext) {
        Map requestAttributeMap = facesContext.getExternalContext().getRequestMap();
        MutablePicoContainer container = null;
        if (requestAttributeMap != null) {
            container = ServletFilter.getRequestContainerForThread();
        }
        if (requestAttributeMap == null || container == null) {
            Map sessionMap = facesContext.getExternalContext().getSessionMap();
            if (sessionMap != null) {
                container = ServletFilter.getSessionContainerForThread();
            }
            if ((sessionMap == null || container == null) && (container = ServletFilter.getApplicationContainerForThread()) == null) {
                throw new EvaluationException("The NanoWar delegating variable resolver is installed, however no NanoWar container was found in the request or application scope.");
            }
        }
        return container;
    }

    public static class ServletFilter
    extends PicoServletContainerFilter {
        private static ThreadLocal<MutablePicoContainer> currentRequestContainer = new ThreadLocal();
        private static ThreadLocal<MutablePicoContainer> currentSessionContainer = new ThreadLocal();
        private static ThreadLocal<MutablePicoContainer> currentAppContainer = new ThreadLocal();

        protected void setAppContainer(MutablePicoContainer container) {
            currentAppContainer.set(container);
        }

        protected void setRequestContainer(MutablePicoContainer container) {
            currentRequestContainer.set(container);
        }

        protected void setSessionContainer(MutablePicoContainer container) {
            currentSessionContainer.set(container);
        }

        protected static MutablePicoContainer getRequestContainerForThread() {
            return currentRequestContainer.get();
        }

        protected static MutablePicoContainer getSessionContainerForThread() {
            return currentSessionContainer.get();
        }

        protected static MutablePicoContainer getApplicationContainerForThread() {
            return currentAppContainer.get();
        }
    }
}

