/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.logging.loggers;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.picocontainer.logging.Logger;

public class Log4JLogger
implements Logger {
    private static final String FQCN = Log4JLogger.class.getName();
    private final org.apache.log4j.Logger logger;

    public Log4JLogger(org.apache.log4j.Logger logger) {
        if (null == logger) {
            throw new NullPointerException("logger");
        }
        this.logger = logger;
    }

    public void trace(Object message) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, message, null);
    }

    public void trace(Object message, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, message, throwable);
    }

    public boolean isTraceEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(Object message) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, message, null);
    }

    public void debug(Object message, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, message, throwable);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void info(Object message) {
        this.logger.log(FQCN, (Priority)Level.INFO, message, null);
    }

    public void info(Object message, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.INFO, message, throwable);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void warn(Object message) {
        this.logger.log(FQCN, (Priority)Level.WARN, message, null);
    }

    public void warn(Object message, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.WARN, message, throwable);
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public void error(Object message) {
        this.logger.log(FQCN, (Priority)Level.ERROR, message, null);
    }

    public void error(Object message, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.ERROR, message, throwable);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public void fatal(Object message) {
        this.logger.log(FQCN, (Priority)Level.FATAL, message, null);
    }

    public void fatal(Object message, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.FATAL, message, throwable);
    }

    public boolean isFatalEnabled() {
        return this.logger.isEnabledFor((Priority)Level.FATAL);
    }

    public Logger getChildLogger(String name) {
        return new Log4JLogger(org.apache.log4j.Logger.getLogger((String)(this.logger.getName() + "." + name)));
    }
}

