/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.logging.loggers;

import java.io.PrintStream;
import org.picocontainer.logging.Logger;

public class ConsoleLogger
implements Logger {
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_TRACE = 1;
    public static final int LEVEL_DEBUG = 2;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_WARN = 4;
    public static final int LEVEL_ERROR = 5;
    public static final int LEVEL_FATAL = 6;
    public static final int LEVEL_NONE = 7;
    private static final String LEVEL_TRACE_STR = "TRACE";
    private static final String LEVEL_DEBUG_STR = "DEBUG";
    private static final String LEVEL_INFO_STR = "INFO";
    private static final String LEVEL_WARN_STR = "WARN";
    private static final String LEVEL_ERROR_STR = "ERROR";
    private static final String LEVEL_FATAL_STR = "FATAL";
    private final int level;
    private final PrintStream output;

    public ConsoleLogger() {
        this(0);
    }

    public ConsoleLogger(int level) {
        this(level, System.out);
    }

    public ConsoleLogger(int level, PrintStream output) {
        if (null == output) {
            throw new NullPointerException("output");
        }
        this.level = level;
        this.output = output;
    }

    public void trace(Object message) {
        this.trace(message, null);
    }

    public void trace(Object message, Throwable throwable) {
        this.output(1, LEVEL_TRACE_STR, message, throwable);
    }

    public boolean isTraceEnabled() {
        return this.level <= 1;
    }

    public void debug(Object message) {
        this.debug(message, null);
    }

    public void debug(Object message, Throwable throwable) {
        this.output(2, LEVEL_DEBUG_STR, message, throwable);
    }

    public boolean isDebugEnabled() {
        return this.level <= 2;
    }

    public void info(Object message) {
        this.info(message, null);
    }

    public void info(Object message, Throwable throwable) {
        this.output(3, LEVEL_INFO_STR, message, throwable);
    }

    public boolean isInfoEnabled() {
        return this.level <= 3;
    }

    public void warn(Object message) {
        this.warn(message, null);
    }

    public void warn(Object message, Throwable throwable) {
        this.output(4, LEVEL_WARN_STR, message, throwable);
    }

    public boolean isWarnEnabled() {
        return this.level <= 4;
    }

    public void error(Object message) {
        this.error(message, null);
    }

    public void error(Object message, Throwable throwable) {
        this.output(5, LEVEL_ERROR_STR, message, throwable);
    }

    public boolean isErrorEnabled() {
        return this.level <= 5;
    }

    public void fatal(Object message) {
        this.fatal(message, null);
    }

    public void fatal(Object message, Throwable throwable) {
        this.output(6, LEVEL_FATAL_STR, message, throwable);
    }

    public boolean isFatalEnabled() {
        return this.level <= 6;
    }

    public Logger getChildLogger(String name) {
        return this;
    }

    private void output(int level, String type, Object message, Throwable throwable) {
        if (this.level <= level) {
            this.doOutput(type, message, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doOutput(String type, Object message, Throwable throwable) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            this.output.println("[" + type + "] " + message);
            if (null != throwable) {
                throwable.printStackTrace(this.output);
            }
        }
    }

    final int getLevel() {
        return this.level;
    }
}

