/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.adapters;

import com.thoughtworks.proxy.Invoker;
import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.StandardProxyFactory;
import com.thoughtworks.proxy.kit.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ObjectReference;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.AbstractBehavior;
import org.picocontainer.behaviors.Cached;
import org.picocontainer.references.ThreadLocalReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadLocalized<T>
extends AbstractBehavior<T> {
    private transient Class[] interfaces;
    private final ProxyFactory proxyFactory;

    public ThreadLocalized(ComponentAdapter<T> delegate, ProxyFactory proxyFactory) throws PicoCompositionException {
        super((ComponentAdapter)new Cached(delegate, (ObjectReference)new ThreadLocalReference()));
        this.proxyFactory = proxyFactory;
        this.interfaces = this.getInterfaces();
    }

    public ThreadLocalized(ComponentAdapter<T> delegate) throws PicoCompositionException {
        this((ComponentAdapter<T>)new Cached(delegate, (ObjectReference)new ThreadLocalReference()), (ProxyFactory)new StandardProxyFactory());
    }

    public T getComponentInstance(PicoContainer pico, Type into) throws PicoCompositionException {
        if (this.interfaces == null) {
            this.interfaces = this.getInterfaces();
        }
        ThreadLocalInvoker invoker = new ThreadLocalInvoker(pico, this.getDelegate());
        return (T)this.proxyFactory.createProxy(this.interfaces, (Invoker)invoker);
    }

    private Class[] getInterfaces() {
        Class[] interfaces;
        Object componentKey = this.getComponentKey();
        if (componentKey instanceof Class && ((Class)componentKey).isInterface()) {
            interfaces = new Class[]{(Class)componentKey};
        } else {
            Set allInterfaces = ReflectionUtils.getAllInterfaces((Class)this.getComponentImplementation());
            interfaces = allInterfaces.toArray(new Class[allInterfaces.size()]);
        }
        if (interfaces.length == 0) {
            throw new PicoCompositionException("Can't proxy implementation for " + this.getComponentImplementation().getName() + ". It does not implement any interfaces.");
        }
        return interfaces;
    }

    public String getDescriptor() {
        return "ThreadLocal";
    }

    private static final class ThreadLocalInvoker
    implements Invoker {
        private final PicoContainer pico;
        private final ComponentAdapter delegate;

        private ThreadLocalInvoker(PicoContainer pico, ComponentAdapter delegate) {
            this.pico = pico;
            this.delegate = delegate;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object delegatedInstance = this.delegate.getComponentInstance(this.pico, null);
            if (method.equals(ReflectionUtils.equals)) {
                return args[0] != null && args[0].equals(delegatedInstance);
            }
            try {
                return method.invoke(delegatedInstance, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

