/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.adapters.InstanceAdapter;

public class PicoMap
implements Map {
    private final MutablePicoContainer mutablePicoContainer;

    public PicoMap(MutablePicoContainer mutablePicoContainer) {
        this.mutablePicoContainer = mutablePicoContainer;
    }

    public PicoMap() {
        this.mutablePicoContainer = new DefaultPicoContainer();
    }

    public int size() {
        return this.mutablePicoContainer.getComponentAdapters().size();
    }

    public boolean isEmpty() {
        return this.mutablePicoContainer.getComponentAdapters().size() == 0;
    }

    public boolean containsKey(Object o) {
        if (o instanceof Class) {
            return this.mutablePicoContainer.getComponent((Class)o) != null;
        }
        return this.mutablePicoContainer.getComponent(o) != null;
    }

    public boolean containsValue(Object o) {
        return false;
    }

    public Object get(Object o) {
        if (o instanceof Class) {
            return this.mutablePicoContainer.getComponent((Class)o);
        }
        return this.mutablePicoContainer.getComponent(o);
    }

    public Object put(Object o, Object o1) {
        Object object = this.remove(o);
        this.mutablePicoContainer.addComponent(o, o1, new Parameter[0]);
        return object;
    }

    public Object remove(Object o) {
        ComponentAdapter adapter = this.mutablePicoContainer.removeComponent(o);
        if (adapter != null) {
            return adapter instanceof InstanceAdapter ? adapter.getComponentInstance((PicoContainer)this.mutablePicoContainer, ComponentAdapter.NOTHING.class) : adapter.getComponentImplementation();
        }
        return null;
    }

    public void putAll(Map map) {
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        Set adapters = this.keySet();
        for (Object adapter : adapters) {
            this.mutablePicoContainer.removeComponent(adapter);
        }
    }

    public Set keySet() {
        HashSet<Object> set = new HashSet<Object>();
        Collection adapters = this.mutablePicoContainer.getComponentAdapters();
        for (ComponentAdapter adapter : adapters) {
            set.add(adapter.getComponentKey());
        }
        return Collections.unmodifiableSet(set);
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this.mutablePicoContainer.getComponents());
    }

    public Set entrySet() {
        HashSet<1> set = new HashSet<1>();
        Collection adapters = this.mutablePicoContainer.getComponentAdapters();
        for (ComponentAdapter adapter : adapters) {
            final Object key = adapter.getComponentKey();
            final Object component = this.mutablePicoContainer.getComponent(key);
            set.add(new Map.Entry(){

                public Object getKey() {
                    return key;
                }

                public Object getValue() {
                    return component;
                }

                public Object setValue(Object value) {
                    throw new UnsupportedOperationException("Cannot set addComponent");
                }
            });
        }
        return Collections.unmodifiableSet(set);
    }
}

