/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.monitors;

import java.lang.reflect.Constructor;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.gems.monitors.prefuse.ComponentDependencyListener;
import org.picocontainer.monitors.AbstractComponentMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentDependencyMonitor
extends AbstractComponentMonitor {
    private final ComponentDependencyListener listener;

    public ComponentDependencyMonitor(ComponentDependencyListener listener) {
        this.listener = listener;
    }

    public <T> void instantiated(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Object instantiated, Object[] injected, long duration) {
        Class<?> componentType = instantiated.getClass();
        int count = injected.length;
        if (count == 0) {
            this.listener.addDependency(new Dependency(componentType, null));
        }
        for (int i = 0; i < count; ++i) {
            Object dependent = injected[i];
            Dependency dependency = new Dependency(componentType, dependent.getClass());
            this.listener.addDependency(dependency);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Dependency {
        private final Class<?> componentType;
        private final Class<?> dependencyType;

        public Dependency(Class<?> componentType, Class<?> dependencyType) {
            this.componentType = componentType;
            this.dependencyType = dependencyType;
        }

        public boolean dependsOn(Class<?> type) {
            return type != null && type.equals(this.dependencyType);
        }

        public boolean equals(Object other) {
            if (other instanceof Dependency) {
                Dependency otherDependency = (Dependency)other;
                return Dependency.areEqualOrNull(this.componentType, otherDependency.componentType) && Dependency.areEqualOrNull(this.dependencyType, otherDependency.dependencyType);
            }
            return false;
        }

        public Class<?> getComponentType() {
            return this.componentType;
        }

        public Class<?> getDependencyType() {
            return this.dependencyType;
        }

        public String toString() {
            return this.componentType + " depends on " + this.dependencyType;
        }

        private static boolean areEqualOrNull(Class<?> type, Class<?> otherType) {
            if (type != null) {
                return type.equals(otherType);
            }
            return otherType == null;
        }
    }
}

