/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.jmx;

import java.lang.management.ManagementFactory;
import java.util.Properties;
import javax.management.MBeanServer;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.behaviors.AbstractBehaviorFactory;
import org.picocontainer.gems.GemsCharacteristics;
import org.picocontainer.gems.jmx.DynamicMBeanComponentProvider;
import org.picocontainer.gems.jmx.DynamicMBeanProvider;
import org.picocontainer.gems.jmx.JMXExposed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXExposing
extends AbstractBehaviorFactory {
    private final MBeanServer mBeanServer;
    private final DynamicMBeanProvider[] providers;

    public JMXExposing() {
        this(ManagementFactory.getPlatformMBeanServer());
    }

    public JMXExposing(MBeanServer mBeanServer, DynamicMBeanProvider[] providers) throws NullPointerException {
        if (mBeanServer == null || providers == null) {
            throw new NullPointerException();
        }
        this.mBeanServer = mBeanServer;
        this.providers = providers;
    }

    public JMXExposing(MBeanServer mBeanServer) throws NullPointerException {
        this(mBeanServer, new DynamicMBeanProvider[]{new DynamicMBeanComponentProvider()});
    }

    public <T> ComponentAdapter<T> createComponentAdapter(ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, Object componentKey, Class<T> componentImplementation, Parameter ... parameters) throws PicoCompositionException {
        ComponentAdapter delegateAdapter = super.createComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, componentKey, componentImplementation, parameters);
        if (AbstractBehaviorFactory.removePropertiesIfPresent((Properties)componentProperties, (Properties)GemsCharacteristics.NO_JMX)) {
            return delegateAdapter;
        }
        AbstractBehaviorFactory.removePropertiesIfPresent((Properties)componentProperties, (Properties)GemsCharacteristics.JMX);
        return new JMXExposed(delegateAdapter, this.mBeanServer, this.providers);
    }

    public <T> ComponentAdapter<T> addComponentAdapter(ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, ComponentAdapter<T> adapter) {
        if (AbstractBehaviorFactory.removePropertiesIfPresent((Properties)componentProperties, (Properties)GemsCharacteristics.NO_JMX)) {
            return super.addComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, adapter);
        }
        return new JMXExposed(super.addComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, adapter), this.mBeanServer, this.providers);
    }
}

