/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.behaviors;

import java.util.Properties;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.behaviors.AbstractBehaviorFactory;
import org.picocontainer.gems.GemsCharacteristics;
import org.picocontainer.gems.behaviors.Pooled;

public class Pooling
extends AbstractBehaviorFactory {
    private final Pooled.Context poolContext;

    public Pooling(Pooled.Context poolContext) {
        this.poolContext = poolContext;
    }

    public Pooling() {
        this.poolContext = new Pooled.DefaultContext();
    }

    public ComponentAdapter createComponentAdapter(ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, Object componentKey, Class componentImplementation, Parameter ... parameters) throws PicoCompositionException {
        ComponentAdapter delegate = super.createComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, componentKey, componentImplementation, parameters);
        if (AbstractBehaviorFactory.removePropertiesIfPresent((Properties)componentProperties, (Properties)GemsCharacteristics.NO_POOL)) {
            return delegate;
        }
        AbstractBehaviorFactory.removePropertiesIfPresent((Properties)componentProperties, (Properties)GemsCharacteristics.POOL);
        Pooled behavior = new Pooled(delegate, this.poolContext);
        return behavior;
    }

    public ComponentAdapter addComponentAdapter(ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, Properties componentProperties, ComponentAdapter adapter) {
        if (AbstractBehaviorFactory.removePropertiesIfPresent((Properties)componentProperties, (Properties)GemsCharacteristics.NO_POOL)) {
            return super.addComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, adapter);
        }
        AbstractBehaviorFactory.removePropertiesIfPresent((Properties)componentProperties, (Properties)GemsCharacteristics.POOL);
        return new Pooled(super.addComponentAdapter(componentMonitor, lifecycleStrategy, componentProperties, adapter), this.poolContext);
    }
}

