/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.web;

import javax.servlet.http.HttpSession;
import org.picocontainer.behaviors.Storing;

public class HttpSessionStoringAdapter {
    private Storing storingBehavior;
    private final String name;

    public HttpSessionStoringAdapter(Storing storingBehavior, String name) {
        this.storingBehavior = storingBehavior;
        this.name = name;
    }

    public synchronized void retrieveOrCreateStore(HttpSession session) {
        Storing.StoreWrapper sr = (Storing.StoreWrapper)session.getAttribute(this.name);
        if (sr != null) {
            this.storingBehavior.putCacheForThread(sr);
        } else {
            session.setAttribute(this.name, (Object)this.storingBehavior.resetCacheForThread());
        }
    }

    public void resetStore() {
        this.storingBehavior.resetCacheForThread();
    }

    public void invalidateStore() {
        this.storingBehavior.invalidateCacheForThread();
    }
}

