/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.jmx;

import javax.management.DynamicMBean;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.gems.jmx.DynamicMBeanFactory;
import org.picocontainer.gems.jmx.DynamicMBeanProvider;
import org.picocontainer.gems.jmx.JMXRegistrationException;
import org.picocontainer.gems.jmx.JMXRegistrationInfo;
import org.picocontainer.gems.jmx.MBeanInfoProvider;
import org.picocontainer.gems.jmx.ObjectNameFactory;

public abstract class AbstractConstructingProvider
implements DynamicMBeanProvider {
    public JMXRegistrationInfo provide(PicoContainer picoContainer, ComponentAdapter componentAdapter) {
        MBeanInfo mBeanInfo = null;
        MBeanInfoProvider[] mBeanInfoProviders = this.getMBeanInfoProviders();
        for (int i = 0; i < mBeanInfoProviders.length && mBeanInfo == null; ++i) {
            mBeanInfo = mBeanInfoProviders[i].provide(picoContainer, componentAdapter);
        }
        Class management = null;
        try {
            management = this.getManagementInterface(componentAdapter.getComponentImplementation(), mBeanInfo);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (management != null || mBeanInfo != null) {
            try {
                DynamicMBean mBean = this.getMBeanFactory().create(componentAdapter.getComponentInstance(picoContainer), management, mBeanInfo);
                ObjectName objectName = this.getObjectNameFactory().create(componentAdapter.getComponentKey(), mBean);
                if (objectName != null) {
                    return new JMXRegistrationInfo(objectName, mBean);
                }
            }
            catch (MalformedObjectNameException e) {
                throw new JMXRegistrationException("Cannot create ObjectName for component '" + componentAdapter.getComponentKey() + "'", e);
            }
        }
        return null;
    }

    protected abstract DynamicMBeanFactory getMBeanFactory();

    protected abstract ObjectNameFactory getObjectNameFactory();

    protected abstract MBeanInfoProvider[] getMBeanInfoProviders();

    protected abstract Class getManagementInterface(Class var1, MBeanInfo var2) throws ClassNotFoundException;
}

