/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.picocontainer.gems.util.IllegalAccessRuntimeException;
import org.picocontainer.gems.util.InvocationTargetRuntimeException;
import org.picocontainer.gems.util.NoSuchMethodRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateMethod<TARGET_TYPE, RETURN_TYPE> {
    private final Object[] args;
    private final Method method;

    public DelegateMethod(Class<TARGET_TYPE> type, String methodName, Object ... parameters) throws NoSuchMethodRuntimeException {
        this.args = parameters;
        this.method = this.findMatchingMethod(type.getMethods(), methodName, parameters);
        if (this.method == null) {
            throw new NoSuchMethodRuntimeException("Could not find method " + methodName + " in type " + type.getName());
        }
    }

    public DelegateMethod(Class<?> type, String methodName, Class<?>[] paramTypes, Object ... parameters) throws NoSuchMethodRuntimeException {
        this.args = parameters;
        try {
            this.method = type.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodRuntimeException("Could not find method " + methodName + " in type " + type.getName());
        }
    }

    public DelegateMethod(Method targetMethod, Object ... parameters) {
        this.args = parameters;
        this.method = targetMethod;
    }

    private Method findMatchingMethod(Method[] methods, String methodName, Object[] parameters) {
        Class[] paramTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            paramTypes[i] = parameters[i] == null ? NullType.class : parameters[i].getClass();
        }
        for (Method eachMethod : methods) {
            if (!eachMethod.getName().equals(methodName) || !this.isPotentialMatchingArguments(eachMethod, paramTypes)) continue;
            return eachMethod;
        }
        return null;
    }

    private boolean isPotentialMatchingArguments(Method eachMethod, Class<?>[] paramTypes) {
        Class<?>[] argParameters = eachMethod.getParameterTypes();
        if (argParameters.length != paramTypes.length) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i].getName().equals(NullType.class.getName()) || argParameters[i].isAssignableFrom(paramTypes[i])) continue;
            return false;
        }
        return true;
    }

    public RETURN_TYPE invoke() throws IllegalArgumentException, IllegalAccessRuntimeException, InvocationTargetRuntimeException {
        if (!Modifier.isStatic(this.method.getModifiers())) {
            throw new IllegalArgumentException("Method " + this.method.toGenericString() + " is not static.  Use invoke(Object) instead.");
        }
        return this.invoke(null);
    }

    private RETURN_TYPE cast(Object objectToCast) {
        return (RETURN_TYPE)objectToCast;
    }

    public <V extends TARGET_TYPE> RETURN_TYPE invoke(V target) throws IllegalAccessRuntimeException, InvocationTargetRuntimeException {
        RETURN_TYPE result;
        assert (this.args != null);
        if (!Modifier.isStatic(this.method.getModifiers()) && target == null) {
            throw new IllegalArgumentException("Method " + this.method.toGenericString() + " is not static.  Use invoke(Object) instead.");
        }
        try {
            result = this.cast(this.method.invoke(target, this.args));
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException("Method " + this.method.toGenericString() + " is not public.", e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException("There was an error invoking " + this.method.toGenericString(), e.getCause());
        }
        return result;
    }

    public String toString() {
        return "DelegateMethod " + this.method.toGenericString() + " with arguments: " + Arrays.deepToString(this.args);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DelegateMethod other = (DelegateMethod)obj;
        if (!Arrays.equals(this.args, other.args)) {
            return false;
        }
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    private static final class NullType {
        private NullType() {
        }
    }
}

