/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.jmx;

import javax.management.DynamicMBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.gems.jmx.DynamicMBeanProvider;
import org.picocontainer.gems.jmx.JMXRegistrationException;
import org.picocontainer.gems.jmx.JMXRegistrationInfo;
import org.picocontainer.gems.jmx.ObjectNameFactory;
import org.picocontainer.gems.jmx.TypedObjectNameFactory;

public class DynamicMBeanComponentProvider
implements DynamicMBeanProvider {
    private final ObjectNameFactory objectNameFactory;

    public DynamicMBeanComponentProvider() {
        this(new TypedObjectNameFactory());
    }

    public DynamicMBeanComponentProvider(ObjectNameFactory factory) {
        if (factory == null) {
            throw new NullPointerException("ObjectFactoryName is null");
        }
        this.objectNameFactory = factory;
    }

    public JMXRegistrationInfo provide(PicoContainer picoContainer, ComponentAdapter componentAdapter) {
        if (DynamicMBean.class.isAssignableFrom(componentAdapter.getComponentImplementation())) {
            DynamicMBean mBean = (DynamicMBean)componentAdapter.getComponentInstance(picoContainer, null);
            try {
                ObjectName objectName = this.objectNameFactory.create(componentAdapter.getComponentKey(), mBean);
                if (objectName != null) {
                    return new JMXRegistrationInfo(objectName, mBean);
                }
            }
            catch (MalformedObjectNameException e) {
                throw new JMXRegistrationException("Cannot create ObjectName for component '" + componentAdapter.getComponentKey() + "'", e);
            }
        }
        return null;
    }
}

