/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.jmx;

import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.StandardMBean;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.picocontainer.gems.jmx.DynamicMBeanFactory;
import org.picocontainer.gems.jmx.JMXRegistrationException;
import org.picocontainer.gems.jmx.StandardNanoMBean;

public class StandardMBeanFactory
implements DynamicMBeanFactory {
    public DynamicMBean create(Object componentInstance, Class management, MBeanInfo mBeanInfo) {
        try {
            if (mBeanInfo == null) {
                Class managementInterface = this.getManagementInterface(componentInstance.getClass(), management, null);
                return new StandardMBean(componentInstance, managementInterface);
            }
            if (mBeanInfo instanceof ModelMBeanInfo) {
                RequiredModelMBean mBean = new RequiredModelMBean((ModelMBeanInfo)((Object)mBeanInfo));
                try {
                    mBean.setManagedResource(componentInstance, "ObjectReference");
                }
                catch (InvalidTargetObjectTypeException e) {
                }
                catch (InstanceNotFoundException e) {
                    // empty catch block
                }
                return mBean;
            }
            Class managementInterface = this.getManagementInterface(componentInstance.getClass(), management, mBeanInfo);
            return new StandardNanoMBean(componentInstance, managementInterface, mBeanInfo);
        }
        catch (ClassNotFoundException e) {
            throw new JMXRegistrationException("Cannot load management interface for StandardMBean", e);
        }
        catch (NotCompliantMBeanException e) {
            throw new JMXRegistrationException("Cannot create StandardMBean", e);
        }
        catch (RuntimeOperationsException e) {
            throw new JMXRegistrationException("Cannot create ModelMBean", e);
        }
        catch (MBeanException e) {
            throw new JMXRegistrationException("Cannot create ModelMBean", e);
        }
    }

    private Class getManagementInterface(Class type, Class management, MBeanInfo mBeanInfo) throws ClassNotFoundException {
        Class managementInterface = management == null ? this.getDefaultManagementInterface(type, mBeanInfo) : management;
        return managementInterface;
    }

    public Class getDefaultManagementInterface(Class type, MBeanInfo mBeanInfo) throws ClassNotFoundException {
        ClassLoader classLoader = type.getClassLoader() != null ? type.getClassLoader() : Thread.currentThread().getContextClassLoader();
        return classLoader.loadClass((mBeanInfo == null ? type.getName() : mBeanInfo.getClassName()) + "MBean");
    }
}

