/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.monitors.prefuse;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.picocontainer.gems.monitors.ComponentDependencyMonitor;
import org.picocontainer.gems.monitors.prefuse.ComponentDependencyListener;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;

public final class PrefuseDependencyGraph
implements ComponentDependencyListener {
    private Graph graph = this.initializeGraph();
    private final Map nodes = new HashMap();

    public void addDependency(ComponentDependencyMonitor.Dependency dependency) {
        Node componentNode = this.addNode(dependency.getComponentType());
        Node dependencyNode = this.addNode(dependency.getDependencyType());
        if (dependencyNode != null) {
            this.graph.addEdge(componentNode, dependencyNode);
        }
    }

    Collection getTypes() {
        return this.nodes.keySet();
    }

    Node[] getNodes() {
        return this.nodes.values().toArray(new Node[this.nodes.size()]);
    }

    private Node addNode(Class type) {
        if (type != null && !this.nodes.containsKey(type)) {
            Node node = this.graph.addNode();
            node.set("type", (Object)type);
            this.nodes.put(type, node);
        }
        return (Node)this.nodes.get(type);
    }

    private Graph initializeGraph() {
        return this.getGraph(this.getSchema());
    }

    private Graph getGraph(Schema schema) {
        this.graph = new Graph(true);
        this.graph.addColumns(schema);
        return this.graph;
    }

    private Schema getSchema() {
        Schema schema = new Schema();
        schema.addColumn("type", Class.class, null);
        return schema;
    }

    public TupleSet getEdges() {
        return this.graph.getEdges();
    }

    public Graph getGraph() {
        return this.graph;
    }
}

