/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.monitors;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.picocontainer.Behavior;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Injector;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.monitors.ComponentMonitorHelper;
import org.picocontainer.monitors.NullComponentMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log4JComponentMonitor
implements ComponentMonitor,
Serializable {
    private transient Logger logger;
    private final ComponentMonitor delegate;

    public Log4JComponentMonitor() {
        this.delegate = new NullComponentMonitor();
    }

    public Log4JComponentMonitor(Class<?> loggerClass) {
        this(loggerClass.getName());
    }

    public Log4JComponentMonitor(String loggerName) {
        this(LogManager.getLogger((String)loggerName));
    }

    public Log4JComponentMonitor(Logger logger) {
        this();
        this.logger = logger;
    }

    public Log4JComponentMonitor(Class<?> loggerClass, ComponentMonitor delegate) {
        this(loggerClass.getName(), delegate);
    }

    public Log4JComponentMonitor(String loggerName, ComponentMonitor delegate) {
        this(LogManager.getLogger((String)loggerName), delegate);
    }

    public Log4JComponentMonitor(Logger logger, ComponentMonitor delegate) {
        this(delegate);
        this.logger = logger;
    }

    public Log4JComponentMonitor(ComponentMonitor delegate) {
        this.delegate = delegate;
    }

    public <T> Constructor<T> instantiating(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor) {
        Logger logger = this.getLogger(constructor);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)ComponentMonitorHelper.format((String)"PicoContainer: instantiating {0}", (Object[])new Object[]{ComponentMonitorHelper.ctorToString(constructor)}));
        }
        return this.delegate.instantiating(container, componentAdapter, constructor);
    }

    public <T> void instantiated(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Object instantiated, Object[] parameters, long duration) {
        Logger logger = this.getLogger(constructor);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)ComponentMonitorHelper.format((String)"PicoContainer: instantiated {0} [{1} ms], component {2}, injected [{3}]", (Object[])new Object[]{ComponentMonitorHelper.ctorToString(constructor), duration, instantiated.getClass().getName(), ComponentMonitorHelper.parmsToString((Object[])parameters)}));
        }
        this.delegate.instantiated(container, componentAdapter, constructor, instantiated, parameters, duration);
    }

    public <T> void instantiationFailed(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Exception cause) {
        Logger logger = this.getLogger(constructor);
        if (logger.isEnabledFor(Priority.WARN)) {
            logger.warn((Object)ComponentMonitorHelper.format((String)"PicoContainer: instantiation failed: {0}, reason: {1}", (Object[])new Object[]{ComponentMonitorHelper.ctorToString(constructor), cause.getMessage()}), (Throwable)cause);
        }
        this.delegate.instantiationFailed(container, componentAdapter, constructor, cause);
    }

    public Object invoking(PicoContainer container, ComponentAdapter<?> componentAdapter, Member member, Object instance, Object[] args) {
        Logger logger = this.getLogger(member);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)ComponentMonitorHelper.format((String)"PicoContainer: invoking {0} on {1}", (Object[])new Object[]{ComponentMonitorHelper.memberToString((Member)member), instance}));
        }
        return this.delegate.invoking(container, componentAdapter, member, instance, args);
    }

    public void invoked(PicoContainer container, ComponentAdapter<?> componentAdapter, Member member, Object instance, long duration, Object[] args, Object retVal) {
        Logger logger = this.getLogger(member);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)ComponentMonitorHelper.format((String)"PicoContainer: invoked {0} on {1} [{2} ms]", (Object[])new Object[]{ComponentMonitorHelper.methodToString((Member)member), instance, duration}));
        }
        this.delegate.invoked(container, componentAdapter, member, instance, duration, args, retVal);
    }

    public void invocationFailed(Member member, Object instance, Exception cause) {
        Logger logger = this.getLogger(member);
        if (logger.isEnabledFor(Priority.WARN)) {
            logger.warn((Object)ComponentMonitorHelper.format((String)"PicoContainer: invocation failed: {0} on {1}, reason: {2}", (Object[])new Object[]{ComponentMonitorHelper.memberToString((Member)member), instance, cause.getMessage()}), (Throwable)cause);
        }
        this.delegate.invocationFailed(member, instance, cause);
    }

    public void lifecycleInvocationFailed(MutablePicoContainer container, ComponentAdapter<?> componentAdapter, Method method, Object instance, RuntimeException cause) {
        Logger logger = this.getLogger(method);
        if (logger.isEnabledFor(Priority.WARN)) {
            logger.warn((Object)ComponentMonitorHelper.format((String)"PicoContainer: lifecycle invocation failed: {0} on {1}, reason: {2}", (Object[])new Object[]{ComponentMonitorHelper.methodToString((Member)method), instance, cause.getMessage()}), (Throwable)cause);
        }
        this.delegate.lifecycleInvocationFailed(container, componentAdapter, method, instance, cause);
    }

    public Object noComponentFound(MutablePicoContainer container, Object componentKey) {
        Logger logger;
        Logger logger2 = logger = this.logger != null ? this.logger : LogManager.getLogger(ComponentMonitor.class);
        if (logger.isEnabledFor(Priority.WARN)) {
            logger.warn((Object)ComponentMonitorHelper.format((String)"PicoContainer: No component for key: {0}", (Object[])new Object[]{componentKey}));
        }
        return this.delegate.noComponentFound(container, componentKey);
    }

    public Injector newInjector(Injector injector) {
        return this.delegate.newInjector(injector);
    }

    public Behavior newBehavior(Behavior behavior) {
        return this.delegate.newBehavior(behavior);
    }

    protected synchronized Logger getLogger(Member member) {
        if (this.logger != null) {
            return this.logger;
        }
        return LogManager.getLogger(member.getDeclaringClass());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        if (this.logger != null) {
            oos.writeBoolean(true);
            oos.writeUTF(this.logger.getName());
        } else {
            oos.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        boolean hasDefaultLogger = ois.readBoolean();
        if (hasDefaultLogger) {
            String defaultLoggerCategory = ois.readUTF();
            assert (defaultLoggerCategory != null) : "Serialization indicated default logger, but no logger category found in input stream.";
            this.logger = LogManager.getLogger((String)defaultLoggerCategory);
        }
    }
}

