/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.monitors;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.picocontainer.Behavior;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Injector;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.monitors.ComponentMonitorHelper;
import org.picocontainer.monitors.NullComponentMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsLoggingComponentMonitor
implements ComponentMonitor,
Serializable {
    private Log log;
    private final ComponentMonitor delegate;

    public CommonsLoggingComponentMonitor() {
        this.delegate = new NullComponentMonitor();
    }

    public CommonsLoggingComponentMonitor(Class<?> logClass) {
        this(logClass.getName());
    }

    public CommonsLoggingComponentMonitor(String logName) {
        this(LogFactory.getLog((String)logName));
    }

    public CommonsLoggingComponentMonitor(Log log) {
        this();
        this.log = log;
    }

    public CommonsLoggingComponentMonitor(Class<?> logClass, ComponentMonitor delegate) {
        this(logClass.getName(), delegate);
    }

    public CommonsLoggingComponentMonitor(String logName, ComponentMonitor delegate) {
        this(LogFactory.getLog((String)logName), delegate);
    }

    public CommonsLoggingComponentMonitor(Log log, ComponentMonitor delegate) {
        this.log = log;
        this.delegate = delegate;
    }

    public <T> Constructor<T> instantiating(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor) {
        Log log = this.getLog(constructor);
        if (log.isDebugEnabled()) {
            log.debug((Object)ComponentMonitorHelper.format((String)"PicoContainer: instantiating {0}", (Object[])new Object[]{ComponentMonitorHelper.ctorToString(constructor)}));
        }
        return this.delegate.instantiating(container, componentAdapter, constructor);
    }

    public <T> void instantiated(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Object instantiated, Object[] parameters, long duration) {
        Log log = this.getLog(constructor);
        if (log.isDebugEnabled()) {
            log.debug((Object)ComponentMonitorHelper.format((String)"PicoContainer: instantiated {0} [{1} ms], component {2}, injected [{3}]", (Object[])new Object[]{ComponentMonitorHelper.ctorToString(constructor), duration, instantiated.getClass().getName(), ComponentMonitorHelper.parmsToString((Object[])parameters)}));
        }
        this.delegate.instantiated(container, componentAdapter, constructor, instantiated, parameters, duration);
    }

    public <T> void instantiationFailed(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Exception cause) {
        Log log = this.getLog(constructor);
        if (log.isWarnEnabled()) {
            log.warn((Object)ComponentMonitorHelper.format((String)"PicoContainer: instantiation failed: {0}, reason: {1}", (Object[])new Object[]{ComponentMonitorHelper.ctorToString(constructor), cause.getMessage()}), (Throwable)cause);
        }
        this.delegate.instantiationFailed(container, componentAdapter, constructor, cause);
    }

    public Object invoking(PicoContainer container, ComponentAdapter<?> componentAdapter, Member member, Object instance, Object[] args) {
        Log log = this.getLog(member);
        if (log.isDebugEnabled()) {
            log.debug((Object)ComponentMonitorHelper.format((String)"PicoContainer: invoking {0} on {1}", (Object[])new Object[]{ComponentMonitorHelper.memberToString((Member)member), instance}));
        }
        return this.delegate.invoking(container, componentAdapter, member, instance, args);
    }

    public void invoked(PicoContainer container, ComponentAdapter<?> componentAdapter, Member member, Object instance, long duration, Object[] args, Object retVal) {
        Log log = this.getLog(member);
        if (log.isDebugEnabled()) {
            log.debug((Object)ComponentMonitorHelper.format((String)"PicoContainer: invoked {0} on {1} [{2} ms]", (Object[])new Object[]{ComponentMonitorHelper.methodToString((Member)member), instance, duration}));
        }
        this.delegate.invoked(container, componentAdapter, member, instance, duration, args, retVal);
    }

    public void invocationFailed(Member member, Object instance, Exception cause) {
        Log log = this.getLog(member);
        if (log.isWarnEnabled()) {
            log.warn((Object)ComponentMonitorHelper.format((String)"PicoContainer: invocation failed: {0} on {1}, reason: {2}", (Object[])new Object[]{ComponentMonitorHelper.memberToString((Member)member), instance, cause.getMessage()}), (Throwable)cause);
        }
        this.delegate.invocationFailed(member, instance, cause);
    }

    public void lifecycleInvocationFailed(MutablePicoContainer container, ComponentAdapter<?> componentAdapter, Method method, Object instance, RuntimeException cause) {
        Log log = this.getLog(method);
        if (log.isWarnEnabled()) {
            log.warn((Object)ComponentMonitorHelper.format((String)"PicoContainer: lifecycle invocation failed: {0} on {1}, reason: {2}", (Object[])new Object[]{ComponentMonitorHelper.methodToString((Member)method), instance, cause.getMessage()}), (Throwable)cause);
        }
        this.delegate.lifecycleInvocationFailed(container, componentAdapter, method, instance, cause);
    }

    public Object noComponentFound(MutablePicoContainer container, Object componentKey) {
        Log log;
        Log log2 = log = this.log != null ? this.log : LogFactory.getLog(ComponentMonitor.class);
        if (log.isWarnEnabled()) {
            log.warn((Object)ComponentMonitorHelper.format((String)"PicoContainer: No component for key: {0}", (Object[])new Object[]{componentKey}));
        }
        return this.delegate.noComponentFound(container, componentKey);
    }

    public Injector newInjector(Injector injector) {
        return this.delegate.newInjector(injector);
    }

    public Behavior newBehavior(Behavior behavior) {
        return this.delegate.newBehavior(behavior);
    }

    protected Log getLog(Member member) {
        if (this.log != null) {
            return this.log;
        }
        return LogFactory.getLog(member.getDeclaringClass());
    }
}

