/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.jmx;

import java.util.HashMap;
import java.util.Map;
import javax.management.DynamicMBean;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.gems.jmx.DynamicMBeanFactory;
import org.picocontainer.gems.jmx.DynamicMBeanProvider;
import org.picocontainer.gems.jmx.JMXRegistrationException;
import org.picocontainer.gems.jmx.JMXRegistrationInfo;
import org.picocontainer.gems.jmx.StandardMBeanFactory;

public class RegisteredMBeanConstructingProvider
implements DynamicMBeanProvider {
    private final DynamicMBeanFactory factory;
    private final Map registry;

    public RegisteredMBeanConstructingProvider() {
        this(new StandardMBeanFactory());
    }

    public RegisteredMBeanConstructingProvider(DynamicMBeanFactory factory) {
        this.factory = factory;
        this.registry = new HashMap();
    }

    public JMXRegistrationInfo provide(PicoContainer picoContainer, ComponentAdapter componentAdapter) {
        Object key = componentAdapter.getComponentKey();
        MBeanInfoWrapper wrapper = (MBeanInfoWrapper)this.registry.get(key);
        if (wrapper != null) {
            Object instance = componentAdapter.getComponentInstance(picoContainer, ComponentAdapter.NOTHING.class);
            Class<?> management = wrapper.getManagementInterface() != null ? wrapper.getManagementInterface() : (key instanceof Class ? (Class)key : instance.getClass());
            DynamicMBean mBean = this.factory.create(instance, management, wrapper.getMBeanInfo());
            return new JMXRegistrationInfo(wrapper.getObjectName(), mBean);
        }
        return null;
    }

    public void register(Object componentKey, ObjectName objectName, Class management, MBeanInfo mBeanInfo) {
        this.registry.put(componentKey, new MBeanInfoWrapper(mBeanInfo, objectName, management));
    }

    public void register(Object componentKey, ObjectName objectName, MBeanInfo mBeanInfo) {
        this.register(componentKey, objectName, null, mBeanInfo);
    }

    public void register(ObjectName objectName, MBeanInfo mBeanInfo) {
        try {
            this.register(this.getClass().getClassLoader().loadClass(mBeanInfo.getClassName()), objectName, mBeanInfo);
        }
        catch (ClassNotFoundException e) {
            throw new JMXRegistrationException("Cannot access class " + mBeanInfo.getClassName() + " of MBean", e);
        }
    }

    public void register(Object componentKey, ObjectName objectName) {
        this.registry.put(componentKey, new MBeanInfoWrapper(null, objectName, null));
    }

    private static class MBeanInfoWrapper {
        private final MBeanInfo mBeanInfo;
        private final ObjectName objectName;
        private final Class managementInterface;

        MBeanInfoWrapper(MBeanInfo mBeanInfo, ObjectName objectName, Class management) {
            this.mBeanInfo = mBeanInfo;
            this.objectName = objectName;
            this.managementInterface = management;
        }

        MBeanInfo getMBeanInfo() {
            return this.mBeanInfo;
        }

        ObjectName getObjectName() {
            return this.objectName;
        }

        Class getManagementInterface() {
            return this.managementInterface;
        }
    }
}

