/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.behaviors;

import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.StandardProxyFactory;
import com.thoughtworks.proxy.kit.NoOperationResetter;
import com.thoughtworks.proxy.kit.Resetter;
import com.thoughtworks.proxy.toys.nullobject.Null;
import com.thoughtworks.proxy.toys.pool.Pool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.picocontainer.Behavior;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.AbstractBehavior;

public final class Pooled
extends AbstractBehavior
implements Behavior {
    private static final long serialVersionUID = 1L;
    public static final int UNLIMITED_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_SIZE = 8;
    public static final int BLOCK_ON_WAIT = 0;
    public static final int FAIL_ON_WAIT = -1;
    public static final Resetter DEFAULT_RESETTER = new NoOperationResetter();
    private int maxPoolSize;
    private int waitMilliSeconds;
    private Pool pool;
    private int serializationMode;
    private boolean autostartGC;
    private boolean started;
    private boolean disposed;
    private boolean delegateHasLifecylce;
    private transient List<Object> components;

    public Pooled(ComponentAdapter delegate, Context context) {
        super(delegate);
        this.maxPoolSize = context.getMaxSize();
        this.waitMilliSeconds = context.getMaxWaitInMilliseconds();
        this.autostartGC = context.autostartGC();
        this.serializationMode = context.getSerializationMode();
        if (this.maxPoolSize <= 0) {
            throw new IllegalArgumentException("Invalid maximum pool size");
        }
        this.started = false;
        this.disposed = false;
        this.delegateHasLifecylce = delegate instanceof LifecycleStrategy && ((LifecycleStrategy)delegate).hasLifecycle(delegate.getComponentImplementation());
        this.components = new ArrayList<Object>();
        Class type = delegate.getComponentKey() instanceof Class ? (Class)delegate.getComponentKey() : delegate.getComponentImplementation();
        Resetter resetter = context.getResetter();
        this.pool = new Pool(type, (Resetter)(this.delegateHasLifecylce ? new LifecycleResetter(this, resetter) : resetter), context.getProxyFactory(), this.serializationMode);
    }

    protected Pooled() {
        super((ComponentAdapter)Null.object(ComponentAdapter.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getComponentInstance(PicoContainer container) {
        Object componentInstance;
        if (this.delegateHasLifecylce && this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        long now = System.currentTimeMillis();
        boolean gc = this.autostartGC;
        while (true) {
            Pool pool = this.pool;
            synchronized (pool) {
                componentInstance = this.pool.get();
                if (componentInstance != null) {
                    break;
                }
                if (this.maxPoolSize > this.pool.size()) {
                    Object component = super.getComponentInstance(container);
                    if (this.delegateHasLifecylce) {
                        this.components.add(component);
                        if (this.started) {
                            this.start(component);
                        }
                    }
                    this.pool.add(component);
                } else if (!gc) {
                    long after = System.currentTimeMillis();
                    if (this.waitMilliSeconds < 0) {
                        throw new PoolException("Pool exhausted");
                    }
                    if (this.waitMilliSeconds > 0 && after - now > (long)this.waitMilliSeconds) {
                        throw new PoolException("Time out wating for returning object into pool");
                    }
                    try {
                        this.pool.wait(this.waitMilliSeconds);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new PoolException("Interrupted waiting for returning object into the pool", e);
                    }
                } else {
                    System.gc();
                    gc = false;
                }
            }
        }
        return componentInstance;
    }

    public String getDescriptor() {
        return "Pooled";
    }

    public int size() {
        return this.pool.size();
    }

    public void start(PicoContainer container) {
        if (this.delegateHasLifecylce) {
            if (this.started) {
                throw new IllegalStateException("Already started");
            }
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            for (Object component : this.components) {
                this.start(component);
            }
            this.started = true;
            if (this.pool.size() == 0) {
                this.getComponentInstance(container);
            }
        }
    }

    public void stop(PicoContainer container) {
        if (this.delegateHasLifecylce) {
            if (!this.started) {
                throw new IllegalStateException("Not started yet");
            }
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            for (Object component : this.components) {
                this.stop(component);
            }
            this.started = false;
        }
    }

    public void dispose(PicoContainer container) {
        if (this.delegateHasLifecylce) {
            if (this.started) {
                throw new IllegalStateException("Not stopped yet");
            }
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            this.disposed = true;
            for (Object component : this.components) {
                this.dispose(component);
            }
        }
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int mode = this.serializationMode;
        if (mode == 1 && this.components.size() > 0) {
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ObjectOutputStream testStream = new ObjectOutputStream(buffer);
                testStream.writeObject(this.components);
                testStream.close();
            }
            catch (NotSerializableException e) {
                mode = -1;
            }
        }
        if (mode == 0) {
            out.writeObject(this.components);
        } else {
            out.writeObject(new ArrayList());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.components = (List)in.readObject();
    }

    public static class PoolException
    extends PicoCompositionException {
        private static final long serialVersionUID = 1L;

        public PoolException(String message, Throwable cause) {
            super(message, cause);
        }

        public PoolException(String message) {
            super(message);
        }
    }

    static final class LifecycleResetter
    implements Resetter,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Resetter delegate;
        private final Pooled adapter;

        LifecycleResetter(Pooled adapter, Resetter delegate) {
            this.adapter = adapter;
            this.delegate = delegate;
        }

        public boolean reset(Object object) {
            boolean result = this.delegate.reset(object);
            if (!result || this.adapter.disposed) {
                if (this.adapter.started) {
                    this.adapter.stop(object);
                }
                this.adapter.components.remove(object);
                if (!this.adapter.disposed) {
                    this.adapter.dispose(object);
                }
            }
            return result && !this.adapter.disposed;
        }
    }

    public static class DefaultContext
    implements Context {
        public int getMaxSize() {
            return 8;
        }

        public int getMaxWaitInMilliseconds() {
            return -1;
        }

        public boolean autostartGC() {
            return false;
        }

        public ProxyFactory getProxyFactory() {
            return new StandardProxyFactory();
        }

        public Resetter getResetter() {
            return DEFAULT_RESETTER;
        }

        public int getSerializationMode() {
            return 0;
        }
    }

    public static interface Context {
        public int getMaxSize();

        public int getMaxWaitInMilliseconds();

        public boolean autostartGC();

        public ProxyFactory getProxyFactory();

        public Resetter getResetter();

        public int getSerializationMode();
    }
}

