/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.behaviors;

import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.StandardProxyFactory;
import com.thoughtworks.proxy.toys.delegate.Delegating;
import java.lang.reflect.Method;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.AbstractBehavior;

public final class Assimilated
extends AbstractBehavior {
    private final Class type;
    private final ProxyFactory proxyFactory;
    private final boolean isCompatible;

    public Assimilated(Class type, ComponentAdapter delegate, ProxyFactory proxyFactory) throws PicoCompositionException {
        super(delegate);
        this.type = type;
        this.proxyFactory = proxyFactory;
        Class delegationType = delegate.getComponentImplementation();
        this.isCompatible = type.isAssignableFrom(delegationType);
        if (!this.isCompatible) {
            Method[] methods;
            if (!proxyFactory.canProxy(type)) {
                throw new PicoCompositionException("Cannot create proxy for type " + type.getName());
            }
            for (Method method : methods = type.getMethods()) {
                try {
                    delegationType.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new PicoCompositionException("Cannot create proxy for type " + type.getName() + ", because of incompatible method " + method.toString());
                }
            }
        }
    }

    public Assimilated(Class type, ComponentAdapter delegate) {
        this(type, delegate, (ProxyFactory)new StandardProxyFactory());
    }

    public Object getComponentInstance(PicoContainer container) throws PicoCompositionException {
        return this.isCompatible ? super.getComponentInstance(container) : Delegating.object((Class)this.type, (Object)super.getComponentInstance(container), (ProxyFactory)this.proxyFactory);
    }

    public String getDescriptor() {
        return "Assimilated";
    }

    public Class getComponentImplementation() {
        return this.isCompatible ? super.getComponentImplementation() : this.type;
    }

    public Object getComponentKey() {
        Object key = super.getComponentKey();
        if (!(!(key instanceof Class) || this.isCompatible && this.type.isAssignableFrom((Class)key))) {
            return this.type;
        }
        return key;
    }
}

