/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.ComponentMonitorStrategy;
import org.picocontainer.InjectionFactory;
import org.picocontainer.Injector;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.lifecycle.NullLifecycleStrategy;

public abstract class AbstractInjectionFactory
implements InjectionFactory,
Serializable {
    public void verify(PicoContainer container) {
    }

    public final void accept(PicoVisitor visitor) {
        visitor.visitComponentFactory(this);
    }

    protected ComponentAdapter wrapLifeCycle(Injector injector, LifecycleStrategy lifecycleStrategy) {
        if (lifecycleStrategy instanceof NullLifecycleStrategy) {
            return injector;
        }
        return new LifecycleAdapter(injector, lifecycleStrategy);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LifecycleAdapter
    implements ComponentAdapter,
    LifecycleStrategy,
    ComponentMonitorStrategy,
    Serializable {
        private final Injector injector;
        private final LifecycleStrategy lifecycleStrategy;

        public LifecycleAdapter(Injector injector, LifecycleStrategy lifecycleStrategy) {
            this.injector = injector;
            this.lifecycleStrategy = lifecycleStrategy;
        }

        @Override
        public Object getComponentKey() {
            return this.injector.getComponentKey();
        }

        public Class getComponentImplementation() {
            return this.injector.getComponentImplementation();
        }

        public Object getComponentInstance(PicoContainer container) throws PicoCompositionException {
            return this.injector.getComponentInstance(container);
        }

        public Object getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
            return this.injector.getComponentInstance(container, into);
        }

        @Override
        public void verify(PicoContainer container) throws PicoCompositionException {
            this.injector.verify(container);
        }

        @Override
        public void accept(PicoVisitor visitor) {
            this.injector.accept(visitor);
        }

        public ComponentAdapter getDelegate() {
            return this.injector;
        }

        public ComponentAdapter findAdapterOfType(Class adapterType) {
            return this.injector.findAdapterOfType(adapterType);
        }

        @Override
        public String getDescriptor() {
            return "LifecycleAdapter";
        }

        public String toString() {
            return this.getDescriptor() + ":" + this.injector.toString();
        }

        @Override
        public void start(Object component) {
            this.lifecycleStrategy.start(component);
        }

        @Override
        public void stop(Object component) {
            this.lifecycleStrategy.stop(component);
        }

        @Override
        public void dispose(Object component) {
            this.lifecycleStrategy.dispose(component);
        }

        @Override
        public boolean hasLifecycle(Class<?> type) {
            return this.lifecycleStrategy.hasLifecycle(type);
        }

        @Override
        public boolean isLazy(ComponentAdapter<?> adapter) {
            return this.lifecycleStrategy.isLazy(adapter);
        }

        @Override
        public void changeMonitor(ComponentMonitor monitor) {
            if (this.injector instanceof ComponentMonitorStrategy) {
                ((ComponentMonitorStrategy)((Object)this.injector)).changeMonitor(monitor);
            }
        }

        @Override
        public ComponentMonitor currentMonitor() {
            if (this.injector instanceof ComponentMonitorStrategy) {
                return ((ComponentMonitorStrategy)((Object)this.injector)).currentMonitor();
            }
            return null;
        }
    }
}

