/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.booter;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class PicoContainerBooter {
    private static final String COMMON_PATH = "lib/common";
    private static final String HIDDEN_PATH = "lib/hidden";

    public static void main(String[] args) throws IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException, MalformedURLException {
        new PicoContainerBooter(args);
    }

    public PicoContainerBooter(String[] args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, MalformedURLException {
        URLClassLoader commonClassLoader = new URLClassLoader(this.toURLs(COMMON_PATH), PicoContainerBooter.class.getClassLoader().getParent());
        URLClassLoader hiddenClassLoader = new URLClassLoader(this.toURLs(HIDDEN_PATH), (ClassLoader)commonClassLoader);
        System.out.println("PicoContainer Booter: Booting...");
        this.newStandalone(hiddenClassLoader, args);
        System.out.println("PicoContainer Booter: Booted.");
    }

    private void newStandalone(URLClassLoader classLoader, String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> picoStandalone = classLoader.loadClass("org.picocontainer.script.Standalone");
        try {
            Constructor<?> constructor = picoStandalone.getConstructor(String[].class);
            constructor.newInstance(new Object[]{args});
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
    }

    private URL[] toURLs(String path) throws MalformedURLException {
        File[] files = new File(path).listFiles();
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            urls[i] = files[i].toURL();
        }
        return urls;
    }
}

