/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.io.Serializable;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.picketlink.idm.ldap.internal.LDAPCustomAttributes;
import org.picketlink.idm.ldap.internal.LDAPEntry;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.User;

public class LDAPUser
extends LDAPEntry
implements User {
    private static final long serialVersionUID = 1L;

    public LDAPUser(String dnSuffix) {
        super(dnSuffix);
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("inetOrgPerson");
        oc.add("organizationalPerson");
        oc.add("person");
        oc.add("top");
        oc.add("extensibleObject");
        this.getLDAPAttributes().put(oc);
    }

    public LDAPUser() {
        this(null);
    }

    public LDAPUser(String dnSuffix, Attributes attributes) {
        this(dnSuffix);
        this.addAllLDAPAttributes(attributes);
    }

    public LDAPUser(String dnSuffix, Attributes attributes, LDAPCustomAttributes customAttributes) {
        this(dnSuffix, attributes);
        this.setCustomAttributes(customAttributes);
    }

    @Override
    protected String doGetAttributeForBinding() {
        return "uid";
    }

    public void setId(String id) {
        javax.naming.directory.Attribute theAttribute = this.getLDAPAttributes().get("uid");
        if (theAttribute == null) {
            this.getLDAPAttributes().put("uid", id);
        } else {
            theAttribute.set(0, id);
        }
    }

    public String getId() {
        javax.naming.directory.Attribute theAttribute = this.getLDAPAttributes().get("uid");
        if (theAttribute != null) {
            try {
                return (String)theAttribute.get();
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public String getKey() {
        return this.getId();
    }

    public String getFirstName() {
        javax.naming.directory.Attribute theAttribute = this.getLDAPAttributes().get("givenname");
        return this.getAttributeValue(theAttribute);
    }

    private String getAttributeValue(javax.naming.directory.Attribute attribute) {
        Object value = null;
        try {
            value = attribute.get();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        if (value != null) {
            if (value.getClass().isArray()) {
                return ((Object[])value)[0].toString();
            }
            return value.toString();
        }
        return null;
    }

    public void setFirstName(String firstName) {
        this.getLDAPAttributes().put("givenname", firstName);
    }

    public String getLastName() {
        javax.naming.directory.Attribute theAttribute = this.getLDAPAttributes().get("sn");
        return this.getAttributeValue(theAttribute);
    }

    public void setLastName(String lastName) {
        this.getLDAPAttributes().put("sn", lastName);
    }

    public void setFullName(String fullName) {
        this.getLDAPAttributes().put("cn", fullName);
    }

    public String getEmail() {
        try {
            javax.naming.directory.Attribute theAttribute = this.getLDAPAttributes().get("mail");
            if (theAttribute != null) {
                return (String)theAttribute.get();
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public void setEmail(String email) {
        this.setAttribute((Attribute<? extends Serializable>)new Attribute("mail", (Serializable)((Object)email)));
    }

    public String getUserCN() {
        String fullName = this.getFirstName();
        if (this.getLastName() != null) {
            fullName = fullName + " " + this.getLastName();
        }
        return fullName;
    }
}

