/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.SimpleRelationship;
import org.picketlink.idm.query.QueryParameter;

public class RelationshipHandler
extends IdentityTypeHandler<Relationship> {
    @Override
    protected void doPopulateIdentityInstance(Object toIdentity, Relationship fromRelationship, JPAIdentityStore store) {
        store.setModelProperty(toIdentity, "IDENTITY_NAME", fromRelationship.getName(), true);
        Object relatedFromIdentity = store.lookupIdentityObjectById(fromRelationship.from());
        store.setModelProperty(toIdentity, "IDENTITY_RELATED_TO", relatedFromIdentity, true);
        Object relatesToIdentity = store.lookupIdentityObjectById(fromRelationship.to());
        store.setModelProperty(toIdentity, "IDENTITY_RELATES_TO", relatesToIdentity, true);
    }

    @Override
    void remove(Object identity, Relationship identityType, JPAIdentityStore store) {
    }

    @Override
    protected AbstractBaseEvent raiseCreatedEvent(Relationship fromIdentityType, JPAIdentityStore store) {
        return new AbstractBaseEvent(){};
    }

    @Override
    protected AbstractBaseEvent raiseUpdatedEvent(Relationship fromIdentityType, JPAIdentityStore store) {
        return new AbstractBaseEvent(){};
    }

    @Override
    protected AbstractBaseEvent raiseDeletedEvent(Relationship fromIdentityType, JPAIdentityStore store) {
        return new AbstractBaseEvent(){};
    }

    @Override
    protected Relationship doCreateIdentityType(Object identity, JPAIdentityStore store) {
        String name = store.getModelProperty(String.class, identity, "IDENTITY_NAME");
        Object relatesToInstance = store.getModelProperty(Object.class, identity, "IDENTITY_RELATES_TO");
        String relatesToDiscriminator = store.getConfig().getModelProperty("IDENTITY_DISCRIMINATOR").getValue(relatesToInstance).toString();
        IdentityTypeHandler<IdentityType> relatesToIdentityTypeManager = store.getConfig().getIdentityTypeManager(relatesToDiscriminator);
        IdentityType relatesToType = relatesToIdentityTypeManager.createIdentityType(null, relatesToInstance, store);
        Object relatedToInstance = store.getModelProperty(Object.class, identity, "IDENTITY_RELATED_TO");
        String relatedToDiscriminator = store.getConfig().getModelProperty("IDENTITY_DISCRIMINATOR").getValue(relatesToInstance).toString();
        IdentityTypeHandler<IdentityType> relatedToTypeManager = store.getConfig().getIdentityTypeManager(relatedToDiscriminator);
        IdentityType relatedToType = relatedToTypeManager.createIdentityType(null, relatedToInstance, store);
        SimpleRelationship relationship = new SimpleRelationship(name);
        relationship.setFrom(relatedToType);
        relationship.setTo(relatesToType);
        return relationship;
    }

    @Override
    public List<Predicate> getPredicate(QueryParameter queryParameter, Object[] parameterValues, JPACriteriaQueryBuilder criteria, JPAIdentityStore store) {
        List<Predicate> predicates = super.getPredicate(queryParameter, parameterValues, criteria, store);
        CriteriaBuilder builder = criteria.getBuilder();
        if (queryParameter.equals(Relationship.NAME)) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(store.getConfig().getModelProperty("IDENTITY_NAME").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(Relationship.TO)) {
            Object relatesFromIdentity = store.lookupIdentityObjectById((IdentityType)parameterValues[0]);
            predicates.add(builder.equal((Expression)criteria.getRoot().get(store.getConfig().getModelProperty("IDENTITY_RELATES_TO").getName()), relatesFromIdentity));
        }
        if (queryParameter.equals(Relationship.FROM)) {
            Object relatedFromIdentity = store.lookupIdentityObjectById((IdentityType)parameterValues[0]);
            predicates.add(builder.equal((Expression)criteria.getRoot().get(store.getConfig().getModelProperty("IDENTITY_RELATED_TO").getName()), relatedFromIdentity));
        }
        return predicates;
    }
}

