/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.internal.util.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.NamedPropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.PropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.PropertyQueries;
import org.picketlink.idm.internal.util.properties.query.TypedPropertyCriteria;
import org.picketlink.idm.jpa.annotations.IDMAttribute;
import org.picketlink.idm.jpa.annotations.IDMProperty;
import org.picketlink.idm.jpa.annotations.PropertyType;
import org.picketlink.idm.jpa.internal.AgentHandler;
import org.picketlink.idm.jpa.internal.GroupHandler;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.RelationshipHandler;
import org.picketlink.idm.jpa.internal.RoleHandler;
import org.picketlink.idm.jpa.internal.UserHandler;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.spi.IdentityStore;

public class JPAIdentityStoreConfiguration
extends IdentityStoreConfiguration {
    private static final String DEFAULT_USER_IDENTITY_DISCRIMINATOR = "USER";
    private static final String DEFAULT_ROLE_IDENTITY_DISCRIMINATOR = "ROLE";
    private static final String DEFAULT_GROUP_IDENTITY_DISCRIMINATOR = "GROUP";
    private static final String DEFAULT_AGENT_IDENTITY_DISCRIMINATOR = "AGENT";
    private static final String DEFAULT_RELATIONSHIP_IDENTITY_DISCRIMINATOR = "RELATIONSHIP";
    private String identityTypeAgent = "AGENT";
    private String identityTypeUser = "USER";
    private String identityTypeRole = "ROLE";
    private String identityTypeGroup = "GROUP";
    private String identityTypeRelationship = "RELATIONSHIP";
    public static final String PROPERTY_IDENTITY_DISCRIMINATOR = "IDENTITY_DISCRIMINATOR";
    public static final String PROPERTY_IDENTITY_KEY = "IDENTITY_KEY";
    public static final String PROPERTY_IDENTITY_ENABLED = "IDENTITY_ENABLED";
    public static final String PROPERTY_IDENTITY_CREATED = "IDENTITY_CREATED";
    public static final String PROPERTY_IDENTITY_EXPIRES = "IDENTITY_EXPIRES";
    public static final String PROPERTY_IDENTITY_PARTITION = "IDENTITY_PARTITION";
    public static final String PROPERTY_IDENTITY_RELATES_TO = "IDENTITY_RELATES_TO";
    public static final String PROPERTY_IDENTITY_RELATED_TO = "IDENTITY_RELATED_TO";
    public static final String PROPERTY_PARTITION_NAME = "PARTITION_NAME";
    public static final String PROPERTY_PARTITION_TYPE = "PARTITION_TYPE";
    public static final String PROPERTY_PARTITION_PARENT = "PARTITION_PARENT";
    public static final String PROPERTY_USER_FIRST_NAME = "USER_FIRST_NAME";
    public static final String PROPERTY_USER_LAST_NAME = "USER_LAST_NAME";
    public static final String PROPERTY_USER_EMAIL = "USER_EMAIL";
    public static final String PROPERTY_IDENTITY_ID = "IDENTITY_ID";
    public static final String PROPERTY_IDENTITY_NAME = "IDENTITY_NAME";
    public static final String PROPERTY_PARENT_GROUP = "PARENT_GROUP";
    public static final String PROPERTY_MEMBERSHIP_MEMBER = "MEMBERSHIP_MEMBER";
    public static final String PROPERTY_MEMBERSHIP_ROLE = "MEMBERSHIP_ROLE";
    public static final String PROPERTY_MEMBERSHIP_GROUP = "MEMBERSHIP_GROUP";
    public static final String PROPERTY_CREDENTIAL_VALUE = "CREDENTIAL_VALUE";
    public static final String PROPERTY_CREDENTIAL_TYPE = "CREDENTIAL_TYPE";
    public static final String PROPERTY_CREDENTIAL_TYPE_NAME = "CREDENTIAL_TYPE_NAME";
    public static final String PROPERTY_CREDENTIAL_EFFECTIVE_DATE = "CREDENTIAL_EFFECTIVE_DATE";
    public static final String PROPERTY_CREDENTIAL_EXPIRY_DATE = "CREDENTIAL_EXPIRY_DATE";
    public static final String PROPERTY_CREDENTIAL_IDENTITY = "CREDENTIAL_IDENTITY";
    public static final String PROPERTY_CREDENTIAL_ATTRIBUTE_NAME = "CREDENTIAL_ATTRIBUTE_NAME";
    public static final String PROPERTY_CREDENTIAL_ATTRIBUTE_VALUE = "CREDENTIAL_ATTRIBUTE_VALUE";
    public static final String PROPERTY_CREDENTIAL_ATTRIBUTE = "CREDENTIAL_ATTRIBUTE";
    public static final String PROPERTY_CREDENTIAL_ATTRIBUTE_TYPE = "CREDENTIAL_ATTRIBUTE_TYPE";
    public static final String PROPERTY_ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
    public static final String PROPERTY_ATTRIBUTE_VALUE = "ATTRIBUTE_VALUE";
    public static final String PROPERTY_ATTRIBUTE_IDENTITY = "ATTRIBUTE_IDENTITY";
    public static final String PROPERTY_ATTRIBUTE_TYPE = "ATTRIBUTE_TYPE";
    private static final String ATTRIBUTE_TYPE_TEXT = "text";
    private static final String ATTRIBUTE_TYPE_BOOLEAN = "boolean";
    private static final String ATTRIBUTE_TYPE_DATE = "date";
    private static final String ATTRIBUTE_TYPE_INT = "int";
    private static final String ATTRIBUTE_TYPE_LONG = "long";
    private static final String ATTRIBUTE_TYPE_FLOAT = "float";
    private static final String ATTRIBUTE_TYPE_DOUBLE = "double";
    private Map<String, IdentityTypeHandler<? extends IdentityType>> identityTypeStores = new HashMap<String, IdentityTypeHandler<? extends IdentityType>>();
    private Set<IdentityStore.Feature> featureSet = new HashSet<IdentityStore.Feature>();
    private Map<String, Property<Object>> modelProperties = new HashMap<String, Property<Object>>();
    private Map<String, MappedAttribute> attributeProperties = new HashMap<String, MappedAttribute>();
    private Class<?> identityClass;
    private Class<?> membershipClass;
    private Class<?> credentialClass;
    private Class<?> attributeClass;
    private Class<?> partitionClass;
    private Class<?> credentialAttributeClass;

    public Class<?> getIdentityClass() {
        return this.identityClass;
    }

    public void setIdentityClass(Class<?> identityClass) {
        this.identityClass = identityClass;
    }

    public Class<?> getCredentialClass() {
        return this.credentialClass;
    }

    public void setCredentialClass(Class<?> credentialClass) {
        this.credentialClass = credentialClass;
    }

    public Class<?> getCredentialAttributeClass() {
        return this.credentialAttributeClass;
    }

    public void setCredentialAttributeClass(Class<?> credentialAttributeClass) {
        this.credentialAttributeClass = credentialAttributeClass;
    }

    public Class<?> getMembershipClass() {
        return this.membershipClass;
    }

    public void setMembershipClass(Class<?> membershipClass) {
        this.membershipClass = membershipClass;
    }

    public Class<?> getAttributeClass() {
        return this.attributeClass;
    }

    public void setAttributeClass(Class<?> attributeClass) {
        this.attributeClass = attributeClass;
    }

    public boolean isConfigured() {
        return this.identityClass != null;
    }

    protected Property<Object> findNamedProperty(Class<?> targetClass, String ... allowedNames) {
        List props = PropertyQueries.createQuery(targetClass).addCriteria(new TypedPropertyCriteria(String.class)).addCriteria(new NamedPropertyCriteria(allowedNames)).getResultList();
        for (String name : allowedNames) {
            for (Property<Object> property : props) {
                if (!name.equals(property.getName())) continue;
                return property;
            }
        }
        return null;
    }

    public Property<Object> getModelProperty(String propertyKey) {
        return this.modelProperties.get(propertyKey);
    }

    public boolean isModelPropertySet(String propertyKey) {
        return this.modelProperties.containsKey(propertyKey);
    }

    public Map<String, MappedAttribute> getAttributeProperties() {
        return this.attributeProperties;
    }

    public Set<IdentityStore.Feature> getFeatureSet() {
        return this.featureSet;
    }

    public void init() throws SecurityConfigurationException {
        if (this.identityClass == null) {
            throw new SecurityConfigurationException("Error initializing JpaIdentityStore - identityClass not set");
        }
        this.configureIdentityDiscriminator();
        this.configureIdentityKey();
        this.configureIdentityId();
        this.configureIdentityName();
        this.configureIdentityParentGroup();
        this.configureIdentityRelatesTo();
        this.configureIdentityEnabled();
        this.configureIdentityCreationDate();
        this.configureIdentityExpiryDate();
        this.configureIdentityPartition();
        this.configurePartitions();
        this.configureUserProperties();
        this.configureMemberships();
        this.configureAttributes();
        this.configureCredentials();
        this.configureIdentityTypeHandlers();
        this.featureSet.add(IdentityStore.Feature.all);
    }

    private void configureCredentials() {
        if (this.credentialClass != null) {
            List props = PropertyQueries.createQuery(this.credentialClass).addCriteria(new PropertyTypeCriteria(PropertyType.CREDENTIAL_TYPE)).getResultList();
            if (props.size() != 1) {
                if (props.size() > 1) {
                    throw new SecurityConfigurationException("Ambiguous credential type property in credential class " + this.credentialClass.getName());
                }
                throw new SecurityConfigurationException("No credential type property found in credential class " + this.credentialClass.getName());
            }
            this.modelProperties.put(PROPERTY_CREDENTIAL_TYPE, props.get(0));
            props = PropertyQueries.createQuery(this.credentialClass).addCriteria(new PropertyTypeCriteria(PropertyType.CREDENTIAL)).getResultList();
            if (props.size() != 1) {
                if (props.size() > 1) {
                    throw new SecurityConfigurationException("Ambiguous credential property in credential class " + this.credentialClass.getName());
                }
                throw new SecurityConfigurationException("No credential property found in credential class " + this.credentialClass.getName());
            }
            this.modelProperties.put(PROPERTY_CREDENTIAL_VALUE, props.get(0));
            props = PropertyQueries.createQuery(this.credentialClass).addCriteria(new PropertyTypeCriteria(PropertyType.IDENTITY_TYPE)).getResultList();
            if (props.size() != 1) {
                if (props.size() > 1) {
                    throw new SecurityConfigurationException("Ambiguous identity type property in credential class " + this.credentialClass.getName());
                }
                throw new SecurityConfigurationException("No identity type property found in credential class " + this.credentialClass.getName());
            }
            this.modelProperties.put(PROPERTY_CREDENTIAL_IDENTITY, props.get(0));
            props = PropertyQueries.createQuery(this.credentialClass).addCriteria(new PropertyTypeCriteria(PropertyType.CREDENTIAL_EFFECTIVE_DATE)).getResultList();
            if (props.size() != 1) {
                if (props.size() > 1) {
                    throw new SecurityConfigurationException("Ambiguous effective date property in credential class " + this.credentialClass.getName());
                }
                throw new SecurityConfigurationException("No effective date property found in credential class " + this.credentialClass.getName());
            }
            this.modelProperties.put(PROPERTY_CREDENTIAL_EFFECTIVE_DATE, props.get(0));
            props = PropertyQueries.createQuery(this.credentialClass).addCriteria(new PropertyTypeCriteria(PropertyType.CREDENTIAL_EXPIRY_DATE)).getResultList();
            if (props.size() != 1) {
                if (props.size() > 1) {
                    throw new SecurityConfigurationException("Ambiguous expiry date property in credential class " + this.credentialClass.getName());
                }
                throw new SecurityConfigurationException("No expiry date property found in credential class " + this.credentialClass.getName());
            }
            this.modelProperties.put(PROPERTY_CREDENTIAL_EXPIRY_DATE, props.get(0));
            if (this.credentialAttributeClass != null) {
                props = PropertyQueries.createQuery(this.credentialAttributeClass).addCriteria(new PropertyTypeCriteria(PropertyType.NAME)).addCriteria(new TypedPropertyCriteria(String.class)).getResultList();
                if (props.size() != 1) {
                    if (props.size() > 1) {
                        throw new SecurityConfigurationException("Ambiguous attribute name property in attribute class " + this.attributeClass.getName());
                    }
                    throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no name property found in attribute class " + this.attributeClass.getName());
                }
                this.modelProperties.put(PROPERTY_CREDENTIAL_ATTRIBUTE_NAME, props.get(0));
                props = PropertyQueries.createQuery(this.credentialAttributeClass).addCriteria(new PropertyTypeCriteria(PropertyType.VALUE)).getResultList();
                if (props.size() != 1) {
                    if (props.size() > 1) {
                        throw new SecurityConfigurationException("Ambiguous attribute value property in class " + this.attributeClass.getName());
                    }
                    throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no value property found in attribute class " + this.attributeClass.getName());
                }
                this.modelProperties.put(PROPERTY_CREDENTIAL_ATTRIBUTE_VALUE, props.get(0));
                props = PropertyQueries.createQuery(this.credentialAttributeClass).addCriteria(new TypedPropertyCriteria(this.credentialClass)).getResultList();
                if (props.size() != 1) {
                    if (props.size() > 1) {
                        throw new SecurityConfigurationException("Ambiguous identity property in attribute class " + this.attributeClass.getName());
                    }
                    throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no attribute identity property found.");
                }
                this.modelProperties.put(PROPERTY_CREDENTIAL_ATTRIBUTE, props.get(0));
                props = PropertyQueries.createQuery(this.credentialAttributeClass).addCriteria(new PropertyTypeCriteria(PropertyType.ATTRIBUTE_TYPE)).getResultList();
                if (props.size() == 1) {
                    this.modelProperties.put(PROPERTY_CREDENTIAL_ATTRIBUTE_TYPE, props.get(0));
                } else {
                    if (props.size() > 1) {
                        throw new SecurityConfigurationException("Ambiguous attribute type property in class " + this.attributeClass.getName());
                    }
                    throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no attribute type property found in attribute class " + this.attributeClass.getName());
                }
            }
        }
    }

    private void configureCredentialProperty(Property<Object> property, String modelPropertyName) {
        if (this.modelProperties.containsKey(modelPropertyName)) {
            throw new SecurityConfigurationException("Ambiguous property [" + property.getAnnotatedElement().getAnnotation(IDMProperty.class).value() + "] in credential class " + this.credentialClass.getName());
        }
        this.modelProperties.put(modelPropertyName, property);
    }

    private void configureIdentityTypeHandlers() {
        this.identityTypeStores.put(this.getIdentityTypeDiscriminator(User.class), new UserHandler());
        this.identityTypeStores.put(this.getIdentityTypeDiscriminator(Agent.class), new AgentHandler());
        this.identityTypeStores.put(this.getIdentityTypeDiscriminator(Role.class), new RoleHandler());
        this.identityTypeStores.put(this.getIdentityTypeDiscriminator(Group.class), new GroupHandler());
        this.identityTypeStores.put(this.getIdentityTypeDiscriminator(Relationship.class), new RelationshipHandler());
    }

    protected void configureIdentityDiscriminator() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.DISCRIMINATOR)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_DISCRIMINATOR, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity discriminator property in identity class " + this.identityClass.getName());
            }
            Property<Object> p = this.findNamedProperty(this.identityClass, "discriminator", "identityType", "identityTypeName", "typeName", "type");
            if (p != null) {
                this.modelProperties.put(PROPERTY_IDENTITY_DISCRIMINATOR, p);
            }
        }
    }

    protected void configureIdentityKey() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.KEY)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_KEY, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity key property in identity class " + this.identityClass.getName());
            }
            props = PropertyQueries.createQuery(this.identityClass).addCriteria(new NamedPropertyCriteria("key")).getResultList();
            if (!props.isEmpty()) {
                this.modelProperties.put(PROPERTY_IDENTITY_KEY, props.get(0));
            } else {
                throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no key property found in identity class " + this.identityClass.getName());
            }
        }
    }

    protected void configureIdentityId() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.ID)).getResultList();
        if (props.size() != 1) {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity id property in identity class " + this.identityClass.getName());
            }
            throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no id property found in identity class " + this.identityClass.getName());
        }
        this.modelProperties.put(PROPERTY_IDENTITY_ID, props.get(0));
    }

    protected void configureIdentityName() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.NAME)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_NAME, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity name property in identity class " + this.identityClass.getName());
            }
            Property<Object> prop = this.findNamedProperty(this.identityClass, "name");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_IDENTITY_NAME, prop);
            } else {
                throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no name property found in identity class " + this.identityClass.getName());
            }
        }
    }

    protected void configureIdentityParentGroup() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.PARENT_GROUP)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_PARENT_GROUP, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity parent group property in identity class " + this.identityClass.getName());
            }
            Property<Object> prop = this.findNamedProperty(this.identityClass, "parentGroup", "parent");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_PARENT_GROUP, prop);
            } else {
                throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no parent group property found in identity class " + this.identityClass.getName());
            }
        }
    }

    protected void configureIdentityRelatesTo() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.RELATES_TO)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_RELATES_TO, props.get(0));
        } else if (props.size() > 1) {
            throw new SecurityConfigurationException("Ambiguous relates to property in identity class " + this.identityClass.getName());
        }
        props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.RELATED_TO)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_RELATED_TO, props.get(0));
        } else if (props.size() > 1) {
            throw new SecurityConfigurationException("Ambiguous related to property in identity class " + this.identityClass.getName());
        }
    }

    protected void configureIdentityEnabled() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.ENABLED)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_ENABLED, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity enabled property in identity class " + this.identityClass.getName());
            }
            Property<Object> prop = this.findNamedProperty(this.identityClass, "enabled", "active");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_IDENTITY_ENABLED, props.get(0));
            }
        }
    }

    protected void configureIdentityCreationDate() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.CREATION_DATE)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_CREATED, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity creation date property in identity class " + this.identityClass.getName());
            }
            Property<Object> prop = this.findNamedProperty(this.identityClass, "created", "creationDate");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_IDENTITY_CREATED, prop);
            }
        }
    }

    protected void configureIdentityExpiryDate() throws SecurityConfigurationException {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.EXPIRY_DATE)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_EXPIRES, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity expiry date property in identity class " + this.identityClass.getName());
            }
            Property<Object> prop = this.findNamedProperty(this.identityClass, "expires", "expiryDate");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_IDENTITY_EXPIRES, prop);
            }
        }
    }

    protected void configureIdentityPartition() {
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.PARTITION)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_IDENTITY_PARTITION, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous identity partition property in identity class " + this.identityClass.getName());
            }
            Property<Object> prop = this.findNamedProperty(this.identityClass, "partition");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_IDENTITY_PARTITION, prop);
            }
        }
    }

    protected void configurePartitions() {
        if (this.partitionClass == null) {
            return;
        }
        List props = PropertyQueries.createQuery(this.partitionClass).addCriteria(new PropertyTypeCriteria(PropertyType.NAME)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_PARTITION_NAME, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous name property in partition class " + this.partitionClass.getName());
            }
            Property<Object> prop = this.findNamedProperty(this.partitionClass, "name", "id");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_PARTITION_NAME, prop);
            }
        }
        props = PropertyQueries.createQuery(this.partitionClass).addCriteria(new PropertyTypeCriteria(PropertyType.PARTITION_TYPE)).getResultList();
    }

    protected void configureUserProperties() throws SecurityConfigurationException {
        Property<Object> prop;
        List props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.FIRST_NAME)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_USER_FIRST_NAME, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous first name property in identity class " + this.identityClass.getName());
            }
            prop = this.findNamedProperty(this.identityClass, "firstName");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_USER_FIRST_NAME, prop);
            }
        }
        props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.LAST_NAME)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_USER_LAST_NAME, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous last name property in identity class " + this.identityClass.getName());
            }
            prop = this.findNamedProperty(this.identityClass, "lastName");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_USER_LAST_NAME, prop);
            }
        }
        props = PropertyQueries.createQuery(this.identityClass).addCriteria(new PropertyTypeCriteria(PropertyType.EMAIL)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_USER_EMAIL, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous e-mail property in identity class " + this.identityClass.getName());
            }
            prop = this.findNamedProperty(this.identityClass, "email");
            if (prop != null) {
                this.modelProperties.put(PROPERTY_USER_EMAIL, prop);
            }
        }
    }

    protected void configureMemberships() throws SecurityConfigurationException {
        Property<Object> p;
        if (this.membershipClass == null) {
            return;
        }
        List props = PropertyQueries.createQuery(this.membershipClass).addCriteria(new TypedPropertyCriteria(this.identityClass)).addCriteria(new PropertyTypeCriteria(PropertyType.MEMBER)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_MEMBERSHIP_MEMBER, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous member property in membership class " + this.membershipClass.getName());
            }
            p = this.findNamedProperty(this.membershipClass, "member");
            if (p != null) {
                this.modelProperties.put(PROPERTY_MEMBERSHIP_MEMBER, p);
            } else {
                throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no member property found in membership class " + this.membershipClass.getName());
            }
        }
        props = PropertyQueries.createQuery(this.membershipClass).addCriteria(new TypedPropertyCriteria(this.identityClass)).addCriteria(new PropertyTypeCriteria(PropertyType.GROUP)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_MEMBERSHIP_GROUP, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous group property in membership class " + this.membershipClass.getName());
            }
            p = this.findNamedProperty(this.membershipClass, "group");
            if (p != null) {
                this.modelProperties.put(PROPERTY_MEMBERSHIP_GROUP, p);
            } else {
                throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no group property found in membership class " + this.membershipClass.getName());
            }
        }
        props = PropertyQueries.createQuery(this.membershipClass).addCriteria(new TypedPropertyCriteria(this.identityClass)).addCriteria(new PropertyTypeCriteria(PropertyType.ROLE)).getResultList();
        if (props.size() == 1) {
            this.modelProperties.put(PROPERTY_MEMBERSHIP_ROLE, props.get(0));
        } else {
            if (props.size() > 1) {
                throw new SecurityConfigurationException("Ambiguous role property in membership class " + this.membershipClass.getName());
            }
            p = this.findNamedProperty(this.membershipClass, "role");
            if (p != null) {
                this.modelProperties.put(PROPERTY_MEMBERSHIP_ROLE, p);
            } else {
                throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no role property found in membership class " + this.membershipClass.getName());
            }
        }
    }

    protected void configureAttributes() throws SecurityConfigurationException {
        List props;
        if (this.attributeClass != null) {
            Property<Object> prop;
            props = PropertyQueries.createQuery(this.attributeClass).addCriteria(new PropertyTypeCriteria(PropertyType.NAME)).addCriteria(new TypedPropertyCriteria(String.class)).getResultList();
            if (props.size() == 1) {
                this.modelProperties.put(PROPERTY_ATTRIBUTE_NAME, props.get(0));
            } else {
                if (props.size() > 1) {
                    throw new SecurityConfigurationException("Ambiguous attribute name property in attribute class " + this.attributeClass.getName());
                }
                prop = this.findNamedProperty(this.attributeClass, "attributeName", "name");
                if (prop != null) {
                    this.modelProperties.put(PROPERTY_ATTRIBUTE_NAME, prop);
                } else {
                    throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no name property found in attribute class " + this.attributeClass.getName());
                }
            }
            props = PropertyQueries.createQuery(this.attributeClass).addCriteria(new PropertyTypeCriteria(PropertyType.VALUE)).getResultList();
            if (props.size() == 1) {
                this.modelProperties.put(PROPERTY_ATTRIBUTE_VALUE, props.get(0));
            } else {
                if (props.size() > 1) {
                    throw new SecurityConfigurationException("Ambiguous attribute value property in class " + this.attributeClass.getName());
                }
                prop = this.findNamedProperty(this.attributeClass, "attributeValue", "value");
                if (prop != null) {
                    this.modelProperties.put(PROPERTY_ATTRIBUTE_VALUE, prop);
                } else {
                    throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no value property found in attribute class " + this.attributeClass.getName());
                }
            }
            props = PropertyQueries.createQuery(this.attributeClass).addCriteria(new TypedPropertyCriteria(this.identityClass)).getResultList();
            if (props.size() != 1) {
                if (props.size() > 1) {
                    throw new SecurityConfigurationException("Ambiguous identity property in attribute class " + this.attributeClass.getName());
                }
                throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no attribute identity property found.");
            }
            this.modelProperties.put(PROPERTY_ATTRIBUTE_IDENTITY, props.get(0));
            props = PropertyQueries.createQuery(this.attributeClass).addCriteria(new PropertyTypeCriteria(PropertyType.ATTRIBUTE_TYPE)).getResultList();
            if (props.size() == 1) {
                this.modelProperties.put(PROPERTY_ATTRIBUTE_TYPE, props.get(0));
            } else {
                if (props.size() > 1) {
                    throw new SecurityConfigurationException("Ambiguous attribute type property in class " + this.attributeClass.getName());
                }
                prop = this.findNamedProperty(this.attributeClass, "attributeType", "type");
                if (prop != null) {
                    this.modelProperties.put(PROPERTY_ATTRIBUTE_TYPE, prop);
                } else {
                    throw new SecurityConfigurationException("Error initializing JPAIdentityStore - no attribute type property found in attribute class " + this.attributeClass.getName());
                }
            }
        }
        props = PropertyQueries.createQuery(this.identityClass).addCriteria(new AnnotatedPropertyCriteria(IDMAttribute.class)).getResultList();
        for (Property<Object> property : props) {
            String attribName = property.getAnnotatedElement().getAnnotation(IDMAttribute.class).name();
            if (this.attributeProperties.containsKey(attribName)) {
                Property<Object> other = this.attributeProperties.get(attribName).getAttributeProperty();
                throw new SecurityConfigurationException("Multiple properties defined for attribute [" + attribName + "] - " + "Property: " + other.getDeclaringClass().getName() + "." + other.getAnnotatedElement().toString() + ", Property: " + property.getDeclaringClass().getName() + "." + property.getAnnotatedElement().toString());
            }
            this.attributeProperties.put(attribName, new MappedAttribute(null, property));
        }
    }

    public String getIdentityTypeUser() {
        return this.identityTypeUser;
    }

    public void setIdentityTypeUser(String identityTypeUser) {
        this.identityTypeUser = identityTypeUser;
    }

    public String getIdentityTypeGroup() {
        return this.identityTypeGroup;
    }

    public void setIdentityTypeGroup(String identityTypeGroup) {
        this.identityTypeGroup = identityTypeGroup;
    }

    public String getIdentityTypeRole() {
        return this.identityTypeRole;
    }

    public void setIdentityTypeRole(String identityTypeRole) {
        this.identityTypeRole = identityTypeRole;
    }

    public String getIdentityTypeAgent() {
        return this.identityTypeAgent;
    }

    public String getIdentityTypeRelationship() {
        return this.identityTypeRelationship;
    }

    public void setIdentityTypeAgent(String identityTypeAgent) {
        this.identityTypeAgent = identityTypeAgent;
    }

    protected String getIdentityTypeDiscriminator(Class<? extends IdentityType> identityType) {
        String discriminator = null;
        if (User.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeUser();
        } else if (Agent.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeAgent();
        } else if (Role.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeRole();
        } else if (Group.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeGroup();
        } else if (Agent.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeAgent();
        } else if (Relationship.class.isAssignableFrom(identityType)) {
            discriminator = this.getIdentityTypeRelationship();
        } else {
            throw new IdentityManagementException("No discriminator could be determined for type [" + identityType.getClass() + "]");
        }
        return discriminator;
    }

    public Map<String, IdentityTypeHandler<? extends IdentityType>> getIdentityTypeStores() {
        return this.identityTypeStores;
    }

    IdentityTypeHandler<IdentityType> getIdentityTypeManager(Class<? extends IdentityType> identityTypeClass) {
        IdentityTypeHandler<IdentityType> identityTypeManager = this.getIdentityTypeStores().get(this.getIdentityDiscriminator(identityTypeClass));
        return identityTypeManager;
    }

    IdentityTypeHandler<IdentityType> getIdentityTypeManager(String discriminator) {
        return this.getIdentityTypeStores().get(discriminator);
    }

    String getIdentityDiscriminator(Class<? extends IdentityType> identityType) {
        return this.getIdentityTypeDiscriminator(identityType);
    }

    public Property<Object> getIdentityIdProperty() {
        return this.getModelProperty(PROPERTY_IDENTITY_ID);
    }

    public Property<Object> getIdentityNameProperty() {
        return this.getModelProperty(PROPERTY_IDENTITY_NAME);
    }

    public Property<Object> getAttributeIdentityProperty() {
        return this.getModelProperty(PROPERTY_ATTRIBUTE_IDENTITY);
    }

    public Property<Object> getAttributeNameProperty() {
        return this.getModelProperty(PROPERTY_ATTRIBUTE_NAME);
    }

    public Property<Object> getAttributeValueProperty() {
        return this.getModelProperty(PROPERTY_ATTRIBUTE_VALUE);
    }

    public Property<Object> getDiscriminatorProperty() {
        return this.getModelProperty(PROPERTY_IDENTITY_DISCRIMINATOR);
    }

    public class MappedAttribute {
        private Property<Object> identityProperty;
        private Property<Object> attributeProperty;

        public MappedAttribute(Property<Object> identityProperty, Property<Object> attributeProperty) {
            this.identityProperty = identityProperty;
            this.attributeProperty = attributeProperty;
        }

        public Property<Object> getIdentityProperty() {
            return this.identityProperty;
        }

        public Property<Object> getAttributeProperty() {
            return this.attributeProperty;
        }
    }

    public class PropertyTypeCriteria
    implements PropertyCriteria {
        private PropertyType pt;

        public PropertyTypeCriteria(PropertyType pt) {
            this.pt = pt;
        }

        @Override
        public boolean fieldMatches(Field f) {
            return f.isAnnotationPresent(IDMProperty.class) && f.getAnnotation(IDMProperty.class).value().equals((Object)this.pt);
        }

        @Override
        public boolean methodMatches(Method m) {
            return m.isAnnotationPresent(IDMProperty.class) && m.getAnnotation(IDMProperty.class).value().equals((Object)this.pt);
        }
    }
}

