/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.event.GroupCreatedEvent;
import org.picketlink.idm.event.GroupDeletedEvent;
import org.picketlink.idm.event.GroupUpdatedEvent;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.query.QueryParameter;

public class GroupHandler
extends IdentityTypeHandler<Group> {
    @Override
    protected void doPopulateIdentityInstance(Object toIdentity, Group fromGroup, JPAIdentityStore store) {
        store.setModelProperty(toIdentity, "IDENTITY_NAME", fromGroup.getName(), true);
        if (fromGroup.getParentGroup() != null) {
            Object parentIdentity = store.lookupIdentityObjectById((IdentityType)fromGroup.getParentGroup());
            if (parentIdentity == null) {
                store.add((IdentityType)fromGroup.getParentGroup());
                parentIdentity = store.lookupIdentityObjectById((IdentityType)fromGroup.getParentGroup());
            }
            store.setModelProperty(toIdentity, "PARENT_GROUP", parentIdentity, true);
        }
    }

    @Override
    void remove(Object identity, Group identityType, JPAIdentityStore store) {
        this.disassociateChilds(identityType, store);
    }

    @Override
    protected AbstractBaseEvent raiseCreatedEvent(Group fromIdentityType, JPAIdentityStore store) {
        return new GroupCreatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseUpdatedEvent(Group fromIdentityType, JPAIdentityStore store) {
        return new GroupUpdatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseDeletedEvent(Group fromIdentityType, JPAIdentityStore store) {
        return new GroupDeletedEvent(fromIdentityType);
    }

    private void disassociateChilds(Group group, JPAIdentityStore store) {
        EntityManager em = store.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(store.getConfig().getIdentityClass());
        Root root = criteria.from(store.getConfig().getIdentityClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Join join = root.join(store.getConfig().getModelProperty("PARENT_GROUP").getName());
        predicates.add(builder.equal((Expression)join.get(store.getConfig().getModelProperty("IDENTITY_NAME").getName()), (Object)group.getName()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List resultList = em.createQuery(criteria).getResultList();
        for (Object object : resultList) {
            store.getConfig().getModelProperty("PARENT_GROUP").setValue(object, null);
            em.merge(object);
        }
    }

    @Override
    protected Group doCreateIdentityType(Object identity, JPAIdentityStore store) {
        String name = store.getModelProperty(String.class, identity, "IDENTITY_NAME");
        Object parentInstance = store.getModelProperty(Object.class, identity, "PARENT_GROUP");
        SimpleGroup group = null;
        if (parentInstance != null) {
            String parentId = store.getModelProperty(String.class, parentInstance, "IDENTITY_NAME");
            Group parent = store.getGroup(parentId);
            group = new SimpleGroup(name, parent);
        } else {
            group = new SimpleGroup(name);
        }
        return group;
    }

    @Override
    public List<Predicate> getPredicate(QueryParameter queryParameter, Object[] parameterValues, JPACriteriaQueryBuilder criteria, JPAIdentityStore store) {
        List<Predicate> predicates = super.getPredicate(queryParameter, parameterValues, criteria, store);
        CriteriaBuilder builder = criteria.getBuilder();
        if (queryParameter.equals(Group.NAME)) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(store.getConfig().getModelProperty("IDENTITY_NAME").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(Group.PARENT)) {
            Join join = criteria.getRoot().join(store.getConfig().getModelProperty("PARENT_GROUP").getName());
            predicates.add(builder.equal((Expression)join.get(store.getConfig().getModelProperty("IDENTITY_NAME").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(IdentityType.HAS_MEMBER)) {
            for (Object object : parameterValues) {
                Property<Object> memberModelProperty = store.getConfig().getModelProperty("MEMBERSHIP_MEMBER");
                Property<Object> groupModelProperty = store.getConfig().getModelProperty("MEMBERSHIP_GROUP");
                Subquery subquery = criteria.getCriteria().subquery(store.getConfig().getMembershipClass());
                Root fromProject = subquery.from(store.getConfig().getMembershipClass());
                Subquery select = subquery.select((Expression)fromProject.get(groupModelProperty.getName()));
                Predicate conjunction = criteria.getBuilder().conjunction();
                conjunction.getExpressions().add(criteria.getBuilder().equal((Expression)fromProject.get(groupModelProperty.getName()), criteria.getRoot()));
                conjunction.getExpressions().add(criteria.getBuilder().equal((Expression)fromProject.get(memberModelProperty.getName()), store.lookupIdentityObjectById((IdentityType)object)));
                subquery.where((Expression)conjunction);
                predicates.add((Predicate)criteria.getBuilder().in(criteria.getRoot()).value((Expression)subquery));
            }
        }
        return predicates;
    }
}

