/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal.util;

import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;

public class IDMUtil {
    public static boolean isGroupType(Class<? extends IdentityType> identityType) {
        return Group.class.isAssignableFrom(identityType);
    }

    public static boolean isRoleType(Class<? extends IdentityType> identityType) {
        return Role.class.isAssignableFrom(identityType);
    }

    public static boolean isUserType(Class<? extends IdentityType> identityType) {
        return User.class.isAssignableFrom(identityType);
    }

    public static boolean isAgentType(Class<? extends IdentityType> identityType) {
        return Agent.class.isAssignableFrom(identityType);
    }

    public static boolean isRelationshipType(Class<? extends IdentityType> identityType) {
        return Relationship.class.isAssignableFrom(identityType);
    }

    public static boolean arraysEqual(String[] arr1, String[] arr2) {
        if (arr1 != null && arr2 == null) {
            return false;
        }
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 == null && arr2 != null) {
            return false;
        }
        int length1 = arr1.length;
        int length2 = arr2.length;
        if (length1 != length2) {
            return false;
        }
        boolean foundMatch = false;
        for (int i = 0; i < length1; ++i) {
            for (int j = 0; j < length2; ++j) {
                if (!arr1[i].equals(arr2[j])) continue;
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                return false;
            }
            foundMatch = false;
        }
        return true;
    }
}

