/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.PartitionStoreConfiguration;
import org.picketlink.idm.config.StoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.internal.DefaultStoreFactory;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.IdentityStoreInvocationContextFactory;
import org.picketlink.idm.spi.StoreFactory;

public class DefaultIdentityManager
implements IdentityManager {
    private static final long serialVersionUID = -2835518073812662628L;
    private Map<String, Map<IdentityStore.Feature, IdentityStoreConfiguration>> realmStores = new HashMap<String, Map<IdentityStore.Feature, IdentityStoreConfiguration>>();
    private PartitionStoreConfiguration partitionStoreConfig;
    private StoreFactory storeFactory = new DefaultStoreFactory();
    private IdentityStoreInvocationContextFactory contextFactory;
    private static Method METHOD_CREATE_CONTEXT;

    public DefaultIdentityManager() {
        try {
            METHOD_CREATE_CONTEXT = DefaultIdentityManager.class.getDeclaredMethod("createContext", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating DefaultIdentityManager - createContext() method not available", e);
        }
    }

    public IdentityManager forRealm(final Realm realm) {
        final DefaultIdentityManager proxied = this;
        return (IdentityManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IdentityManager.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.equals(METHOD_CREATE_CONTEXT)) {
                    IdentityStoreInvocationContext ctx = proxied.createContext();
                    ctx.setRealm(realm);
                    return ctx;
                }
                return method.invoke((Object)proxied, args);
            }
        });
    }

    public IdentityManager forTier(final Tier tier) {
        final DefaultIdentityManager proxied = this;
        return (IdentityManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IdentityManager.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.equals(METHOD_CREATE_CONTEXT)) {
                    IdentityStoreInvocationContext ctx = proxied.createContext();
                    ctx.setTier(tier);
                    return ctx;
                }
                return method.invoke((Object)proxied, args);
            }
        });
    }

    public void bootstrap(IdentityConfiguration identityConfig, IdentityStoreInvocationContextFactory contextFactory) {
        if (identityConfig == null) {
            throw new IllegalArgumentException("identityConfig is null");
        }
        if (contextFactory == null) {
            throw new IllegalArgumentException("contextFactory is null");
        }
        for (StoreConfiguration config : identityConfig.getConfiguredStores()) {
            config.init();
            if (IdentityStoreConfiguration.class.isInstance(config)) {
                Map<Object, Object> featureToStoreMap;
                IdentityStoreConfiguration identityStoreConfig = (IdentityStoreConfiguration)config;
                if (identityStoreConfig.getFeatureSet() == null) {
                    throw new SecurityConfigurationException("A feature set has not been configured for IdentityStoreConfiguration: " + config);
                }
                String realm = identityStoreConfig.getRealm();
                if (realm == null || realm.isEmpty()) {
                    realm = "default";
                }
                if (this.realmStores.containsKey(realm)) {
                    featureToStoreMap = this.realmStores.get(realm);
                } else {
                    featureToStoreMap = new HashMap();
                    this.realmStores.put(realm, featureToStoreMap);
                }
                for (IdentityStore.Feature f : identityStoreConfig.getFeatureSet()) {
                    featureToStoreMap.put(f, identityStoreConfig);
                }
                continue;
            }
            if (!PartitionStoreConfiguration.class.isInstance(config)) continue;
            this.partitionStoreConfig = (PartitionStoreConfiguration)config;
        }
        this.contextFactory = contextFactory;
    }

    public void setIdentityStoreFactory(StoreFactory factory) {
        this.storeFactory = factory;
    }

    private IdentityStore<?> getContextualStoreForFeature(IdentityStoreInvocationContext ctx, IdentityStore.Feature feature) {
        String realm;
        String string = realm = ctx.getRealm() != null ? ctx.getRealm().getName() : "default";
        if (!this.realmStores.containsKey(realm)) {
            throw new SecurityException("The specified realm '" + realm + "' has not been configured.");
        }
        IdentityStoreConfiguration config = null;
        Map<IdentityStore.Feature, IdentityStoreConfiguration> featureToStoreMap = this.realmStores.get(realm);
        if (featureToStoreMap.containsKey(feature)) {
            config = featureToStoreMap.get(feature);
        } else if (featureToStoreMap.containsKey(IdentityStore.Feature.all)) {
            config = featureToStoreMap.get(IdentityStore.Feature.all);
        } else {
            throw new UnsupportedOperationException("The requested identity management feature [" + feature.toString() + "] has not been configured.");
        }
        IdentityStore store = this.storeFactory.createIdentityStore(config, ctx);
        this.getContextFactory().initContextForStore(ctx, store);
        return store;
    }

    private IdentityStoreInvocationContext createContext() {
        return this.getContextFactory().createContext();
    }

    public void add(IdentityType identityType) {
        IdentityStore.Feature feature;
        IdentityStoreInvocationContext ctx = this.createContext();
        if (User.class.isInstance(identityType)) {
            feature = IdentityStore.Feature.createUser;
        } else if (Group.class.isInstance(identityType)) {
            if (ctx.getRealm() != null && ctx.getTier() != null) {
                throw new IllegalStateException("Ambiguous context state - Group may only be managed in either the scope of a Realm or a Tier, however both have been set.");
            }
            feature = IdentityStore.Feature.createGroup;
        } else if (Role.class.isInstance(identityType)) {
            if (ctx.getRealm() != null && ctx.getTier() != null) {
                throw new IllegalStateException("Ambiguous context state - Role may only be managed in either the scope of a Realm or a Tier, however both have been set.");
            }
            feature = IdentityStore.Feature.createRole;
        } else if (Agent.class.isInstance(identityType)) {
            feature = IdentityStore.Feature.createAgent;
        } else if (Relationship.class.isInstance(identityType)) {
            feature = IdentityStore.Feature.createAgent;
        } else {
            throw new IllegalArgumentException("Unsupported IdentityType:" + identityType.getClass().getName());
        }
        this.getContextualStoreForFeature(ctx, feature).add(identityType);
    }

    public void update(IdentityType identityType) {
        IdentityStore.Feature feature;
        IdentityStoreInvocationContext ctx = this.createContext();
        if (User.class.isInstance(identityType)) {
            feature = IdentityStore.Feature.updateUser;
        } else if (Agent.class.isInstance(identityType)) {
            feature = IdentityStore.Feature.updateAgent;
        } else if (Group.class.isInstance(identityType)) {
            if (ctx.getRealm() != null && ctx.getTier() != null) {
                throw new IllegalStateException("Ambiguous context state - Group may only be managed in either the scope of a Realm or a Tier, however both have been set.");
            }
            feature = IdentityStore.Feature.updateGroup;
        } else if (Role.class.isInstance(identityType)) {
            if (ctx.getRealm() != null && ctx.getTier() != null) {
                throw new IllegalStateException("Ambiguous context state - Role may only be managed in either the scope of a Realm or a Tier, however both have been set.");
            }
            feature = IdentityStore.Feature.updateRole;
        } else {
            throw new IllegalArgumentException("Unsupported IdentityType");
        }
        this.getContextualStoreForFeature(this.createContext(), feature).update(identityType);
    }

    public void remove(IdentityType identityType) {
        IdentityStore.Feature feature;
        IdentityStoreInvocationContext ctx = this.createContext();
        if (User.class.isInstance(identityType)) {
            feature = IdentityStore.Feature.deleteUser;
        } else if (Agent.class.isInstance(identityType)) {
            feature = IdentityStore.Feature.deleteAgent;
        } else if (Group.class.isInstance(identityType)) {
            if (ctx.getRealm() != null && ctx.getTier() != null) {
                throw new IllegalStateException("Ambiguous context state - Group may only be managed in either the scope of a Realm or a Tier, however both have been set.");
            }
            feature = IdentityStore.Feature.deleteGroup;
        } else if (Role.class.isInstance(identityType)) {
            if (ctx.getRealm() != null && ctx.getTier() != null) {
                throw new IllegalStateException("Ambiguous context state - Role may only be managed in either the scope of a Realm or a Tier, however both have been set.");
            }
            feature = IdentityStore.Feature.deleteRole;
        } else {
            throw new IllegalArgumentException("Unsupported IdentityType");
        }
        this.getContextualStoreForFeature(ctx, feature).remove(identityType);
    }

    public Agent getAgent(String id) {
        return this.getContextualStoreForFeature(this.createContext(), IdentityStore.Feature.readAgent).getAgent(id);
    }

    public User getUser(String id) {
        return this.getContextualStoreForFeature(this.createContext(), IdentityStore.Feature.readUser).getUser(id);
    }

    public Group getGroup(String groupId) {
        IdentityStoreInvocationContext ctx = this.createContext();
        if (ctx.getRealm() != null && ctx.getTier() != null) {
            throw new IllegalStateException("Ambiguous context state - Group may only be managed in either the scope of a Realm or a Tier, however both have been set.");
        }
        return this.getContextualStoreForFeature(ctx, IdentityStore.Feature.readGroup).getGroup(groupId);
    }

    public Group getGroup(String groupName, Group parent) {
        IdentityStoreInvocationContext ctx = this.createContext();
        if (ctx.getRealm() != null && ctx.getTier() != null) {
            throw new IllegalStateException("Ambiguous context state - Group may only be managed in either the scope of a Realm or a Tier, however both have been set.");
        }
        return this.getContextualStoreForFeature(ctx, IdentityStore.Feature.readGroup).getGroup(groupName, parent);
    }

    public boolean isMember(IdentityType identityType, Group group) {
        return this.getContextualStoreForFeature(this.createContext(), IdentityStore.Feature.readMembership).getMembership(identityType, group, null) != null;
    }

    public void addToGroup(IdentityType identityType, Group group) {
        this.getContextualStoreForFeature(this.createContext(), IdentityStore.Feature.createMembership).createMembership(identityType, group, null);
    }

    public void removeFromGroup(IdentityType identityType, Group group) {
        this.getContextualStoreForFeature(this.createContext(), IdentityStore.Feature.deleteMembership).removeMembership(identityType, group, null);
    }

    public Role getRole(String name) {
        IdentityStoreInvocationContext ctx = this.createContext();
        if (ctx.getRealm() != null && ctx.getTier() != null) {
            throw new IllegalStateException("Ambiguous context state - Role may only be managed in either the scope of a Realm or a Tier, however both have been set.");
        }
        return this.getContextualStoreForFeature(ctx, IdentityStore.Feature.readRole).getRole(name);
    }

    public boolean hasGroupRole(IdentityType identityType, Role role, Group group) {
        return this.getContextualStoreForFeature(this.createContext(), IdentityStore.Feature.readMembership).getMembership(identityType, group, role) != null;
    }

    public void grantGroupRole(IdentityType identityType, Role role, Group group) {
        this.getContextualStoreForFeature(this.createContext(), IdentityStore.Feature.createMembership).createMembership(identityType, group, role);
    }

    public void revokeGroupRole(IdentityType identityType, Role role, Group group) {
        this.getContextualStoreForFeature(this.createContext(), IdentityStore.Feature.createMembership).removeMembership(identityType, group, role);
    }

    public boolean hasRole(IdentityType identityType, Role role) {
        return this.getContextualStoreForFeature(this.createContext(), IdentityStore.Feature.readMembership).getMembership(identityType, null, role) != null;
    }

    public void grantRole(IdentityType identityType, Role role) {
        this.getContextualStoreForFeature(this.createContext(), IdentityStore.Feature.createMembership).createMembership(identityType, null, role);
    }

    public void revokeRole(IdentityType identityType, Role role) {
        this.getContextualStoreForFeature(this.createContext(), IdentityStore.Feature.deleteMembership).removeMembership(identityType, null, role);
    }

    public void validateCredentials(Credentials credentials) {
        IdentityStore<?> store = this.getContextualStoreForFeature(this.createContext(), IdentityStore.Feature.manageCredentials);
        store.validateCredentials(credentials);
    }

    public void updateCredential(Agent agent, Object value) {
        this.updateCredential(agent, value, new Date(), null);
    }

    public void updateCredential(Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        IdentityStore<?> store = this.getContextualStoreForFeature(this.createContext(), IdentityStore.Feature.manageCredentials);
        store.updateCredential(agent, credential, effectiveDate, expiryDate);
    }

    public IdentityStoreInvocationContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public IdentityType lookupIdentityByKey(String key) {
        return null;
    }

    public <T extends IdentityType> IdentityQuery<T> createQuery(Class<T> identityType) {
        return new DefaultIdentityQuery<T>(identityType, this.getContextualStoreForFeature(this.createContext(), IdentityStore.Feature.readUser));
    }

    public void createRealm(Realm realm) {
        this.storeFactory.createPartitionStore(this.partitionStoreConfig).createPartition((Partition)realm);
    }

    public void removeRealm(Realm realm) {
        this.storeFactory.createPartitionStore(this.partitionStoreConfig).removePartition((Partition)realm);
    }

    public Realm getRealm(String name) {
        return this.storeFactory.createPartitionStore(this.partitionStoreConfig).getRealm(name);
    }

    public void createTier(Tier tier) {
        this.storeFactory.createPartitionStore(this.partitionStoreConfig).createPartition((Partition)tier);
    }

    public void removeTier(Tier tier) {
        this.storeFactory.createPartitionStore(this.partitionStoreConfig).removePartition((Partition)tier);
    }

    public Tier getTier(String id) {
        return this.storeFactory.createPartitionStore(this.partitionStoreConfig).getTier(id);
    }

    public void loadAttribute(IdentityType identityType, String attributeName) {
    }
}

