/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.X509Cert;
import org.picketlink.idm.credential.X509CertificateCredentials;
import org.picketlink.idm.credential.internal.X509CertificateStorage;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.internal.util.Base64;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;

@SupportsCredentials(value={X509CertificateCredentials.class, X509Cert.class})
public class X509CertificateCredentialHandler
implements CredentialHandler {
    public void validate(Credentials credentials, IdentityStore<?> identityStore) {
        CredentialStore store;
        X509CertificateStorage storage;
        if (!CredentialStore.class.isInstance(identityStore)) {
            throw new IdentityManagementException("Provided IdentityStore [" + identityStore + "] is not an instance of CredentialStore.");
        }
        if (!X509CertificateCredentials.class.isInstance(credentials)) {
            throw new IllegalArgumentException("Credentials class [" + credentials.getClass().getName() + "] not supported by this handler.");
        }
        X509CertificateCredentials certCredentials = (X509CertificateCredentials)credentials;
        Agent agent = identityStore.getAgent(certCredentials.getUsername());
        certCredentials.setStatus(Credentials.Status.INVALID);
        if (agent != null && (storage = (X509CertificateStorage)(store = (CredentialStore)identityStore).retrieveCurrentCredential(agent, X509CertificateStorage.class)) != null) {
            String base64Cert = storage.getBase64Cert();
            byte[] certBytes = Base64.decode(base64Cert);
            try {
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                X509Certificate storedCert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certBytes));
                X509Cert providedCert = certCredentials.getCertificate();
                if (storedCert.equals(providedCert.getValue())) {
                    certCredentials.setStatus(Credentials.Status.VALID);
                }
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error while checking user's certificate.", (Throwable)e);
            }
        }
    }

    public void update(Agent agent, Object credential, IdentityStore<?> identityStore, Date effectiveDate, Date expiryDate) {
        if (!CredentialStore.class.isInstance(identityStore)) {
            throw new IdentityManagementException("Provided IdentityStore [" + identityStore + "] is not an instance of CredentialStore.");
        }
        if (!X509Cert.class.isInstance(credential)) {
            throw new IllegalArgumentException("Credential class [" + credential.getClass().getName() + "] not supported by this handler.");
        }
        X509Cert certificate = (X509Cert)credential;
        X509CertificateStorage storage = new X509CertificateStorage(certificate);
        CredentialStore store = (CredentialStore)identityStore;
        store.storeCredential(agent, (CredentialStorage)storage);
    }
}

