/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.sandbox;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.ResourceType;
import org.picketbox.config.PicketBoxConfiguration;
import org.picketbox.factories.SecurityFactory;

public class PBSandbox {
    private static String securityDomainName = "test";

    public static void main(String[] args) throws Exception {
        PBSandbox.testAuthentication();
        PBSandbox.testAuthorization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testAuthentication() {
        SecurityFactory.prepare();
        try {
            String credential;
            String configFile = "config/authentication.conf";
            PicketBoxConfiguration idtrustConfig = new PicketBoxConfiguration();
            idtrustConfig.load(configFile);
            AuthenticationManager am = SecurityFactory.getAuthenticationManager(securityDomainName);
            if (am == null) {
                throw new RuntimeException("PB00015: Null Value:Authentication Manager is null");
            }
            Subject subject = new Subject();
            Principal principal = PBSandbox.getPrincipal("anil");
            boolean result = am.isValid(principal, (Object)(credential = new String("pass")));
            if (!result) {
                throw new RuntimeException("PB00024: Access Denied:Authentication Failed");
            }
            result = am.isValid(principal, (Object)credential, subject);
            if (!result) {
                throw new RuntimeException("PB00024: Access Denied:Authentication Failed");
            }
            if (subject.getPrincipals().size() < 1) {
                throw new RuntimeException("Subject has zero principals");
            }
            System.out.println("Authentication Successful");
        }
        finally {
            SecurityFactory.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testAuthorization() throws Exception {
        SecurityFactory.prepare();
        try {
            String credential;
            String configFile = "config/authorization.conf";
            PicketBoxConfiguration idtrustConfig = new PicketBoxConfiguration();
            idtrustConfig.load(configFile);
            AuthenticationManager am = SecurityFactory.getAuthenticationManager(securityDomainName);
            if (am == null) {
                throw new RuntimeException("PB00024: Access Denied:Authentication Manager is null");
            }
            Subject subject = new Subject();
            Principal principal = PBSandbox.getPrincipal("anil");
            boolean result = am.isValid(principal, (Object)(credential = new String("pass")), subject);
            if (!result) {
                throw new RuntimeException("PB00024: Access Denied:InValid Auth");
            }
            if (subject.getPrincipals().size() < 1) {
                throw new RuntimeException("PB00017: Mismatch in size:Subject has zero principals");
            }
            AuthorizationManager authzM = SecurityFactory.getAuthorizationManager(securityDomainName);
            if (authzM == null) {
                throw new RuntimeException("PB00015: Null Value:Authorization Manager is null");
            }
            Resource resource = PBSandbox.getResource();
            int decision = authzM.authorize(resource, subject);
            if (decision != 1) {
                throw new RuntimeException("PB00024: Access Denied:Authz is not permit");
            }
            System.out.println("Authorization successful");
        }
        finally {
            SecurityFactory.release();
        }
    }

    private static Principal getPrincipal(final String name) {
        return new Principal(){

            public String getName() {
                return name;
            }
        };
    }

    private static Resource getResource() {
        return new Resource(){
            HashMap<String, Object> contextMap = new HashMap();

            public ResourceType getLayer() {
                return ResourceType.POJO;
            }

            public Map<String, Object> getMap() {
                return this.contextMap;
            }

            public void add(String key, Object value) {
                this.contextMap.put(key, value);
            }
        };
    }
}

