/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import jakarta.xml.bind.JAXBElement;
import java.util.List;
import org.jvnet.basicjaxb.lang.DefaultHashCodeStrategy;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.locator.PropertyObjectLocator;
import org.jvnet.basicjaxb.locator.RootObjectLocator;
import org.jvnet.basicjaxb.locator.util.LocatorUtils;

public class JAXBHashCodeStrategy
extends DefaultHashCodeStrategy {
    private static JAXBHashCodeStrategy INSTANCE = new JAXBHashCodeStrategy();

    public static JAXBHashCodeStrategy getInstance() {
        return INSTANCE;
    }

    public JAXBHashCodeStrategy() {
    }

    public JAXBHashCodeStrategy(int multiplierNonZeroOddNumber) {
        super(multiplierNonZeroOddNumber);
    }

    @Override
    protected int observe(String label, ObjectLocator locator, int hash) {
        if (this.isTraceEnabled()) {
            this.trace(this.buildMessage(label, locator, Integer.toHexString(hash)));
        } else if (this.isDebugEnabled() && locator != null) {
            RootObjectLocator rootObjectLocator;
            PropertyObjectLocator parentPropertyLocator;
            if (locator instanceof RootObjectLocator) {
                this.debug(this.buildMessage(label, locator, Integer.toHexString(hash)));
            } else if (locator.getParentLocator() instanceof RootObjectLocator) {
                RootObjectLocator rootObjectLocator2 = (RootObjectLocator)locator.getParentLocator();
                if (rootObjectLocator2.getObject() instanceof JAXBElement) {
                    PropertyObjectLocator propertyLocator;
                    if (locator instanceof PropertyObjectLocator && "value".equals((propertyLocator = (PropertyObjectLocator)locator).getPropertyName())) {
                        this.debug(this.buildMessage(label, locator, Integer.toHexString(hash)));
                    }
                } else {
                    this.debug(this.buildMessage(label, locator, Integer.toHexString(hash)));
                }
            } else if (locator.getParentLocator() instanceof PropertyObjectLocator && "value".equals((parentPropertyLocator = (PropertyObjectLocator)locator.getParentLocator()).getPropertyName()) && locator.getParentLocator().getParentLocator() instanceof RootObjectLocator && (rootObjectLocator = (RootObjectLocator)locator.getParentLocator().getParentLocator()).getObject() instanceof JAXBElement) {
                this.debug(this.buildMessage(label, locator, Integer.toHexString(hash)));
            }
        }
        return hash;
    }

    @Override
    protected int hashCodeInternal(ObjectLocator locator, int hashCode, Object value) {
        if (value instanceof JAXBElement) {
            JAXBElement element = (JAXBElement)value;
            return this.hashCodeInternal(locator, hashCode, element);
        }
        if (value instanceof List) {
            List list = (List)value;
            return this.hashCodeInternal(locator, hashCode, list);
        }
        return super.hashCodeInternal(locator, hashCode, value);
    }

    protected int hashCodeInternal(ObjectLocator locator, int hashCode, JAXBElement<?> element) {
        int currentHashCode = hashCode;
        currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.property(locator, "name", element.getName()), currentHashCode, element.getName());
        currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.property(locator, "declaredType", element.getDeclaredType()), currentHashCode, element.getDeclaredType());
        currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.property(locator, "scope", element.getScope()), currentHashCode, element.getScope());
        currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.property(locator, "value", element.getValue()), currentHashCode, element.getValue());
        return this.observe(locator, currentHashCode);
    }

    protected int hashCodeInternal(ObjectLocator locator, int hashCode, List<?> list) {
        if (list.isEmpty()) {
            return super.hashCode(locator, hashCode, (Object)null);
        }
        int currentHashCode = hashCode;
        for (int index = 0; index < list.size(); ++index) {
            Object item = list.get(index);
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, index, item), currentHashCode, item);
        }
        return this.observe(locator, currentHashCode);
    }
}

