/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import java.util.Collection;
import org.jvnet.basicjaxb.lang.ClassUtils;
import org.jvnet.basicjaxb.lang.ToString;
import org.jvnet.basicjaxb.lang.ToStringStrategy;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.locator.util.LocatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultToStringStrategy
implements ToStringStrategy {
    private static final DefaultToStringStrategy INSTANCE = new DefaultToStringStrategy();
    private Logger logger = LoggerFactory.getLogger(ToStringStrategy.class);
    private boolean fullDetail = false;
    private boolean useFieldNames = false;
    private boolean useShortClassName = true;
    private boolean useClassName = true;
    private boolean useIdentityHashCode = true;
    private boolean useDefaultFieldValueMarkers = false;
    private String contentStart = "[";
    private String contentEnd = "]";
    private String fieldNameValueSeparator = "=";
    private String defaultFieldValueMarker = "(default)";
    private boolean fieldSeparatorAtStart = false;
    private boolean fieldSeparatorAtEnd = false;
    private String fieldSeparator = ", ";
    private String arrayStart = "{";
    private String arraySeparator = ",";
    private String arrayEnd = "}";
    private String nullText = "<null>";
    private String sizeStartText = "<size=";
    private String sizeEndText = ">";

    public static DefaultToStringStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    public boolean isFullDetail() {
        return this.isDebugEnabled() || this.isTraceEnabled() || this.fullDetail;
    }

    public void setFullDetail(boolean fullDetail) {
        this.fullDetail = fullDetail;
    }

    public boolean isUseFieldNames() {
        return this.isTraceEnabled() || this.useFieldNames;
    }

    public void setUseFieldNames(boolean useFieldNames) {
        this.useFieldNames = useFieldNames;
    }

    public boolean isUseShortClassName() {
        return this.useShortClassName && !this.isTraceEnabled();
    }

    public void setUseShortClassName(boolean useShortClassName) {
        this.useShortClassName = useShortClassName;
    }

    public boolean isUseClassName() {
        return this.useClassName;
    }

    public void setUseClassName(boolean useClassName) {
        this.useClassName = useClassName;
    }

    public boolean isUseIdentityHashCode() {
        return this.useIdentityHashCode;
    }

    public void setUseIdentityHashCode(boolean useIdentityHashCode) {
        this.useIdentityHashCode = useIdentityHashCode;
    }

    public boolean isUseDefaultFieldValueMarkers() {
        return this.useDefaultFieldValueMarkers || this.isDebugEnabled();
    }

    public void setUseDefaultFieldValueMarkers(boolean useDefaultFieldValueMarkers) {
        this.useDefaultFieldValueMarkers = useDefaultFieldValueMarkers;
    }

    protected String getShortClassName(Class cls) {
        return ClassUtils.getShortClassName(cls);
    }

    protected void appendClassName(StringBuilder buffer, Object object) {
        if (this.isUseClassName() && object != null) {
            if (this.isUseShortClassName()) {
                buffer.append(this.getShortClassName(object.getClass()));
            } else {
                buffer.append(object.getClass().getName());
            }
        }
    }

    protected void appendIdentityHashCode(StringBuilder buffer, Object object) {
        if (this.isUseIdentityHashCode() && object != null) {
            buffer.append('@');
            buffer.append(Integer.toHexString(System.identityHashCode(object)));
        }
    }

    protected void appendContentStart(StringBuilder buffer) {
        buffer.append(this.contentStart);
    }

    protected void appendContentEnd(StringBuilder buffer) {
        buffer.append(this.contentEnd);
    }

    protected void appendArrayStart(StringBuilder buffer) {
        buffer.append(this.arrayStart);
    }

    protected void appendArrayEnd(StringBuilder buffer) {
        buffer.append(this.arrayEnd);
    }

    protected void appendArraySeparator(StringBuilder buffer) {
        buffer.append(this.arraySeparator);
    }

    protected void appendNullText(StringBuilder buffer) {
        buffer.append(this.nullText);
    }

    protected void appendFieldStart(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer) {
        if (this.isUseFieldNames() && fieldName != null) {
            buffer.append(fieldName);
            buffer.append(this.fieldNameValueSeparator);
        }
    }

    protected void appendFieldStart(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, boolean valueSet) {
        if (this.isUseFieldNames() && fieldName != null) {
            buffer.append(fieldName);
            buffer.append(this.fieldNameValueSeparator);
        }
    }

    protected void appendFieldEnd(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer) {
        this.appendFieldSeparator(buffer);
    }

    protected void appendFieldEnd(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, boolean valueSet) {
        if (!valueSet && this.isUseDefaultFieldValueMarkers()) {
            this.appendDefaultFieldValueMarker(buffer);
        }
        this.appendFieldSeparator(buffer);
    }

    protected void appendFieldSeparator(StringBuilder buffer) {
        buffer.append(this.fieldSeparator);
    }

    protected void appendDefaultFieldValueMarker(StringBuilder buffer) {
        buffer.append(this.defaultFieldValueMarker);
    }

    protected void appendSummarySize(ObjectLocator locator, StringBuilder buffer, int size) {
        buffer.append(this.sizeStartText);
        buffer.append(size);
        buffer.append(this.sizeEndText);
    }

    @Override
    public StringBuilder appendStart(ObjectLocator parentLocator, Object object, StringBuilder buffer) {
        if (object != null) {
            this.appendClassName(buffer, object);
            this.appendIdentityHashCode(buffer, object);
            this.appendContentStart(buffer);
            if (this.fieldSeparatorAtStart) {
                this.appendFieldSeparator(buffer);
            }
        }
        return buffer;
    }

    @Override
    public StringBuilder appendEnd(ObjectLocator parentLocator, Object parent, StringBuilder buffer) {
        if (!this.fieldSeparatorAtEnd) {
            this.removeLastFieldSeparator(buffer);
        }
        this.appendContentEnd(buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, Object value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, boolean value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, byte value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, char value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, double value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, float value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, long value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, int value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, short value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, Object[] value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder append(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, Collection value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, boolean[] value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, byte[] value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, char[] value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, double[] value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, float[] value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, long[] value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, int[] value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder buffer, short[] value) {
        this.appendFieldStart(parentLocator, parent, fieldName, buffer);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), buffer, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, buffer);
        return buffer;
    }

    protected StringBuilder appendInternal(ObjectLocator locator, StringBuilder buffer, Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            this.append(locator, buffer, collection);
        } else if (value instanceof ToString) {
            ToString toString = (ToString)value;
            toString.append(locator, buffer, this);
        } else {
            buffer.append(value.toString());
        }
        return buffer;
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, Object value) {
        if (value == null) {
            this.appendNullText(buffer);
        } else {
            Class<?> theClass = value.getClass();
            if (!theClass.isArray()) {
                this.appendInternal(locator, buffer, value);
            } else if (value instanceof long[]) {
                this.append(locator, buffer, (long[])value);
            } else if (value instanceof int[]) {
                this.append(locator, buffer, (int[])value);
            } else if (value instanceof short[]) {
                this.append(locator, buffer, (short[])value);
            } else if (value instanceof char[]) {
                this.append(locator, buffer, (char[])value);
            } else if (value instanceof byte[]) {
                this.append(locator, buffer, (byte[])value);
            } else if (value instanceof double[]) {
                this.append(locator, buffer, (double[])value);
            } else if (value instanceof float[]) {
                this.append(locator, buffer, (float[])value);
            } else if (value instanceof boolean[]) {
                this.append(locator, buffer, (boolean[])value);
            } else {
                this.append(locator, buffer, (Object[])value);
            }
        }
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, boolean value) {
        buffer.append(value);
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, byte value) {
        buffer.append(value);
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, char value) {
        buffer.append(value);
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, double value) {
        buffer.append(value);
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, float value) {
        buffer.append(value);
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, int value) {
        buffer.append(value);
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, long value) {
        buffer.append(value);
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, short value) {
        buffer.append(value);
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, Object[] array) {
        if (array == null) {
            this.appendNullText(buffer);
        } else if (this.isFullDetail()) {
            this.appendDetail(locator, buffer, array);
        } else {
            this.appendSummary(locator, buffer, array);
        }
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, Collection array) {
        if (array == null) {
            this.appendNullText(buffer);
        } else if (this.isFullDetail()) {
            this.appendDetail(locator, buffer, array);
        } else {
            this.appendSummary(locator, buffer, array);
        }
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, boolean[] array) {
        if (array == null) {
            this.appendNullText(buffer);
        } else if (this.isFullDetail()) {
            this.appendDetail(locator, buffer, array);
        } else {
            this.appendSummary(locator, buffer, array);
        }
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, byte[] array) {
        if (array == null) {
            this.appendNullText(buffer);
        } else if (this.isFullDetail()) {
            this.appendDetail(locator, buffer, array);
        } else {
            this.appendSummary(locator, buffer, array);
        }
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, char[] array) {
        if (array == null) {
            this.appendNullText(buffer);
        } else if (this.isFullDetail()) {
            this.appendDetail(locator, buffer, array);
        } else {
            this.appendSummary(locator, buffer, array);
        }
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, double[] array) {
        if (array == null) {
            this.appendNullText(buffer);
        } else if (this.isFullDetail()) {
            this.appendDetail(locator, buffer, array);
        } else {
            this.appendSummary(locator, buffer, array);
        }
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, float[] array) {
        if (array == null) {
            this.appendNullText(buffer);
        } else if (this.isFullDetail()) {
            this.appendDetail(locator, buffer, array);
        } else {
            this.appendSummary(locator, buffer, array);
        }
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, int[] array) {
        if (array == null) {
            this.appendNullText(buffer);
        } else if (this.isFullDetail()) {
            this.appendDetail(locator, buffer, array);
        } else {
            this.appendSummary(locator, buffer, array);
        }
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, long[] array) {
        if (array == null) {
            this.appendNullText(buffer);
        } else if (this.isFullDetail()) {
            this.appendDetail(locator, buffer, array);
        } else {
            this.appendSummary(locator, buffer, array);
        }
        return buffer;
    }

    protected StringBuilder append(ObjectLocator locator, StringBuilder buffer, short[] array) {
        if (array == null) {
            this.appendNullText(buffer);
        } else if (this.isFullDetail()) {
            this.appendDetail(locator, buffer, array);
        } else {
            this.appendSummary(locator, buffer, array);
        }
        return buffer;
    }

    protected StringBuilder appendSummary(ObjectLocator locator, StringBuilder buffer, boolean[] array) {
        this.appendSummarySize(locator, buffer, array.length);
        return buffer;
    }

    protected StringBuilder appendSummary(ObjectLocator locator, StringBuilder buffer, byte[] array) {
        this.appendSummarySize(locator, buffer, array.length);
        return buffer;
    }

    protected StringBuilder appendSummary(ObjectLocator locator, StringBuilder buffer, char[] array) {
        this.appendSummarySize(locator, buffer, array.length);
        return buffer;
    }

    protected StringBuilder appendSummary(ObjectLocator locator, StringBuilder buffer, double[] array) {
        this.appendSummarySize(locator, buffer, array.length);
        return buffer;
    }

    protected StringBuilder appendSummary(ObjectLocator locator, StringBuilder buffer, float[] array) {
        this.appendSummarySize(locator, buffer, array.length);
        return buffer;
    }

    protected StringBuilder appendSummary(ObjectLocator locator, StringBuilder buffer, int[] array) {
        this.appendSummarySize(locator, buffer, array.length);
        return buffer;
    }

    protected StringBuilder appendSummary(ObjectLocator locator, StringBuilder buffer, long[] array) {
        this.appendSummarySize(locator, buffer, array.length);
        return buffer;
    }

    protected StringBuilder appendSummary(ObjectLocator locator, StringBuilder buffer, short[] array) {
        this.appendSummarySize(locator, buffer, array.length);
        return buffer;
    }

    protected StringBuilder appendSummary(ObjectLocator locator, StringBuilder buffer, Object[] array) {
        this.appendSummarySize(locator, buffer, array.length);
        return buffer;
    }

    protected StringBuilder appendSummary(ObjectLocator locator, StringBuilder buffer, Collection value) {
        this.appendSummarySize(locator, buffer, value.size());
        return buffer;
    }

    protected StringBuilder appendDetail(ObjectLocator locator, StringBuilder buffer, boolean[] array) {
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.append((ObjectLocator)LocatorUtils.item(locator, i, array[i]), buffer, array[i]);
        }
        buffer.append(this.arrayEnd);
        return buffer;
    }

    protected StringBuilder appendDetail(ObjectLocator locator, StringBuilder buffer, byte[] array) {
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.append((ObjectLocator)LocatorUtils.item(locator, i, array[i]), buffer, array[i]);
        }
        buffer.append(this.arrayEnd);
        return buffer;
    }

    protected StringBuilder appendDetail(ObjectLocator locator, StringBuilder buffer, char[] array) {
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.append((ObjectLocator)LocatorUtils.item(locator, i, array[i]), buffer, array[i]);
        }
        buffer.append(this.arrayEnd);
        return buffer;
    }

    protected StringBuilder appendDetail(ObjectLocator locator, StringBuilder buffer, double[] array) {
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.append((ObjectLocator)LocatorUtils.item(locator, i, array[i]), buffer, array[i]);
        }
        buffer.append(this.arrayEnd);
        return buffer;
    }

    protected StringBuilder appendDetail(ObjectLocator locator, StringBuilder buffer, float[] array) {
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.append((ObjectLocator)LocatorUtils.item(locator, i, array[i]), buffer, array[i]);
        }
        buffer.append(this.arrayEnd);
        return buffer;
    }

    protected StringBuilder appendDetail(ObjectLocator locator, StringBuilder buffer, int[] array) {
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.append((ObjectLocator)LocatorUtils.item(locator, i, array[i]), buffer, array[i]);
        }
        buffer.append(this.arrayEnd);
        return buffer;
    }

    protected StringBuilder appendDetail(ObjectLocator locator, StringBuilder buffer, long[] array) {
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.append((ObjectLocator)LocatorUtils.item(locator, i, array[i]), buffer, array[i]);
        }
        buffer.append(this.arrayEnd);
        return buffer;
    }

    protected StringBuilder appendDetail(ObjectLocator locator, StringBuilder buffer, short[] array) {
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.append((ObjectLocator)LocatorUtils.item(locator, i, array[i]), buffer, array[i]);
        }
        buffer.append(this.arrayEnd);
        return buffer;
    }

    protected StringBuilder appendDetail(ObjectLocator locator, StringBuilder buffer, Object[] array) {
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            Object item = array[i];
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            if (item == null) {
                this.appendNullText(buffer);
                continue;
            }
            this.append((ObjectLocator)LocatorUtils.item(locator, i, array[i]), buffer, array[i]);
        }
        buffer.append(this.arrayEnd);
        return buffer;
    }

    protected StringBuilder appendDetail(ObjectLocator locator, StringBuilder buffer, Collection array) {
        this.appendArrayStart(buffer);
        int i = 0;
        for (Object item : array) {
            if (i > 0) {
                this.appendArraySeparator(buffer);
            }
            this.append((ObjectLocator)LocatorUtils.item(locator, i, item), buffer, item);
            ++i;
        }
        this.appendArrayEnd(buffer);
        return buffer;
    }

    protected void removeLastFieldSeparator(StringBuilder buffer) {
        int len = buffer.length();
        int sepLen = this.fieldSeparator.length();
        if (len > 0 && sepLen > 0 && len >= sepLen) {
            boolean match = true;
            for (int i = 0; i < sepLen; ++i) {
                if (buffer.charAt(len - 1 - i) == this.fieldSeparator.charAt(sepLen - 1 - i)) continue;
                match = false;
                break;
            }
            if (match) {
                buffer.setLength(len - sepLen);
            }
        }
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, boolean value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, byte value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, char value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, double value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, float value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, int value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, long value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, short value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, Object value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, boolean[] value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, byte[] value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, char[] value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, double[] value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, float[] value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, int[] value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, long[] value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, short[] value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }

    @Override
    public StringBuilder appendField(ObjectLocator parentLocator, Object parent, String fieldName, StringBuilder stringBuilder, Object[] value, boolean valueSet) {
        this.appendFieldStart(parentLocator, parent, fieldName, stringBuilder, valueSet);
        this.append((ObjectLocator)LocatorUtils.property(parentLocator, fieldName, value), stringBuilder, value);
        this.appendFieldEnd(parentLocator, parent, fieldName, stringBuilder, valueSet);
        return stringBuilder;
    }
}

