/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.SchemaOutputResolver;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jvnet.basicjaxb.config.LocatorInputFactory;
import org.patrodyne.jvnet.basicjaxb.validation.SchemaOutputDomResolver;
import org.patrodyne.jvnet.basicjaxb.validation.SchemaOutputStringResolver;
import org.xml.sax.SAXException;

public class ContextUtils {
    public static final SchemaFactory XML_SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

    private ContextUtils() {
    }

    public static String getContextPath(Class<?> ... classes) {
        if (classes == null) {
            throw new IllegalArgumentException("The validated object is null");
        }
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i] != null) continue;
            throw new IllegalArgumentException("The validated array contains null element at index: " + i);
        }
        StringBuilder contextPath = new StringBuilder();
        for (int index = 0; index < classes.length; ++index) {
            if (index > 0) {
                contextPath.append(':');
            }
            contextPath.append(classes[index].getPackageName());
        }
        return contextPath.toString();
    }

    public static Marshaller createMarshaller(JAXBContext context, boolean formatted) throws JAXBException {
        if (context != null) {
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)formatted);
            return marshaller;
        }
        throw new JAXBException("Cannot create Marshaller because JAXBContext is null.");
    }

    public static Unmarshaller createUnmarshaller(JAXBContext context) throws JAXBException {
        if (context != null) {
            return context.createUnmarshaller();
        }
        throw new JAXBException("Cannot create Unmarshaller because JAXBContext is null.");
    }

    public static String toString(JAXBContext context, Object object) throws JAXBException {
        Marshaller marshaller = ContextUtils.createMarshaller(context, true);
        return ContextUtils.toString(marshaller, object);
    }

    public static String toString(Marshaller marshaller, Object object) throws JAXBException {
        String xml = null;
        if (object != null) {
            try (StringWriter sw = new StringWriter();){
                marshaller.marshal(object, (Writer)sw);
                xml = sw.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return xml;
    }

    public static <T> T fromString(JAXBContext context, String xml, Class<?> clazz) throws JAXBException {
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return ContextUtils.fromString(unmarshaller, xml, clazz);
    }

    public static <T> T fromString(Unmarshaller unmarshaller, String xml) throws JAXBException {
        Object instance = null;
        if (xml != null) {
            try (StringReader reader = new StringReader(xml);){
                StreamSource streamSource = new StreamSource(reader);
                Object obj = unmarshaller.unmarshal((Source)streamSource);
                if (obj instanceof JAXBElement) {
                    JAXBElement jaxbElement = (JAXBElement)obj;
                    instance = jaxbElement.getValue();
                } else {
                    instance = obj;
                }
            }
        }
        return (T)instance;
    }

    public static <T> T fromString(Unmarshaller unmarshaller, String xml, Class<?> clazz) throws JAXBException {
        Object instance = null;
        if (xml != null) {
            try (StringReader reader = new StringReader(xml);){
                StreamSource streamSource = new StreamSource(reader);
                JAXBElement jaxbElement = unmarshaller.unmarshal((Source)streamSource, clazz);
                instance = jaxbElement.getValue();
            }
        }
        return (T)instance;
    }

    public static Schema enableXmlSchemaValidator(Unmarshaller unmarshaller, Marshaller marshaller, String ... schemaUrls) throws IOException, SAXException {
        Source[] sources = new StreamSource[schemaUrls.length];
        for (int index = 0; index < schemaUrls.length; ++index) {
            String schemaUrl = schemaUrls[index];
            InputStream is = LocatorInputFactory.createInputStream(schemaUrl);
            sources[index] = new StreamSource(is, schemaUrl);
        }
        Schema schema = XML_SCHEMA_FACTORY.newSchema(sources);
        for (Source source : sources) {
            ((StreamSource)source).getInputStream().close();
        }
        if (unmarshaller != null) {
            unmarshaller.setSchema(schema);
        }
        if (marshaller != null) {
            marshaller.setSchema(schema);
        }
        return schema;
    }

    public static SchemaOutputStringResolver createSchemaOutputStringResolver(JAXBContext jaxbContext) throws IOException {
        SchemaOutputStringResolver sosr = new SchemaOutputStringResolver();
        jaxbContext.generateSchema((SchemaOutputResolver)sosr);
        return sosr;
    }

    public static SchemaOutputDomResolver createSchemaOutputDomResolver(JAXBContext jaxbContext) throws IOException {
        SchemaOutputDomResolver sodr = new SchemaOutputDomResolver();
        jaxbContext.generateSchema((SchemaOutputResolver)sodr);
        return sodr;
    }

    public static Schema enableXmlSchemaValidator(Unmarshaller unmarshaller, Marshaller marshaller, JAXBContext jaxbContext) throws IOException, SAXException {
        SchemaOutputDomResolver sodr = ContextUtils.createSchemaOutputDomResolver(jaxbContext);
        Schema schema = XML_SCHEMA_FACTORY.newSchema(sodr.getDomSource());
        if (unmarshaller != null) {
            unmarshaller.setSchema(schema);
        }
        if (marshaller != null) {
            marshaller.setSchema(schema);
        }
        return schema;
    }
}

