/*
 * Decompiled with CFR 0.152.
 */
package org.parceler;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.parceler.ParcelWrapper;
import org.parceler.Parcels;
import org.parceler.Repository;

final class NonParcelRepository
implements Repository<Parcels.ParcelableFactory> {
    private static final NonParcelRepository INSTANCE = new NonParcelRepository();
    private final Map<Class, Parcels.ParcelableFactory> parcelableCollectionFactories = new HashMap<Class, Parcels.ParcelableFactory>();

    private NonParcelRepository() {
        this.parcelableCollectionFactories.put(List.class, new ListParcelableFactory());
        this.parcelableCollectionFactories.put(ArrayList.class, new ListParcelableFactory());
        this.parcelableCollectionFactories.put(Set.class, new SetParcelableFactory());
        this.parcelableCollectionFactories.put(HashSet.class, new SetParcelableFactory());
        this.parcelableCollectionFactories.put(SparseArray.class, new SparseArrayParcelableFactory());
        this.parcelableCollectionFactories.put(Map.class, new MapParcelableFactory());
        this.parcelableCollectionFactories.put(HashMap.class, new MapParcelableFactory());
        this.parcelableCollectionFactories.put(Integer.class, new IntegerParcelableFactory());
        this.parcelableCollectionFactories.put(Long.class, new LongParcelableFactory());
        this.parcelableCollectionFactories.put(Double.class, new DoubleParcelableFactory());
        this.parcelableCollectionFactories.put(Float.class, new FloatParcelableFactory());
        this.parcelableCollectionFactories.put(Byte.class, new ByteParcelableFactory());
        this.parcelableCollectionFactories.put(String.class, new StringParcelableFactory());
    }

    public static NonParcelRepository getInstance() {
        return INSTANCE;
    }

    @Override
    public Map<Class, Parcels.ParcelableFactory> get() {
        return this.parcelableCollectionFactories;
    }

    public static final class StringParcelable
    implements Parcelable,
    ParcelWrapper<String> {
        private String contents;
        public static final StringParcelableCreator CREATOR = new StringParcelableCreator();

        private StringParcelable(Parcel parcel) {
            this.contents = parcel.readString();
        }

        private StringParcelable(String contents) {
            this.contents = contents;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeString(this.contents);
        }

        public int describeContents() {
            return 0;
        }

        @Override
        public String getParcel() {
            return this.contents;
        }

        private static final class StringParcelableCreator
        implements Parcelable.Creator<StringParcelable> {
            private StringParcelableCreator() {
            }

            public StringParcelable createFromParcel(Parcel parcel) {
                return new StringParcelable(parcel);
            }

            public StringParcelable[] newArray(int size) {
                return new StringParcelable[size];
            }
        }
    }

    public static final class ByteParcelable
    implements Parcelable,
    ParcelWrapper<Byte> {
        private Byte contents;
        public static final ByteParcelableCreator CREATOR = new ByteParcelableCreator();

        private ByteParcelable(Parcel parcel) {
            this.contents = parcel.readInt() == 1 ? Byte.valueOf(parcel.readByte()) : null;
        }

        private ByteParcelable(Byte contents) {
            this.contents = contents;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            if (this.contents == null) {
                parcel.writeInt(-1);
            } else {
                parcel.writeInt(1);
                parcel.writeByte(this.contents.byteValue());
            }
        }

        public int describeContents() {
            return 0;
        }

        @Override
        public Byte getParcel() {
            return this.contents;
        }

        private static final class ByteParcelableCreator
        implements Parcelable.Creator<ByteParcelable> {
            private ByteParcelableCreator() {
            }

            public ByteParcelable createFromParcel(Parcel parcel) {
                return new ByteParcelable(parcel);
            }

            public ByteParcelable[] newArray(int size) {
                return new ByteParcelable[size];
            }
        }
    }

    public static final class FloatParcelable
    implements Parcelable,
    ParcelWrapper<Float> {
        private Float contents;
        public static final FloatParcelableCreator CREATOR = new FloatParcelableCreator();

        private FloatParcelable(Parcel parcel) {
            this.contents = parcel.readInt() == 1 ? Float.valueOf(parcel.readFloat()) : null;
        }

        private FloatParcelable(Float contents) {
            this.contents = contents;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            if (this.contents == null) {
                parcel.writeInt(-1);
            } else {
                parcel.writeInt(1);
                parcel.writeFloat(this.contents.floatValue());
            }
        }

        public int describeContents() {
            return 0;
        }

        @Override
        public Float getParcel() {
            return this.contents;
        }

        private static final class FloatParcelableCreator
        implements Parcelable.Creator<FloatParcelable> {
            private FloatParcelableCreator() {
            }

            public FloatParcelable createFromParcel(Parcel parcel) {
                return new FloatParcelable(parcel);
            }

            public FloatParcelable[] newArray(int size) {
                return new FloatParcelable[size];
            }
        }
    }

    public static final class DoubleParcelable
    implements Parcelable,
    ParcelWrapper<Double> {
        private Double contents;
        public static final DoubleParcelableCreator CREATOR = new DoubleParcelableCreator();

        private DoubleParcelable(Parcel parcel) {
            this.contents = parcel.readInt() == 1 ? Double.valueOf(parcel.readDouble()) : null;
        }

        private DoubleParcelable(Double contents) {
            this.contents = contents;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            if (this.contents == null) {
                parcel.writeInt(-1);
            } else {
                parcel.writeInt(1);
                parcel.writeDouble(this.contents.doubleValue());
            }
        }

        public int describeContents() {
            return 0;
        }

        @Override
        public Double getParcel() {
            return this.contents;
        }

        private static final class DoubleParcelableCreator
        implements Parcelable.Creator<DoubleParcelable> {
            private DoubleParcelableCreator() {
            }

            public DoubleParcelable createFromParcel(Parcel parcel) {
                return new DoubleParcelable(parcel);
            }

            public DoubleParcelable[] newArray(int size) {
                return new DoubleParcelable[size];
            }
        }
    }

    public static final class LongParcelable
    implements Parcelable,
    ParcelWrapper<Long> {
        private Long contents;
        public static final LongParcelableCreator CREATOR = new LongParcelableCreator();

        private LongParcelable(Parcel parcel) {
            this.contents = parcel.readInt() == 1 ? Long.valueOf(parcel.readLong()) : null;
        }

        private LongParcelable(Long contents) {
            this.contents = contents;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            if (this.contents == null) {
                parcel.writeInt(-1);
            } else {
                parcel.writeInt(1);
                parcel.writeLong(this.contents.longValue());
            }
        }

        public int describeContents() {
            return 0;
        }

        @Override
        public Long getParcel() {
            return this.contents;
        }

        private static final class LongParcelableCreator
        implements Parcelable.Creator<LongParcelable> {
            private LongParcelableCreator() {
            }

            public LongParcelable createFromParcel(Parcel parcel) {
                return new LongParcelable(parcel);
            }

            public LongParcelable[] newArray(int size) {
                return new LongParcelable[size];
            }
        }
    }

    public static final class IntegerParcelable
    implements Parcelable,
    ParcelWrapper<Integer> {
        private Integer contents;
        public static final IntegerParcelableCreator CREATOR = new IntegerParcelableCreator();

        private IntegerParcelable(Parcel parcel) {
            this.contents = parcel.readInt() == 1 ? Integer.valueOf(parcel.readInt()) : null;
        }

        private IntegerParcelable(Integer contents) {
            this.contents = contents;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            if (this.contents == null) {
                parcel.writeInt(-1);
            } else {
                parcel.writeInt(1);
                parcel.writeInt(this.contents.intValue());
            }
        }

        public int describeContents() {
            return 0;
        }

        @Override
        public Integer getParcel() {
            return this.contents;
        }

        private static final class IntegerParcelableCreator
        implements Parcelable.Creator<IntegerParcelable> {
            private IntegerParcelableCreator() {
            }

            public IntegerParcelable createFromParcel(Parcel parcel) {
                return new IntegerParcelable(parcel);
            }

            public IntegerParcelable[] newArray(int size) {
                return new IntegerParcelable[size];
            }
        }
    }

    public static final class SparseArrayParcelable
    implements Parcelable,
    ParcelWrapper<SparseArray> {
        private SparseArray contents;
        public static final SparseArrayCreator CREATOR = new SparseArrayCreator();

        private SparseArrayParcelable(Parcel parcel) {
            int size = parcel.readInt();
            if (size < 0) {
                this.contents = null;
            } else {
                this.contents = new SparseArray(size);
                for (int i = 0; i < size; ++i) {
                    int key = parcel.readInt();
                    this.contents.append(key, Parcels.unwrap(parcel.readParcelable(SparseArrayParcelable.class.getClassLoader())));
                }
            }
        }

        private SparseArrayParcelable(SparseArray contents) {
            this.contents = contents;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            if (this.contents == null) {
                parcel.writeInt(-1);
            } else {
                parcel.writeInt(this.contents.size());
                for (int i = 0; i < this.contents.size(); ++i) {
                    parcel.writeInt(this.contents.keyAt(i));
                    parcel.writeParcelable(Parcels.wrap(this.contents.valueAt(i)), flags);
                }
            }
        }

        public int describeContents() {
            return 0;
        }

        @Override
        public SparseArray getParcel() {
            return this.contents;
        }

        private static final class SparseArrayCreator
        implements Parcelable.Creator<SparseArrayParcelable> {
            private SparseArrayCreator() {
            }

            public SparseArrayParcelable createFromParcel(Parcel parcel) {
                return new SparseArrayParcelable(parcel);
            }

            public SparseArrayParcelable[] newArray(int size) {
                return new SparseArrayParcelable[size];
            }
        }
    }

    public static final class SetParcelable
    implements Parcelable,
    ParcelWrapper<Set> {
        private Set contents;
        public static final SetParcelableCreator CREATOR = new SetParcelableCreator();

        private SetParcelable(Parcel parcel) {
            int size = parcel.readInt();
            if (size < 0) {
                this.contents = null;
            } else {
                this.contents = new HashSet();
                for (int i = 0; i < size; ++i) {
                    this.contents.add(Parcels.unwrap(parcel.readParcelable(SetParcelable.class.getClassLoader())));
                }
            }
        }

        private SetParcelable(Set contents) {
            this.contents = contents;
        }

        public void writeToParcel(Parcel parcel$$16, int flags) {
            if (this.contents == null) {
                parcel$$16.writeInt(-1);
            } else {
                parcel$$16.writeInt(this.contents.size());
                for (Object c : this.contents) {
                    parcel$$16.writeParcelable(Parcels.wrap(c), flags);
                }
            }
        }

        public int describeContents() {
            return 0;
        }

        @Override
        public Set getParcel() {
            return this.contents;
        }

        private static final class SetParcelableCreator
        implements Parcelable.Creator<SetParcelable> {
            private SetParcelableCreator() {
            }

            public SetParcelable createFromParcel(Parcel parcel) {
                return new SetParcelable(parcel);
            }

            public SetParcelable[] newArray(int size) {
                return new SetParcelable[size];
            }
        }
    }

    public static final class MapParcelable
    implements Parcelable,
    ParcelWrapper<Map> {
        private Map<Object, Object> contents;
        public static final MapParcelableCreator CREATOR = new MapParcelableCreator();

        private MapParcelable(Parcel parcel) {
            int size = parcel.readInt();
            if (size < 0) {
                this.contents = null;
            } else {
                this.contents = new HashMap<Object, Object>();
                for (int i = 0; i < size; ++i) {
                    Parcelable key = parcel.readParcelable(MapParcelable.class.getClassLoader());
                    Parcelable value = parcel.readParcelable(MapParcelable.class.getClassLoader());
                    this.contents.put(Parcels.unwrap(key), Parcels.unwrap(value));
                }
            }
        }

        private MapParcelable(Map contents) {
            this.contents = contents;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            if (this.contents == null) {
                parcel.writeInt(-1);
            } else {
                parcel.writeInt(this.contents.size());
                for (Map.Entry<Object, Object> entry : this.contents.entrySet()) {
                    parcel.writeParcelable(Parcels.wrap(entry.getKey()), flags);
                    parcel.writeParcelable(Parcels.wrap(entry.getValue()), flags);
                }
            }
        }

        public int describeContents() {
            return 0;
        }

        @Override
        public Map getParcel() {
            return this.contents;
        }

        private static final class MapParcelableCreator
        implements Parcelable.Creator<MapParcelable> {
            private MapParcelableCreator() {
            }

            public MapParcelable createFromParcel(Parcel parcel$$17) {
                return new MapParcelable(parcel$$17);
            }

            public MapParcelable[] newArray(int size) {
                return new MapParcelable[size];
            }
        }
    }

    public static final class ListParcelable
    implements Parcelable,
    ParcelWrapper<List> {
        private List contents;
        public static final ListParcelableCreator CREATOR = new ListParcelableCreator();

        private ListParcelable(Parcel parcel) {
            int size = parcel.readInt();
            if (size < 0) {
                this.contents = null;
            } else {
                this.contents = new ArrayList();
                for (int i = 0; i < size; ++i) {
                    this.contents.add(Parcels.unwrap(parcel.readParcelable(SparseArrayParcelableFactory.class.getClassLoader())));
                }
            }
        }

        private ListParcelable(List contents) {
            this.contents = contents;
        }

        public void writeToParcel(Parcel parcel$$16, int flags) {
            if (this.contents == null) {
                parcel$$16.writeInt(-1);
            } else {
                parcel$$16.writeInt(this.contents.size());
                for (Object c : this.contents) {
                    parcel$$16.writeParcelable(Parcels.wrap(c), flags);
                }
            }
        }

        public int describeContents() {
            return 0;
        }

        @Override
        public List getParcel() {
            return this.contents;
        }

        private static final class ListParcelableCreator
        implements Parcelable.Creator<ListParcelable> {
            private ListParcelableCreator() {
            }

            public ListParcelable createFromParcel(Parcel parcel) {
                return new ListParcelable(parcel);
            }

            public ListParcelable[] newArray(int size) {
                return new ListParcelable[size];
            }
        }
    }

    private static class StringParcelableFactory
    implements Parcels.ParcelableFactory<String> {
        private StringParcelableFactory() {
        }

        @Override
        public Parcelable buildParcelable(String input) {
            return new StringParcelable(input);
        }
    }

    private static class ByteParcelableFactory
    implements Parcels.ParcelableFactory<Byte> {
        private ByteParcelableFactory() {
        }

        @Override
        public Parcelable buildParcelable(Byte input) {
            return new ByteParcelable(input);
        }
    }

    private static class FloatParcelableFactory
    implements Parcels.ParcelableFactory<Float> {
        private FloatParcelableFactory() {
        }

        @Override
        public Parcelable buildParcelable(Float input) {
            return new FloatParcelable(input);
        }
    }

    private static class DoubleParcelableFactory
    implements Parcels.ParcelableFactory<Double> {
        private DoubleParcelableFactory() {
        }

        @Override
        public Parcelable buildParcelable(Double input) {
            return new DoubleParcelable(input);
        }
    }

    private static class LongParcelableFactory
    implements Parcels.ParcelableFactory<Long> {
        private LongParcelableFactory() {
        }

        @Override
        public Parcelable buildParcelable(Long input) {
            return new LongParcelable(input);
        }
    }

    private static class IntegerParcelableFactory
    implements Parcels.ParcelableFactory<Integer> {
        private IntegerParcelableFactory() {
        }

        @Override
        public Parcelable buildParcelable(Integer input) {
            return new IntegerParcelable(input);
        }
    }

    private static class SparseArrayParcelableFactory
    implements Parcels.ParcelableFactory<SparseArray> {
        private SparseArrayParcelableFactory() {
        }

        @Override
        public Parcelable buildParcelable(SparseArray input) {
            return new SparseArrayParcelable(input);
        }
    }

    private static class MapParcelableFactory
    implements Parcels.ParcelableFactory<Map> {
        private MapParcelableFactory() {
        }

        @Override
        public Parcelable buildParcelable(Map input) {
            return new MapParcelable(input);
        }
    }

    private static class SetParcelableFactory
    implements Parcels.ParcelableFactory<Set> {
        private SetParcelableFactory() {
        }

        @Override
        public Parcelable buildParcelable(Set input) {
            return new SetParcelable(input);
        }
    }

    private static class ListParcelableFactory
    implements Parcels.ParcelableFactory<List> {
        private ListParcelableFactory() {
        }

        @Override
        public Parcelable buildParcelable(List input) {
            return new ListParcelable(input);
        }
    }
}

