/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.Types;

class ImplicitActionsConverter
implements RuleMethodProcessor {
    private final Set<InstructionGraphNode> covered = new HashSet<InstructionGraphNode>();
    private RuleMethod method;

    ImplicitActionsConverter() {
    }

    @Override
    public boolean appliesTo(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        Preconditions.checkArgNotNull((Object)((Object)parserClassNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)ruleMethod), (String)"method");
        return ruleMethod.containsImplicitActions();
    }

    @Override
    public void process(ParserClassNode parserClassNode, RuleMethod ruleMethod) throws Exception {
        this.method = (RuleMethod)((Object)Preconditions.checkArgNotNull((Object)((Object)ruleMethod), (String)"method"));
        this.covered.clear();
        this.walkNode(ruleMethod.getReturnInstructionNode());
        ruleMethod.setContainsImplicitActions(false);
    }

    private void walkNode(InstructionGraphNode instructionGraphNode) {
        if (this.covered.contains((Object)instructionGraphNode)) {
            return;
        }
        this.covered.add(instructionGraphNode);
        if (this.isImplicitAction(instructionGraphNode)) {
            this.replaceWithActionWrapper(instructionGraphNode);
            this.method.setContainsExplicitActions(true);
            return;
        }
        if (!instructionGraphNode.isActionRoot()) {
            for (InstructionGraphNode instructionGraphNode2 : instructionGraphNode.getPredecessors()) {
                this.walkNode(instructionGraphNode2);
            }
        }
    }

    private void replaceWithActionWrapper(InstructionGraphNode instructionGraphNode) {
        MethodInsnNode methodInsnNode = this.createActionWrappingInsn();
        this.method.instructions.set(instructionGraphNode.getInstruction(), (AbstractInsnNode)methodInsnNode);
        instructionGraphNode.setIsActionRoot();
        instructionGraphNode.setInstruction((AbstractInsnNode)methodInsnNode);
    }

    private boolean isImplicitAction(InstructionGraphNode instructionGraphNode) {
        if (!AsmUtils.isBooleanValueOfZ(instructionGraphNode.getInstruction())) {
            return false;
        }
        List<InstructionGraphNode> list = this.getDependents(instructionGraphNode);
        if (list.size() != 1) {
            return false;
        }
        InstructionGraphNode instructionGraphNode2 = list.get(0);
        return this.isObjectArgumentToRuleCreatingMethodCall(instructionGraphNode, instructionGraphNode2) || this.isStoredIntoObjectArray(instructionGraphNode2);
    }

    private boolean isObjectArgumentToRuleCreatingMethodCall(InstructionGraphNode instructionGraphNode, InstructionGraphNode instructionGraphNode2) {
        AbstractInsnNode abstractInsnNode = instructionGraphNode2.getInstruction();
        if (abstractInsnNode.getType() != 5) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        if (!Types.RULE.equals((Object)Type.getReturnType((String)methodInsnNode.desc))) {
            return false;
        }
        Type[] typeArray = Type.getArgumentTypes((String)methodInsnNode.desc);
        int n = this.getArgumentIndex(instructionGraphNode2, instructionGraphNode);
        Preconditions.checkState((n < typeArray.length ? 1 : 0) != 0);
        return "java/lang/Object".equals(typeArray[n].getInternalName());
    }

    private boolean isStoredIntoObjectArray(InstructionGraphNode instructionGraphNode) {
        AbstractInsnNode abstractInsnNode = instructionGraphNode.getInstruction();
        if (abstractInsnNode.getOpcode() != 83) {
            return false;
        }
        List<InstructionGraphNode> list = this.getDependents(instructionGraphNode);
        Preconditions.checkState((list.size() == 1 ? 1 : 0) != 0);
        AbstractInsnNode abstractInsnNode2 = list.get(0).getInstruction();
        Preconditions.checkState((abstractInsnNode2.getOpcode() == 189 ? 1 : 0) != 0);
        return "java/lang/Object".equals(((TypeInsnNode)abstractInsnNode2).desc);
    }

    private int getArgumentIndex(InstructionGraphNode instructionGraphNode, InstructionGraphNode instructionGraphNode2) {
        int n;
        for (int i = n = instructionGraphNode.getInstruction().getOpcode() == 184 ? 0 : 1; i < instructionGraphNode.getPredecessors().size(); ++i) {
            InstructionGraphNode instructionGraphNode3 = instructionGraphNode.getPredecessors().get(i);
            if (!instructionGraphNode2.equals((Object)instructionGraphNode3)) continue;
            return i - n;
        }
        throw new IllegalStateException();
    }

    private List<InstructionGraphNode> getDependents(InstructionGraphNode instructionGraphNode) {
        ArrayList<InstructionGraphNode> arrayList = new ArrayList<InstructionGraphNode>();
        int n = 0;
        for (InstructionGraphNode instructionGraphNode2 : this.method.getGraphNodes()) {
            if (instructionGraphNode2 == null) {
                AbstractInsnNode abstractInsnNode = this.method.instructions.get(n);
                if (abstractInsnNode == null) {
                    throw new IllegalStateException("sparse instruction node graph, missing node and missing instruction for index: " + n);
                }
                String string = this.method.name;
                String string2 = this.method.desc;
                int n2 = abstractInsnNode.getOpcode();
                int n3 = abstractInsnNode.getType();
                String string3 = "sparse instruction node graph, missing node for method: %s( %s ), having instruction at index: %d, with opcode: %d , type: %d";
                throw new IllegalStateException(String.format(string3, string, string2, n, n2, n3));
            }
            if (instructionGraphNode2.getPredecessors().contains((Object)instructionGraphNode)) {
                arrayList.add(instructionGraphNode2);
            }
            ++n;
        }
        return arrayList;
    }

    private MethodInsnNode createActionWrappingInsn() {
        return new MethodInsnNode(184, Types.BASE_PARSER.getInternalName(), "ACTION", "(Z)" + Types.ACTION_DESC, false);
    }
}

