/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.parboiled.common.ImmutableList;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.ActionClassGenerator;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.BodyWithSuperCallReplacer;
import org.parboiled.transform.CachingGenerator;
import org.parboiled.transform.ClassNodeInitializer;
import org.parboiled.transform.ConstructorGenerator;
import org.parboiled.transform.FlagMarkingGenerator;
import org.parboiled.transform.ImplicitActionsConverter;
import org.parboiled.transform.InstructionGraphCreator;
import org.parboiled.transform.InstructionGroupCreator;
import org.parboiled.transform.InstructionGroupPreparer;
import org.parboiled.transform.LabellingGenerator;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.ReturnInstructionUnifier;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.RuleMethodRewriter;
import org.parboiled.transform.SuperCallRewriter;
import org.parboiled.transform.UnusedLabelsRemover;
import org.parboiled.transform.VarFramingGenerator;
import org.parboiled.transform.VarInitClassGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserTransformer {
    private ParserTransformer() {
    }

    public static synchronized <T> Class<? extends T> transformParser(Class<T> parserClass) throws Exception {
        Preconditions.checkArgNotNull(parserClass, (String)"parserClass");
        Class<?> extendedClass = AsmUtils.findLoadedClass(AsmUtils.getExtendedParserClassName(parserClass.getName()), parserClass.getClassLoader());
        return extendedClass != null ? extendedClass : ParserTransformer.extendParserClass(parserClass).getExtendedClass();
    }

    static ParserClassNode extendParserClass(Class<?> parserClass) throws Exception {
        ParserClassNode classNode = new ParserClassNode(parserClass);
        new ClassNodeInitializer().process(classNode);
        ParserTransformer.runMethodTransformers(classNode);
        new ConstructorGenerator().process(classNode);
        ParserTransformer.defineExtendedParserClass(classNode);
        return classNode;
    }

    private static void runMethodTransformers(ParserClassNode classNode) throws Exception {
        List<RuleMethodProcessor> methodProcessors = ParserTransformer.createRuleMethodProcessors();
        for (RuleMethod ruleMethod : classNode.getRuleMethods().values()) {
            if (ruleMethod.hasDontExtend()) continue;
            for (RuleMethodProcessor methodProcessor : methodProcessors) {
                if (!methodProcessor.appliesTo(classNode, ruleMethod)) continue;
                methodProcessor.process(classNode, ruleMethod);
            }
        }
        for (RuleMethod ruleMethod : classNode.getRuleMethods().values()) {
            if (ruleMethod.isGenerationSkipped()) continue;
            classNode.methods.add(ruleMethod);
        }
    }

    static List<RuleMethodProcessor> createRuleMethodProcessors() {
        return ImmutableList.of((Object[])new RuleMethodProcessor[]{new UnusedLabelsRemover(), new ReturnInstructionUnifier(), new InstructionGraphCreator(), new ImplicitActionsConverter(), new InstructionGroupCreator(), new InstructionGroupPreparer(), new ActionClassGenerator(false), new VarInitClassGenerator(false), new RuleMethodRewriter(), new SuperCallRewriter(), new BodyWithSuperCallReplacer(), new VarFramingGenerator(), new LabellingGenerator(), new FlagMarkingGenerator(), new CachingGenerator()});
    }

    private static void defineExtendedParserClass(ParserClassNode classNode) {
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        classNode.setClassCode(classWriter.toByteArray());
        classNode.setExtendedClass(AsmUtils.loadClass(classNode.name.replace('/', '.'), classNode.getClassCode(), classNode.getParentClass().getClassLoader()));
    }
}

