/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.impl;

import java.util.Optional;
import org.apache.commons.lang.RandomStringUtils;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.profile.SAML2Profile;
import org.pac4j.saml.sso.SAML2ObjectBuilder;
import org.pac4j.saml.util.Configuration;

public class SAML2LogoutRequestBuilder
implements SAML2ObjectBuilder<LogoutRequest> {
    private String bindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private int issueInstantSkewSeconds = 0;
    private final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();

    public SAML2LogoutRequestBuilder(String bindingType) {
        this.bindingType = bindingType;
    }

    @Override
    public LogoutRequest build(SAML2MessageContext context) {
        SingleLogoutService ssoService = context.getIDPSingleLogoutService(this.bindingType);
        AssertionConsumerService assertionConsumerService = context.getSPAssertionConsumerService();
        return this.buildLogoutRequest(context, assertionConsumerService, ssoService);
    }

    protected final LogoutRequest buildLogoutRequest(SAML2MessageContext context, AssertionConsumerService assertionConsumerService, SingleLogoutService ssoService) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(LogoutRequest.DEFAULT_ELEMENT_NAME);
        LogoutRequest request = (LogoutRequest)builder.buildObject();
        SAMLSelfEntityContext selfContext = context.getSAMLSelfEntityContext();
        request.setID(this.generateID());
        request.setIssuer(this.getIssuer(selfContext.getEntityId()));
        request.setIssueInstant(DateTime.now().plusSeconds(this.issueInstantSkewSeconds));
        request.setVersion(SAMLVersion.VERSION_20);
        request.setDestination(ssoService.getLocation());
        ProfileManager manager = new ProfileManager(context.getWebContext());
        Optional p = manager.get(true);
        if (p.isPresent() && p.get() instanceof SAML2Profile) {
            SAML2Profile samlP = (SAML2Profile)((Object)p.get());
            SAMLObjectBuilder nameIdBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(NameID.DEFAULT_ELEMENT_NAME);
            NameID nameId = (NameID)nameIdBuilder.buildObject();
            nameId.setValue(samlP.getId());
            nameId.setFormat(samlP.getSamlNameIdFormat());
            nameId.setNameQualifier(samlP.getSamlNameIdNameQualifier());
            nameId.setSPNameQualifier(samlP.getSamlNameIdSpNameQualifier());
            nameId.setSPProvidedID(samlP.getSamlNameIdSpProviderId());
            request.setNameID(nameId);
            String sessIdx = (String)samlP.getAttribute("sessionindex");
            SAMLObjectBuilder sessionIndexBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(SessionIndex.DEFAULT_ELEMENT_NAME);
            SessionIndex sessionIdx = (SessionIndex)sessionIndexBuilder.buildObject();
            sessionIdx.setSessionIndex(sessIdx);
            request.getSessionIndexes().add(sessionIdx);
        }
        return request;
    }

    protected final Issuer getIssuer(String spEntityId) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(spEntityId);
        return issuer;
    }

    protected final String generateID() {
        return "_".concat(RandomStringUtils.randomAlphanumeric((int)39)).toLowerCase();
    }

    public void setIssueInstantSkewSeconds(int issueInstantSkewSeconds) {
        this.issueInstantSkewSeconds = issueInstantSkewSeconds;
    }
}

