/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile.converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.FormattedDate;
import org.pac4j.core.profile.converter.AttributeConverter;

public class OidcLongTimeConverter
implements AttributeConverter<Date> {
    public Date convert(Object attribute) {
        if (attribute instanceof Long) {
            long seconds = (Long)attribute;
            return new FormattedDate(new Date(seconds * 1000L), "yyyy-MM-dd'T'HH:mm:ssz", Locale.getDefault());
        }
        if (attribute instanceof String) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
            try {
                return new FormattedDate(sdf.parse((String)attribute), "yyyy-MM-dd'T'HH:mm:ssz", Locale.getDefault());
            }
            catch (ParseException e) {
                throw new TechnicalException((Throwable)e);
            }
        }
        if (attribute instanceof FormattedDate) {
            return (Date)attribute;
        }
        return null;
    }
}

