/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jee.context;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextHelper;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;

@Deprecated
public class JEEContext
implements WebContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private String body;
    private String savedAuthenticateHeader = null;

    public JEEContext(HttpServletRequest request, HttpServletResponse response) {
        CommonHelper.assertNotNull((String)"request", (Object)request);
        CommonHelper.assertNotNull((String)"response", (Object)response);
        this.request = request;
        this.response = response;
    }

    public Optional<String> getRequestParameter(String name) {
        return Optional.ofNullable(this.request.getParameter(name));
    }

    public Optional getRequestAttribute(String name) {
        return Optional.ofNullable(this.request.getAttribute(name));
    }

    public void setRequestAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public Map<String, String[]> getRequestParameters() {
        return this.request.getParameterMap();
    }

    public Optional<String> getRequestHeader(String name) {
        Enumeration names = this.request.getHeaderNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String headerName = (String)names.nextElement();
                if (headerName == null || !headerName.equalsIgnoreCase(name)) continue;
                return Optional.ofNullable(this.request.getHeader(headerName));
            }
        }
        return Optional.empty();
    }

    public String getRequestMethod() {
        return this.request.getMethod();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public HttpServletRequest getNativeRequest() {
        return this.request;
    }

    public HttpServletResponse getNativeResponse() {
        return this.response;
    }

    public void setResponseHeader(String name, String value) {
        if ("WWW-Authenticate".equals(name)) {
            this.savedAuthenticateHeader = value;
        } else {
            this.response.setHeader(name, value);
        }
    }

    public Optional<String> getResponseHeader(String name) {
        if ("WWW-Authenticate".equals(name)) {
            return Optional.ofNullable(this.savedAuthenticateHeader);
        }
        return Optional.ofNullable(this.response.getHeader(name));
    }

    public void setResponseContentType(String content) {
        this.response.setContentType(content);
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public String getRequestURL() {
        String url = this.request.getRequestURL().toString();
        int idx = url.indexOf(63);
        if (idx != -1) {
            return url.substring(0, idx);
        }
        return url;
    }

    public String getFullRequestURL() {
        StringBuffer requestURL = this.request.getRequestURL();
        String queryString = this.request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.toString() + "?" + queryString;
    }

    public Collection<Cookie> getRequestCookies() {
        LinkedHashSet<Cookie> pac4jCookies = new LinkedHashSet<Cookie>();
        javax.servlet.http.Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (javax.servlet.http.Cookie c : cookies) {
                Cookie cookie = new Cookie(c.getName(), c.getValue());
                cookie.setDomain(c.getDomain());
                cookie.setHttpOnly(c.isHttpOnly());
                cookie.setMaxAge(c.getMaxAge());
                cookie.setPath(c.getPath());
                cookie.setSecure(c.getSecure());
                pac4jCookies.add(cookie);
            }
        }
        return pac4jCookies;
    }

    public void addResponseCookie(Cookie cookie) {
        this.response.addHeader("Set-Cookie", WebContextHelper.createCookieHeader((Cookie)cookie));
    }

    public String getPath() {
        String context;
        String fullPath = this.request.getRequestURI();
        if (fullPath == null) {
            return "";
        }
        if (fullPath.startsWith("//")) {
            fullPath = fullPath.substring(1);
        }
        if ((context = this.request.getContextPath()) != null) {
            return fullPath.substring(context.length());
        }
        return fullPath;
    }

    public String getRequestContent() {
        if (this.body == null) {
            try {
                this.body = this.request.getReader().lines().reduce("", String::concat);
            }
            catch (IOException e) {
                throw new TechnicalException((Throwable)e);
            }
        }
        return this.body;
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public Optional<String> getQueryString() {
        return Optional.ofNullable(this.request.getQueryString());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSavedAuthenticateHeader() {
        return this.savedAuthenticateHeader;
    }
}

