/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client.direct;

import org.pac4j.cas.authorization.DefaultCasAuthorizationGenerator;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.cas.credentials.authenticator.CasAuthenticator;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.ParameterExtractor;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;

public class DirectCasProxyClient
extends DirectClient<TokenCredentials, CommonProfile> {
    private CasConfiguration configuration;
    private String serviceUrl;

    public DirectCasProxyClient() {
    }

    public DirectCasProxyClient(CasConfiguration casConfiguration, String serviceUrl) {
        this.configuration = casConfiguration;
        this.serviceUrl = serviceUrl;
    }

    protected void clientInit(WebContext context) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        CommonHelper.assertNotBlank((String)"serviceUrl", (String)this.serviceUrl);
        CasProtocol protocol = this.configuration.getProtocol();
        CommonHelper.assertTrue((protocol == CasProtocol.CAS20_PROXY || protocol == CasProtocol.CAS30_PROXY ? 1 : 0) != 0, (String)"The DirectCasProxyClient must be configured with a CAS proxy protocol (CAS20_PROXY or CAS30_PROXY)");
        this.configuration.init(context);
        this.defaultCredentialsExtractor((CredentialsExtractor)new ParameterExtractor("ticket", true, false, this.getName()));
        this.defaultAuthenticator(new CasAuthenticator(this.configuration, this.serviceUrl));
        this.addAuthorizationGenerator(new DefaultCasAuthorizationGenerator());
    }

    public CasConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CasConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"configuration", this.configuration, "serviceUrl", this.serviceUrl});
    }
}

